/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.completion;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.jetbrains.cidr.lang.editor.completion.CallableInsertUtils;
import com.jetbrains.cidr.lang.symbols.cpp.OCMacroSymbol;
import com.jetbrains.cidr.lang.util.OCImmutableList;

public class MacroInsertHandler
implements InsertHandler<LookupElement> {
    private final OCMacroSymbol mySymbol;

    public MacroInsertHandler(OCMacroSymbol symbol) {
        this.mySymbol = symbol;
    }

    public void handleInsert(InsertionContext context, LookupElement item) {
        if (this.mySymbol.hasParameterList()) {
            boolean hasParams = !this.mySymbol.getParameterNames().isEmpty();
            CallableInsertUtils.addParensIfRequired(context, item, hasParams);
            if (hasParams && CallableInsertUtils.shouldInsertPlaceholders(context)) {
                StringBuilder insertion = new StringBuilder();
                OCImmutableList<String> params = this.mySymbol.getParameterNames();
                boolean isVararg = this.mySymbol.isVararg();
                int paramCount = params.size();
                int varargIdx = isVararg ? paramCount - 1 : Integer.MAX_VALUE;
                for (int i2 = 0; i2 < paramCount; ++i2) {
                    String param = (String)params.get(i2);
                    if (i2 > 0) {
                        insertion.append(", ");
                    }
                    if (i2 == 0 || i2 < varargIdx) {
                        insertion.append("<#");
                    }
                    insertion.append("__VA_ARGS__...".equals(param) ? "..." : param);
                    if (i2 == varargIdx - 1) continue;
                    insertion.append("#>");
                }
                context.getDocument().insertString(context.getEditor().getCaretModel().getOffset(), (CharSequence)insertion);
                CallableInsertUtils.selectFirstPlaceholderIfPresent(context);
            }
            if (hasParams) {
                AutoPopupController.getInstance(context.getProject()).autoPopupParameterInfo(context.getEditor(), null);
            }
        }
    }
}

