/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.completion;

import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.folding.CodeFoldingManager;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.text.CharArrayUtil;
import com.jetbrains.cidr.lang.editor.completion.CallableInsertUtils;
import com.jetbrains.cidr.lang.editor.completion.MethodSelectorCompletionContributor;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCBlockExpression;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCExpressionStatement;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCImplementation;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.OCMessageArgument;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCMethodSelectorPart;
import com.jetbrains.cidr.lang.psi.OCNSArrayLiteral;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.quickfixes.OCImportSymbolFix;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.OCFileSymbols;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class MethodInsertHandler
implements InsertHandler<LookupElement> {
    @NotNull
    protected final OCMethodSymbol mySymbol;
    private final PsiElement myContextExpression;
    private final boolean myInsideSendMessage;
    private final String myQualifier;

    MethodInsertHandler(@NotNull OCMethodSymbol symbol, PsiElement contextExpression, boolean insideSendMessage, String qualifier) {
        this.mySymbol = symbol;
        this.myContextExpression = contextExpression;
        this.myInsideSendMessage = insideSendMessage;
        this.myQualifier = qualifier;
    }

    protected String getInsertion(InsertionContext context, LookupElement item) {
        OCMethod method2;
        int endOffset;
        StringBuilder insertion = new StringBuilder();
        Document document = context.getDocument();
        PsiFile file2 = context.getFile();
        CaretModel caretModel = context.getEditor().getCaretModel();
        String defaultInsertion = item.getLookupString();
        boolean isInDeclarationContext = this.isInDeclarationContext();
        insertion.append(this.myQualifier);
        if (!this.myQualifier.isEmpty()) {
            insertion.append(' ');
        }
        OCSendMessageExpression expr = null;
        OCElement body2 = null;
        int caretOffset = caretModel.getOffset() - defaultInsertion.length();
        if (this.myQualifier.isEmpty() && context.getCompletionChar() == '\t') {
            caretModel.moveToOffset(caretOffset);
            document.replaceString(caretOffset, caretOffset + defaultInsertion.length(), (CharSequence)"xxx");
            PsiDocumentManager.getInstance((Project)context.getProject()).commitAllDocuments();
            if (isInDeclarationContext) {
                OCMethod method3 = (OCMethod)PsiTreeUtil.getParentOfType((PsiElement)file2.findElementAt(caretOffset), OCMethod.class, (boolean)true, (Class[])new Class[]{OCImplementation.class});
                body2 = method3 != null ? method3.getBody() : null;
            } else {
                expr = MethodInsertHandler.getSendMessage(file2, caretOffset);
            }
        }
        List<OCMessageArgument> args = expr != null ? expr.getArguments() : null;
        List<OCMethodSymbol.SelectorPartSymbol> selectors = this.mySymbol.getSelectors();
        int idx = 0;
        int varargIdx = this.mySymbol.isVararg() ? selectors.size() - 1 : Integer.MAX_VALUE;
        boolean template = !isInDeclarationContext;
        for (int i2 = 0; i2 < selectors.size(); ++i2) {
            OCElement argument;
            OCMethodSymbol.SelectorPartSymbol selector2 = selectors.get(i2);
            if (i2 > 0) {
                insertion.append(' ');
            }
            insertion.append(selector2.getSelectorName());
            OCDeclaratorSymbol p = selector2.getParameter();
            if (p == null) continue;
            OCElement oCElement = argument = args == null || idx >= args.size() ? null : args.get(idx++).getArgumentExpression();
            if (argument != null) {
                insertion.append(argument.getTextWithMacros());
                continue;
            }
            if (template) {
                insertion.append("<#");
            }
            MethodInsertHandler.appendParameterName(insertion, file2, p);
            if (i2 == varargIdx) {
                insertion.append(", ...");
            }
            if (!template) continue;
            insertion.append("#>");
        }
        if (expr != null) {
            endOffset = expr.getRangeWithMacros().getEndOffset();
            if (PsiTreeUtil.lastChild((PsiElement)expr).getText().endsWith("]")) {
                --endOffset;
            }
            context.setTailOffset(caretOffset);
            document.deleteString(caretOffset, endOffset);
        } else if (body2 != null) {
            endOffset = body2.getRangeWithMacros().getStartOffset();
            context.setTailOffset(endOffset);
        }
        if (isInDeclarationContext && (method2 = (OCMethod)PsiTreeUtil.getParentOfType((PsiElement)file2.findElementAt(caretOffset), OCMethod.class, (boolean)true, (Class[])new Class[]{OCImplementation.class})) != null && method2.getReturnTypeElement() == null) {
            insertion.insert(0, "(" + this.mySymbol.getEffectiveType().getBestNameInContext(method2, OCElementUtil.getReturnTypeText(this.mySymbol)) + ")");
        }
        if (this.isInDeclarationContext() && body2 == null) {
            OCCodeStyleSettings settings = (OCCodeStyleSettings)CodeStyleSettingsManager.getSettings((Project)context.getProject()).getCustomSettings(OCCodeStyleSettings.class);
            if (settings != null && settings.SEMICOLON_AFTER_METHOD_SIGNATURE) {
                insertion.append(";");
            }
            insertion.append("{ }");
        } else if (!this.myQualifier.isEmpty() && !this.myInsideSendMessage) {
            insertion.append(']');
        }
        return insertion.toString();
    }

    public void handleInsert(InsertionContext context, LookupElement item) {
        if (this.isInDeclarationContext()) {
            Document document = context.getDocument();
            String insertion = this.getInsertion(context, item);
            document.replaceString(context.getStartOffset(), context.getTailOffset(), (CharSequence)insertion);
            CallableInsertUtils.moveCaretToCallableBody(context);
            OCChangeUtil.reformatTextIfNotInjected(context.getFile(), context.getStartOffset(), context.getStartOffset() + insertion.length());
        } else {
            this.handleCall(context, item);
        }
    }

    public void handleCall(InsertionContext context, LookupElement item) {
        int tailOffset;
        Document document = context.getDocument();
        Editor editor = context.getEditor();
        String insertion = this.getInsertion(context, item);
        document.replaceString(context.getStartOffset(), context.getTailOffset(), (CharSequence)insertion);
        PsiDocumentManager pdm = PsiDocumentManager.getInstance((Project)context.getProject());
        pdm.commitDocument(document);
        this.postInsertionHook(context, item);
        CodeFoldingManager foldManager = CodeFoldingManager.getInstance(context.getProject());
        foldManager.updateFoldRegions(editor);
        String documentText = document.getText();
        int firstParamStart = documentText.indexOf("<#", context.getStartOffset());
        int firstParamEnd = documentText.indexOf("#>", firstParamStart);
        SelectionModel selectionModel = editor.getSelectionModel();
        if (firstParamStart >= 0 && firstParamEnd >= 0 && firstParamStart < context.getTailOffset()) {
            selectionModel.setSelection(firstParamStart, firstParamEnd + 2);
        }
        char nextChar = '\u0000';
        for (tailOffset = context.getTailOffset(); tailOffset < document.getTextLength() && Character.isSpaceChar(nextChar = (char)documentText.charAt(tailOffset)) && nextChar != '\n'; ++tailOffset) {
            nextChar = '\u0000';
        }
        if (nextChar == ']') {
            PsiFile file2 = context.getFile();
            OCSendMessageExpression call = MethodInsertHandler.getSendMessage(file2, context.getStartOffset());
            OCSendMessageExpression tail = MethodInsertHandler.getSendMessage(file2, tailOffset);
            if (call != null && call == tail) {
                context.setTailOffset(++tailOffset);
            }
        }
        OCChangeUtil.reformatTextIfNotInjected(context.getFile(), context.getStartOffset(), tailOffset);
        if (firstParamStart >= 0 && firstParamEnd >= 0 && selectionModel.hasSelection()) {
            editor.getCaretModel().moveToOffset(selectionModel.getSelectionStart());
        } else {
            editor.getCaretModel().moveToOffset(context.getTailOffset());
        }
        if (!OCFileSymbols.isSymbolImported((OCFile)context.getFile(), this.mySymbol)) {
            OCImportSymbolFix.fixSymbolAtOffset(context.getEditor(), context.getFile(), context.getStartOffset(), this.mySymbol);
        }
        if (context.getCompletionChar() == '(' && insertion.endsWith(")") || context.getCompletionChar() == ']') {
            context.setAddCompletionChar(false);
        }
    }

    protected void postInsertionHook(InsertionContext context, LookupElement item) {
        String insertion;
        PsiElement prev;
        Document document = context.getDocument();
        PsiFile file2 = context.getFile();
        MethodSelectorCompletionContributor.Context completionCtx = (MethodSelectorCompletionContributor.Context)MethodSelectorCompletionContributor.CONTEXT.get((UserDataHolder)item);
        PsiElement originalReceiver = completionCtx == null ? null : completionCtx.getReceiver();
        int autoOpenOffset = -1;
        if (this.myContextExpression instanceof OCQualifiedExpression) {
            if (this.mySymbol.isGetter() && context.getCompletionChar() != ']') {
                return;
            }
            TextRange range = ((OCQualifiedExpression)this.myContextExpression).getQualifyingToken().getTextRange();
            document.replaceString(range.getStartOffset(), range.getEndOffset(), (CharSequence)" ");
            autoOpenOffset = this.myContextExpression.getTextRange().getStartOffset();
        } else if (originalReceiver != null && ((prev = OCElementUtil.getPrevSignificantSibling(originalReceiver)) == null || prev.getNode().getElementType() != OCTokenTypes.LBRACKET || prev.getParent() instanceof OCNSArrayLiteral)) {
            OCElement receiver2;
            TextRange originalRange = originalReceiver.getTextRange();
            CharSequence docText = document.getCharsSequence();
            int nonWs = CharArrayUtil.shiftBackward((CharSequence)docText, (int)(context.getStartOffset() - 1), (String)" \t\n");
            Class stopAt = originalReceiver instanceof OCBlockExpression ? OCCallable.class : OCBlockStatement.class;
            for (receiver2 = (OCElement)PsiTreeUtil.findElementOfClassAtOffsetWithStopSet((PsiFile)file2, (int)nonWs, OCExpression.class, (boolean)false, (Class[])new Class[]{stopAt}); !originalRange.isEmpty() && receiver2 != null && receiver2.getParent() instanceof OCExpression && receiver2.getTextRange().getLength() < originalRange.getLength(); receiver2 = (OCExpression)receiver2.getParent()) {
            }
            if (receiver2 == null) {
                receiver2 = (OCElement)PsiTreeUtil.findElementOfClassAtOffsetWithStopSet((PsiFile)file2, (int)nonWs, OCMacroCall.class, (boolean)false, (Class[])new Class[]{stopAt});
            }
            if (receiver2 != null) {
                autoOpenOffset = receiver2.getTextRange().getStartOffset();
            } else {
                OCTypeElement typeElement = (OCTypeElement)PsiTreeUtil.findElementOfClassAtOffsetWithStopSet((PsiFile)file2, (int)nonWs, OCTypeElement.class, (boolean)false, (Class[])new Class[]{OCCallable.class});
                if (typeElement != null) {
                    autoOpenOffset = typeElement.getTextRange().getStartOffset();
                }
            }
        }
        PsiDocumentManager pdm = PsiDocumentManager.getInstance((Project)context.getProject());
        if (autoOpenOffset >= 0) {
            document.insertString(autoOpenOffset, (CharSequence)"[");
            pdm.commitDocument(document);
            OCChangeUtil.reformatTextIfNotInjected(context.getFile(), autoOpenOffset, autoOpenOffset + 2);
        }
        if (!(insertion = document.getText(new TextRange(context.getStartOffset(), context.getTailOffset()))).endsWith("]")) {
            int tailOffset = context.getTailOffset();
            if (autoOpenOffset >= 0 || !MethodInsertHandler.nextIsAClosingBracket(file2, tailOffset)) {
                document.insertString(tailOffset, (CharSequence)"]");
                pdm.commitDocument(document);
                OCChangeUtil.reformatTextIfNotInjected(file2, tailOffset, tailOffset + 2);
            }
        }
        pdm.commitDocument(document);
        OCSendMessageExpression call = (OCSendMessageExpression)PsiTreeUtil.findElementOfClassAtOffsetWithStopSet((PsiFile)file2, (int)context.getStartOffset(), OCSendMessageExpression.class, (boolean)false, (Class[])new Class[]{OCCallable.class});
        if (call != null && this.mySymbol.getReturnType().isVoid() && call.getParent() instanceof OCExpressionStatement) {
            pdm.commitDocument(document);
            OCExpressionStatement st = (OCExpressionStatement)call.getParent();
            if (st != null && st.getNode().getLastChildNode().getElementType() != OCTokenTypes.SEMICOLON) {
                int endOffset = call.getTextRange().getEndOffset();
                document.insertString(endOffset, (CharSequence)";");
                context.setTailOffset(endOffset + 1);
            }
        }
    }

    private static boolean nextIsAClosingBracket(PsiFile file2, int offset) {
        PsiElement next;
        for (next = file2.findElementAt(offset); next != null && OCTokenTypes.WHITESPACES.contains(next.getNode().getElementType()); next = next.getNextSibling()) {
        }
        return next != null && next.getNode().getElementType() == OCTokenTypes.RBRACKET;
    }

    private boolean isInDeclarationContext() {
        if (this.myContextExpression == null) {
            return false;
        }
        PsiElement parent = this.myContextExpression.getParent();
        return parent instanceof OCMethodSelectorPart && parent.getParent() instanceof OCMethod;
    }

    protected static OCSendMessageExpression getSendMessage(PsiFile file2, int offset) {
        return (OCSendMessageExpression)PsiTreeUtil.getParentOfType((PsiElement)file2.findElementAt(offset), OCSendMessageExpression.class, (boolean)true, (Class[])new Class[]{OCCallable.class, OCQualifiedExpression.class});
    }

    protected static void appendParameterName(@NotNull StringBuilder insertion, @NotNull PsiFile file2, @NotNull OCDeclaratorSymbol p) {
        insertion.append("(").append(p.getType().getBestNameInContext((PsiElement)file2, OCElementUtil.getTypeTextWithModifiers(p))).append(')');
        if (!p.isUnnamed()) {
            insertion.append(p.getName());
        }
    }
}

