/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.completion;

import com.intellij.codeInsight.completion.CompletionLocation;
import com.intellij.codeInsight.completion.CompletionStatistician;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.statistics.StatisticsInfo;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCLocalizedStringSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbol;

public class OCCompletionStatistician
extends CompletionStatistician {
    public static Key<String> STATISTICIAN_TYPENAME_CONTEXT = Key.create((String)"STATISTICIAN_TYPENAME_CONTEXT");
    public static Key<String> STATISTICIAN_VALUE = Key.create((String)"STATISTICIAN_VALUE");

    public StatisticsInfo serialize(LookupElement element, CompletionLocation location) {
        OCQualifiedName qualifier;
        Object value2 = element.getObject();
        if (!(value2 instanceof OCSymbol)) {
            return null;
        }
        OCSymbol symbol = (OCSymbol)value2;
        if (symbol.getKind().isLocal()) {
            return StatisticsInfo.EMPTY;
        }
        if (location.getCompletionParameters().getOriginalFile() instanceof PsiCodeFragment) {
            return StatisticsInfo.EMPTY;
        }
        String keyValue = (String)element.getUserData(STATISTICIAN_VALUE);
        if (keyValue == null) {
            keyValue = element.getLookupString();
        }
        if (symbol instanceof OCLocalizedStringSymbol) {
            return new StatisticsInfo("completion#OC_LOCALIZED_STRING", keyValue);
        }
        if (symbol instanceof OCSymbolWithQualifiedName && (qualifier = ((OCSymbolWithQualifiedName)symbol).getQualifier()) != null) {
            String fqn = qualifier.getNameWithParent();
            return new StatisticsInfo("completion#OC_CPP#" + fqn, keyValue);
        }
        if (symbol instanceof OCMemberSymbol) {
            String typeName = (String)element.getUserData(STATISTICIAN_TYPENAME_CONTEXT);
            if (typeName == null) {
                typeName = ((OCClassSymbol)((OCMemberSymbol)symbol).getParent()).getName();
            }
            return new StatisticsInfo("completion#OC#" + typeName, keyValue);
        }
        return null;
    }
}

