/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.completion;

import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ProcessingContext;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.editor.completion.MethodSelectorCompletionContributor;
import com.jetbrains.cidr.lang.editor.completion.OCCompletionContributorBase;
import com.jetbrains.cidr.lang.editor.completion.OCCompletionParameters;
import com.jetbrains.cidr.lang.editor.completion.OCCompletionProvider;
import com.jetbrains.cidr.lang.editor.completion.OCSmartCompletionContributor;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCImplementation;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCMethodSelectorPart;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.symbols.objc.OCImplementationSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCObjectTypeContext;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class OCMethodImplementationCompletionContributor
extends OCCompletionContributorBase {
    public static final ElementPattern<PsiElement> SELECTOR_PART_DECLARATION = PlatformPatterns.psiElement((IElementType)OCTokenTypes.IDENTIFIER).withParent(OCMethodSelectorPart.class);

    public OCMethodImplementationCompletionContributor() {
        OCCompletionProvider provider2 = new OCCompletionProvider(){

            @Override
            protected void addCompletions(String prefix, @NotNull OCCompletionParameters parameters2, ProcessingContext context, CompletionResultSet result2) {
                PsiElement selector2 = parameters2.getPosition().getParent();
                if (selector2 instanceof OCMethodSelectorPart) {
                    OCMethod method2 = (OCMethod)selector2.getParent();
                    StringBuilder exactSelectorPrefixBuilder = new StringBuilder();
                    for (OCMethodSelectorPart arg : method2.getParameters()) {
                        if (arg == selector2) break;
                        exactSelectorPrefixBuilder.append(arg.getSelectorPart());
                    }
                    String exactSelectorPrefix = exactSelectorPrefixBuilder.toString();
                    PsiElement parent = method2.getParent();
                    if (parent instanceof OCImplementation) {
                        OCTypeElement typeElement;
                        OCImplementation impl = (OCImplementation)parent;
                        OCImplementationSymbol implementationSymbol = impl.getSymbol();
                        OCObjectType type2 = impl.getType();
                        if (type2 == null) {
                            return;
                        }
                        OCObjectTypeContext receiverContext = new OCObjectTypeContext(!method2.isInstanceMethod(), true, type2, null);
                        HashSet implemented = new HashSet();
                        if (implementationSymbol != null) {
                            implementationSymbol.processMembers((String)null, (Processor<OCMemberSymbol>)((Processor)symbol -> {
                                implemented.add(symbol.getSignature());
                                return true;
                            }));
                        }
                        Condition condition2 = symbol -> !implemented.contains(symbol.getSignature());
                        if (parameters2.getCompletionType() == CompletionType.SMART && (typeElement = method2.getReturnTypeElement()) != null) {
                            OCFile file2 = method2.getContainingOCFile();
                            OCType expectedType = typeElement.getType().resolve(file2);
                            if (expectedType != OCUnknownType.INSTANCE) {
                                condition2 = Conditions.and((Condition)condition2, new OCSmartCompletionContributor.TypeMatchingCondition(file2, selector2, expectedType, false, null));
                            }
                        }
                        MethodSelectorCompletionContributor.Context ctx = new MethodSelectorCompletionContributor.Context(exactSelectorPrefix, null, receiverContext, (Condition<OCMethodSymbol>)condition2);
                        OCMethodImplementationCompletionContributor.doAddCompletions(result2, parameters2, false, ctx);
                    }
                }
            }
        };
        this.register(CompletionType.BASIC, SELECTOR_PART_DECLARATION, provider2);
        this.register(CompletionType.SMART, SELECTOR_PART_DECLARATION, provider2);
    }

    private static int doAddCompletions(CompletionResultSet result2, OCCompletionParameters parameters2, boolean avoidNSObjectMethods, MethodSelectorCompletionContributor.Context context) {
        OCType nsobject;
        int[] addedCnt = new int[]{0};
        Processor<OCMethodSymbol> processor2 = MethodSelectorCompletionContributor.getProcessor(parameters2, result2, addedCnt, context);
        context.getReceiverContext().getType().processMembers(OCMethodSymbol.class, processor2);
        if (!avoidNSObjectMethods && (nsobject = OCReferenceType.fromText("NSObject").resolve(parameters2.getOriginalFile())) instanceof OCObjectType) {
            ((OCObjectType)nsobject).processMembers(OCMethodSymbol.class, processor2);
        }
        return addedCnt[0];
    }
}

