/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.completion;

import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ProcessingContext;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.editor.completion.MethodSelectorCompletionContributor;
import com.jetbrains.cidr.lang.editor.completion.OCCompletionContributorBase;
import com.jetbrains.cidr.lang.editor.completion.OCCompletionParameters;
import com.jetbrains.cidr.lang.editor.completion.OCCompletionPatterns;
import com.jetbrains.cidr.lang.editor.completion.OCCompletionPriority;
import com.jetbrains.cidr.lang.editor.completion.OCCompletionProvider;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCMethodSelectorPart;
import com.jetbrains.cidr.lang.psi.OCProtocol;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.refactoring.OCNameSuggester;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCProtocolSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.OCGlobalProjectSymbolsCache;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCObjectTypeContext;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class OCNameSuggestionContributor
extends OCCompletionContributorBase {
    public static final OCCompletionPriority PRIORITY = OCCompletionPriority.HIGH_KEYWORDS_PRIORITY;

    public OCNameSuggestionContributor() {
        this.register(CompletionType.BASIC, (ElementPattern<? extends PsiElement>)OCCompletionPatterns.NAME_IN_DECLARATION, new OCCompletionProvider(){

            @Override
            protected void addCompletions(String prefix, @NotNull OCCompletionParameters parameters2, ProcessingContext context, CompletionResultSet result2) {
                OCDeclarator declarator = (OCDeclarator)parameters2.getPosition().getParent();
                OCTypeElement typeElement = null;
                if (declarator.getParent() instanceof OCDeclaration && ((typeElement = ((OCDeclaration)declarator.getParent()).getTypeElement()) == null || typeElement.isEmpty())) {
                    return;
                }
                OCType type2 = declarator.getResolvedType();
                if (type2 instanceof OCReferenceType) {
                    List<OCSymbol> symbols = ((OCReferenceType)type2).getReference(declarator.getContainingFile()).resolveToSymbols(parameters2.getOriginalFile());
                    String name = type2.getName();
                    if (!symbols.isEmpty() || "self".equals(name) || "super".equals(name)) {
                        OCExpression expression2 = OCElementFactory.expressionFromText(name, declarator, false);
                        MethodSelectorCompletionContributor.addCompletionsForReceiver(expression2, "", parameters2, result2, (Condition<OCMethodSymbol>)Conditions.alwaysTrue());
                        return;
                    }
                }
                if (type2 instanceof OCObjectType) {
                    if (typeElement != null) {
                        OCObjectTypeContext typeContext = new OCObjectTypeContext(OCObjectTypeContext.StaticMode.STATIC, (OCObjectType)type2, type2);
                        MethodSelectorCompletionContributor.Context ctx = new MethodSelectorCompletionContributor.Context("", typeElement, typeContext, (Condition<OCMethodSymbol>)Conditions.alwaysTrue());
                        MethodSelectorCompletionContributor.addCompletionForReceiverContext(parameters2, result2, ctx);
                    }
                } else {
                    String originalName = declarator.getName();
                    originalName = originalName == null ? "" : originalName;
                    int fakePartIndex = originalName.lastIndexOf("CIDR_RULE_ZZZ");
                    if (fakePartIndex >= 0) {
                        originalName = originalName.substring(0, fakePartIndex);
                    }
                    List<String> predefinedNames = originalName.isEmpty() ? Collections.emptyList() : Collections.singletonList(originalName);
                    for (String name : OCNameSuggester.suggestForDeclaration(declarator, true, predefinedNames)) {
                        result2.addElement(OCCompletionPriority.elementWithPriority((LookupElement)LookupElementBuilder.create((String)name), PRIORITY));
                    }
                }
            }
        });
        this.register(CompletionType.BASIC, (ElementPattern<? extends PsiElement>)PlatformPatterns.psiElement((IElementType)OCTokenTypes.IDENTIFIER).withParent(OCMethodSelectorPart.class), new OCCompletionProvider(){

            @Override
            protected void addCompletions(String prefix, @NotNull OCCompletionParameters parameters2, ProcessingContext context, CompletionResultSet result2) {
                PsiElement ident = parameters2.getPosition();
                OCMethodSelectorPart declarator = (OCMethodSelectorPart)ident.getParent();
                if (declarator.getParameter() == ident) {
                    OCType type2 = declarator.getType().resolve(ident.getContainingFile());
                    for (String name : OCNameSuggester.suggestForType(type2, ident, Collections.emptyList())) {
                        result2.addElement(OCCompletionPriority.elementWithPriority((LookupElement)LookupElementBuilder.create((String)name), PRIORITY));
                    }
                }
            }
        });
        this.register(CompletionType.BASIC, (ElementPattern<? extends PsiElement>)OCCompletionPatterns.NAME_IN_CLASS_DECLARATION, new OCCompletionProvider(){

            @Override
            protected void addCompletions(String prefix, @NotNull OCCompletionParameters parameters2, ProcessingContext context, CompletionResultSet result2) {
                PsiElement element = parameters2.getPosition().getParent();
                OCGlobalProjectSymbolsCache.processTopLevelSymbols(element.getProject(), (Processor<OCSymbol>)((Processor)symbol -> {
                    if (symbol instanceof OCClassSymbol && element instanceof OCProtocol == symbol instanceof OCProtocolSymbol) {
                        result2.addElement(OCCompletionPriority.elementWithPriority((LookupElement)LookupElementBuilder.create((String)symbol.getName()), PRIORITY));
                    }
                    return true;
                }), null);
            }
        });
    }
}

