/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.util.ProcessingContext;
import com.jetbrains.cidr.lang.editor.completion.OCCompletionPriority;
import com.jetbrains.cidr.lang.editor.completion.TemplateInsertHandler;
import com.jetbrains.cidr.lang.psi.OCPragma;
import org.jetbrains.annotations.NotNull;

public class OCPragmaCompletionContributor
extends CompletionContributor {
    public static final PsiElementPattern.Capture<PsiElement> PRAGMA_BODY = (PsiElementPattern.Capture)PlatformPatterns.psiElement().withParent(OCPragma.class);
    private static String[] PRAGMA_COMMANDS = new String[]{"once", "mark ", "push_macro(\"<caret>\")", "pop_macro(\"<caret>\")", "message "};

    public OCPragmaCompletionContributor() {
        this.extend(CompletionType.BASIC, (ElementPattern)PRAGMA_BODY, new InnerCompletionProvider());
    }

    private static class InnerCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private InnerCompletionProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters ps, ProcessingContext c, @NotNull CompletionResultSet r) {
            for (String keyword : PRAGMA_COMMANDS) {
                LookupElementBuilder lookup = TemplateInsertHandler.lookup(keyword);
                r.addElement(OCCompletionPriority.keywordWithPriority((LookupElement)lookup, OCCompletionPriority.NORMAL_KEYWORDS_PRIORITY));
            }
        }
    }
}

