/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.completion;

import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.util.ParenthesesInsertHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Condition;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ProcessingContext;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.CLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.editor.completion.MethodSelectorCompletionContributor;
import com.jetbrains.cidr.lang.editor.completion.OCCompletionContributorBase;
import com.jetbrains.cidr.lang.editor.completion.OCCompletionParameters;
import com.jetbrains.cidr.lang.editor.completion.OCCompletionPatterns;
import com.jetbrains.cidr.lang.editor.completion.OCCompletionPriority;
import com.jetbrains.cidr.lang.editor.completion.OCCompletionProvider;
import com.jetbrains.cidr.lang.editor.completion.OCNewExpressionCompletionContributor;
import com.jetbrains.cidr.lang.editor.completion.OCSmartCompletionContributor;
import com.jetbrains.cidr.lang.editor.completion.OCSymbolsToLookupConverter;
import com.jetbrains.cidr.lang.editor.completion.TemplateInsertHandler;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.preprocessor.OCImmutableInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextUtil;
import com.jetbrains.cidr.lang.psi.OCArgumentList;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCCodeFragment;
import com.jetbrains.cidr.lang.psi.OCCppNamespace;
import com.jetbrains.cidr.lang.psi.OCCppNamespaceQualifier;
import com.jetbrains.cidr.lang.psi.OCCppUsingStatement;
import com.jetbrains.cidr.lang.psi.OCDeclarationStatement;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCDirective;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCExpressionStatement;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCParenthesizedExpression;
import com.jetbrains.cidr.lang.psi.OCProtocolList;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.psi.OCSelectorExpression;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.psi.OCSizeofExpression;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.psi.OCStructLike;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.psi.impl.OCDefinedDirectiveImpl;
import com.jetbrains.cidr.lang.resolve.OCResolveUtil;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolGroupContext;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolReference;
import com.jetbrains.cidr.lang.symbols.OCSymbolReferenceResolver;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCMacroSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.cpp.OCThisSelfSuperSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import com.jetbrains.cidr.lang.types.OCBlockPointerType;
import com.jetbrains.cidr.lang.types.OCNumericType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCVoidType;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCExpectedTypeUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class OCReferenceCompletionContributor
extends OCCompletionContributorBase {
    public static final PsiElementPattern.Capture<PsiElement> DECLARATOR_WITH_QUALIFIER = (PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement((IElementType)OCTokenTypes.IDENTIFIER).andNot(OCCompletionPatterns.AFTER_DOT)).withParent(OCDeclarator.class)).afterLeaf(new String[]{"::"})).andNot(OCCompletionPatterns.TYPE_IN_DECLARATION);
    public static final PsiElementPattern.Capture<PsiElement> DESTRUCTOR_DECLARATOR = (PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement((IElementType)OCTokenTypes.IDENTIFIER).andNot(OCCompletionPatterns.AFTER_DOT)).withParent(OCDeclarator.class)).and(OCCompletionPatterns.AFTER_TILDE);
    public static final PsiElementPattern.Capture<PsiElement> NESTED_NAMESPACE = (PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement((IElementType)OCTokenTypes.IDENTIFIER).afterLeaf(new String[]{"::"})).withParent(OCCppNamespace.class);
    private static boolean ourSuggestBuiltinMacrosInTests = false;
    private static final List<String> BUILT_IN_MACROS_EXPRESSION = Arrays.asList("__PRETTY_FUNCTION__", "__FUNCTION__", "__func__", "__DATE__", "__TIME__", "__TIMESTAMP__", "__FILE__", "__LINE__", "__COUNTER__", "__BASE_FILE__", "__EXCEPTIONS", "va_start", "va_end", "va_arg", "va_copy");
    private static final List<String> BUILT_IN_MACROS_IB = Arrays.asList("IBOutlet", "IBOutletCollection", "IBAction");
    private static final TokenSet IF_DIRECTIVES_WITH_CONDITION = TokenSet.create((IElementType[])new IElementType[]{OCTokenTypes.IFDEF_DIRECTIVE, OCTokenTypes.IFNDEF_DIRECTIVE, OCTokenTypes.IF_DIRECTIVE, OCTokenTypes.ELIF_DIRECTIVE});

    public OCReferenceCompletionContributor() {
        OCCompletionProvider provider2 = new OCCompletionProvider(){

            @Override
            protected void addCompletions(String prefix, @NotNull OCCompletionParameters parameters2, ProcessingContext context, CompletionResultSet result2) {
                OCSymbolGroupContext symbolContext;
                PsiElement element = parameters2.getPosition().getParent();
                int invocationCount = Math.min(parameters2.getInvocationCount(), 2);
                if (!(element instanceof OCReferenceElement || element instanceof OCDeclarator || element instanceof OCCppNamespace)) {
                    return;
                }
                if (MethodSelectorCompletionContributor.getMethodReceiverExpression(element) != null) {
                    return;
                }
                PsiFile file2 = element.getContainingFile().getOriginalFile();
                OCLanguageKind languageKind = file2 instanceof OCFile ? ((OCFile)file2).getKind() : CLanguageKind.maxLanguage(file2.getProject());
                Condition<OCSymbol> fileCondition = file2 instanceof OCCodeFragment ? ((OCCodeFragment)file2).getCompletionFilter() : null;
                PsiElement elementParent = element.getParent();
                OCSymbolsToLookupConverter.ConverterState names = new OCSymbolsToLookupConverter.ConverterState();
                OCStatement stmt = (OCStatement)PsiTreeUtil.getParentOfType((PsiElement)element, OCStatement.class);
                Condition typeCondition = null;
                PsiElement parent = element.getParent();
                OCDirective directive = (OCDirective)PsiTreeUtil.getContextOfType((PsiElement)element, (Class[])new Class[]{OCDirective.class});
                if (parent instanceof OCExpression) {
                    OCType expectedType = OCExpectedTypeUtil.getExpectedType((OCExpression)parent).resolve(file2);
                    if (expectedType instanceof OCBlockPointerType) {
                        result2.addElement(OCSmartCompletionContributor.createBlockTemplateElement((OCBlockPointerType)expectedType, element));
                    } else if (expectedType.getName().equals("SEL")) {
                        OCSmartCompletionContributor.addSelectorCompletions(result2, (OCExpression)parent);
                    }
                }
                if (directive != null) {
                    OCDefinedDirectiveImpl defined;
                    symbolContext = OCSymbolGroupContext.MACRO_OR_UNDEF_OR_MACRO_PARAMETER_CONTEXT;
                    IElementType prevType = directive.getHeaderToken().getNode().getElementType();
                    if ((prevType == OCTokenTypes.IF_DIRECTIVE || prevType == OCTokenTypes.ELIF_DIRECTIVE) && (defined = (OCDefinedDirectiveImpl)PsiTreeUtil.getParentOfType((PsiElement)element, OCDefinedDirectiveImpl.class)) == null) {
                        result2.addElement((LookupElement)TemplateInsertHandler.lookup("defined").withTailText("()", true).withInsertHandler((InsertHandler)ParenthesesInsertHandler.getInstance((boolean)true)).bold());
                    }
                    if (IF_DIRECTIVES_WITH_CONDITION.contains(prevType)) {
                        OCSymbolsToLookupConverter processor2 = new OCSymbolsToLookupConverter(symbolContext, names, result2, true, element, null);
                        OCImmutableInclusionContext inclusionContext = OCInclusionContextUtil.headerContext(file2);
                        OCReferenceCompletionContributor.processBuiltinMacros(Collections.singletonList("__cplusplus"), inclusionContext, (Processor<OCSymbol>)processor2);
                    }
                } else if (element instanceof OCDeclarator) {
                    symbolContext = OCSymbolGroupContext.union(OCSymbolGroupContext.typeContext(languageKind), OCSymbolKind.NAMESPACE, OCSymbolKind.NAMESPACE_ALIAS);
                    OCDeclarator declarator = (OCDeclarator)element;
                    if (OCCompletionPatterns.AFTER_TILDE.accepts((Object)declarator.getNameIdentifier())) {
                        PsiElement grandpa = element.getParent().getParent();
                        if (grandpa instanceof OCStructLike && declarator.getNamespaceQualifier() == null) {
                            result2.addElement((LookupElement)TemplateInsertHandler.lookup(((OCStructLike)grandpa).getName() + "()").bold().withTailText("()"));
                            return;
                        }
                        result2 = result2.withPrefixMatcher("~" + result2.getPrefixMatcher().getPrefix());
                        symbolContext.addSymbolContext(OCSymbolKind.CPP_CONSTRUCTOR_PREDECLARATION);
                    } else if (declarator.getNamespaceQualifier() != null) {
                        symbolContext.addSymbolContext(OCSymbolKind.GLOBAL_VARIABLE_PREDECLARATION);
                        symbolContext.addSymbolContext(OCSymbolKind.FUNCTION_PREDECLARATION);
                        symbolContext.addSymbolContext(OCSymbolKind.CPP_CONSTRUCTOR_DECLARATION);
                        symbolContext.addSymbolContext(OCSymbolKind.CPP_CONSTRUCTOR_PREDECLARATION);
                    }
                } else if (element instanceof OCCppNamespace) {
                    symbolContext = new OCSymbolGroupContext("completion context", new OCSymbolKind[0]);
                    symbolContext.addSymbolContext(OCSymbolKind.NAMESPACE);
                } else {
                    OCSymbolGroupContext refContext = ((OCReferenceElement)element).getSymbolContext();
                    if (parent instanceof OCReferenceExpression || parent instanceof OCTypeElement) {
                        symbolContext = new OCSymbolGroupContext("completion context", new OCSymbolKind[0]);
                        if (!OCCodeInsightUtil.isInPlainOldC(parent)) {
                            symbolContext.addSymbolContext(OCSymbolKind.NAMESPACE);
                            symbolContext.addSymbolContext(OCSymbolKind.NAMESPACE_ALIAS);
                        }
                        if (refContext != null) {
                            symbolContext.addSymbolContexts(refContext.getSymbolContexts());
                            symbolContext.addSymbolContext(OCSymbolKind.INTERFACE);
                        }
                        if (OCReferenceCompletionContributor.isTypePossible(parent)) {
                            symbolContext.addSymbolContexts(OCSymbolGroupContext.typeContext(languageKind).getSymbolContexts());
                        }
                        if (invocationCount <= 1 && parent.getParent() instanceof OCSendMessageExpression) {
                            typeCondition = symbol -> {
                                if (symbol instanceof OCDeclaratorSymbol && symbol.getKind() == OCSymbolKind.TYPEDEF) {
                                    return false;
                                }
                                OCType type2 = symbol.getEffectiveType().getTerminalType();
                                return !(type2 instanceof OCNumericType) && !(type2 instanceof OCVoidType);
                            };
                        } else if (invocationCount <= 1 && parent instanceof OCExpression && !(parent.getParent() instanceof OCStatement)) {
                            typeCondition = symbol -> {
                                if (!OCReferenceCompletionContributor.isTypePossible(parent) && symbol instanceof OCDeclaratorSymbol && symbol.getKind() == OCSymbolKind.TYPEDEF) {
                                    return false;
                                }
                                return !(symbol.getEffectiveType() instanceof OCVoidType);
                            };
                        }
                    } else if (parent instanceof OCStructLike) {
                        if (invocationCount == 0) {
                            return;
                        }
                        IElementType token = PsiTreeUtil.firstChild((PsiElement)parent).getNode().getElementType();
                        OCSymbolKind kind2 = token == OCTokenTypes.ENUM_KEYWORD ? OCSymbolKind.ENUM : (token == OCTokenTypes.UNION_KEYWORD ? OCSymbolKind.UNION : OCSymbolKind.STRUCT);
                        symbolContext = new OCSymbolGroupContext("struct like", kind2);
                    } else if (parent instanceof OCReferenceElement) {
                        symbolContext = OCSymbolGroupContext.PROTOCOL_CONTEXT;
                    } else if (parent instanceof OCProtocolList) {
                        symbolContext = refContext;
                        OCProtocolList list = (OCProtocolList)parent;
                        HashSet<String> protocols = new HashSet<String>();
                        for (OCReferenceElement ref : list.getProtocols()) {
                            protocols.add(ref.getName());
                        }
                        typeCondition = candidate -> !protocols.contains(candidate.getName());
                    } else {
                        symbolContext = elementParent instanceof OCCppUsingStatement ? (((OCCppUsingStatement)elementParent).isNamespaceUsing() ? new OCSymbolGroupContext(OCSymbolKind.NAMESPACE, OCSymbolKind.NAMESPACE_ALIAS) : null) : OCSymbolGroupContext.union(refContext, OCSymbolKind.NAMESPACE, OCSymbolKind.NAMESPACE_ALIAS);
                    }
                }
                if (symbolContext != null) {
                    symbolContext.addSymbolContext(OCSymbolKind.MACRO);
                }
                Condition accessibilityCondition = symbol -> OCVisibility.isVisible(symbol, element, null);
                Condition merge = element instanceof OCDeclarator ? typeCondition : OCReferenceCompletionContributor.merge((Condition<OCSymbol>)typeCondition, (Condition<OCSymbol>)accessibilityCondition);
                OCSymbolsToLookupConverter processor3 = OCSymbolsToLookupConverter.createLookupConverter(symbolContext, names, result2, true, element, (Condition<OCSymbol>)merge);
                for (int i2 = invocationCount; i2 <= 2; ++i2) {
                    OCQualifiedName qualifiedName;
                    OCQualifiedName qualifierName;
                    if (element instanceof OCReferenceElement) {
                        qualifierName = OCSymbolReferenceResolver.getQualifiedName((OCReferenceElement)element).getQualifier();
                    } else if (element instanceof OCCppNamespace && elementParent instanceof OCCppNamespace) {
                        OCSymbol symbol2 = ((OCCppNamespace)elementParent).getSymbol();
                        qualifierName = symbol2 instanceof OCSymbolWithQualifiedName ? ((OCSymbolWithQualifiedName)symbol2).getQualifiedName() : null;
                    } else {
                        OCCppNamespaceQualifier qualifier = (OCCppNamespaceQualifier)PsiTreeUtil.getChildOfType((PsiElement)element, OCCppNamespaceQualifier.class);
                        OCQualifiedName oCQualifiedName = qualifierName = qualifier != null ? OCSymbolReferenceResolver.getQualifiedName(qualifier) : null;
                    }
                    if (qualifierName != null) {
                        qualifiedName = OCQualifiedName.with(qualifierName, null);
                    } else {
                        qualifiedName = OCQualifiedName.with(null);
                        if (element instanceof OCReferenceElement) {
                            OCThisSelfSuperSymbol.processThisSelfSuperInContext((OCReferenceElement)element, processor3, false);
                        }
                        if (elementParent instanceof OCCppUsingStatement && !((OCCppUsingStatement)elementParent).isNamespaceUsing()) {
                            result2.addElement(OCCompletionPriority.keywordWithPriority("namespace", OCCompletionPriority.NORMAL_KEYWORDS_PRIORITY));
                        }
                        if (fileCondition == null) {
                            OCImmutableInclusionContext inclusionContext = OCInclusionContextUtil.headerContext(file2);
                            if (stmt instanceof OCDeclarationStatement || stmt instanceof OCExpressionStatement) {
                                OCReferenceCompletionContributor.processBuiltinMacros(BUILT_IN_MACROS_EXPRESSION, inclusionContext, (Processor<OCSymbol>)processor3);
                            }
                            if (symbolContext == null || symbolContext.isSuitableSymbolKind(OCSymbolKind.INTERFACE)) {
                                OCReferenceCompletionContributor.processBuiltinMacros(BUILT_IN_MACROS_IB, inclusionContext, (Processor<OCSymbol>)processor3);
                            }
                        }
                    }
                    result2.addLookupAdvertisement("Press " + OCReferenceCompletionContributor.getActionShortcut((String)"SmartTypeCompletion") + " to filter results by type");
                    if ("_".equals(prefix) && i2 == 1 && !(parent instanceof OCStructLike)) {
                        if (i2 == 1) {
                            result2.addLookupAdvertisement("Press " + OCReferenceCompletionContributor.getActionShortcut((String)"CodeCompletion") + " again for global symbols");
                        }
                        OCResolveUtil.processLocalAndMemberSymbols(null, element, processor3);
                    } else {
                        if (i2 <= 1) {
                            result2.addLookupAdvertisement("Press " + OCReferenceCompletionContributor.getActionShortcut((String)"CodeCompletion") + " again for not-imported symbols");
                        }
                        OCSymbolReference.LocalReference qualifierRef = OCSymbolReference.getLocalReference(qualifiedName, element);
                        OCResolveContext resolveContext = new OCResolveContext(element);
                        resolveContext.setIncompleteMode(true);
                        qualifierRef.processPossibleSymbols((Processor<OCSymbol>)processor3, resolveContext);
                        if (i2 > 1) {
                            Condition oldCondition = typeCondition;
                            typeCondition = symbol -> {
                                if (oldCondition != null && !oldCondition.value(symbol)) {
                                    return false;
                                }
                                OCFile containingOCFile = symbol.getContainingOCFile();
                                return containingOCFile != null && containingOCFile.isHeader();
                            };
                            resolveContext.setProcessNonImported(true);
                            OCSymbolsToLookupConverter converter = OCSymbolsToLookupConverter.createLookupConverter(symbolContext, names, result2, false, element, (Condition<OCSymbol>)OCReferenceCompletionContributor.merge((Condition<OCSymbol>)typeCondition, (Condition<OCSymbol>)fileCondition));
                            ContainerUtil.process(resolveContext.resolveToSymbols(qualifierRef), (Processor)converter);
                            converter.finish();
                        }
                    }
                    processor3.finish();
                    if (!processor3.isEmpty()) break;
                    typeCondition = null;
                }
            }
        };
        this.register(CompletionType.BASIC, (ElementPattern<? extends PsiElement>)((PsiElementPattern.Capture)((PsiElementPattern.Capture)OCCompletionPatterns.REFERENCE_ELEMENT.andNot(OCCompletionPatterns.AFTER_DOT)).andNot(OCCompletionPatterns.AT_CLASS_FUNCTION_BODY_PLACEHOLDER)).andNot(OCNewExpressionCompletionContributor.TYPE_IN_NEW_EXPRESSION), provider2);
        this.register(CompletionType.BASIC, (ElementPattern<? extends PsiElement>)OCCompletionPatterns.TYPE_IN_DECLARATION.andNot(OCCompletionPatterns.AFTER_DOT), provider2);
        this.register(CompletionType.BASIC, (ElementPattern<? extends PsiElement>)DECLARATOR_WITH_QUALIFIER, provider2);
        this.register(CompletionType.BASIC, (ElementPattern<? extends PsiElement>)DESTRUCTOR_DECLARATOR, provider2);
        this.register(CompletionType.BASIC, (ElementPattern<? extends PsiElement>)NESTED_NAMESPACE, provider2);
    }

    public static boolean isTypePossible(PsiElement parent) {
        return parent.getParent() instanceof OCSizeofExpression || parent instanceof OCReferenceExpression && parent.getParent() instanceof OCParenthesizedExpression || parent.getParent() instanceof OCArgumentList && parent.getParent().getParent() instanceof OCDeclarator && PsiTreeUtil.getContextOfType((PsiElement)parent, (Class[])new Class[]{OCBlockStatement.class}) == null;
    }

    private static Condition<OCSymbol> merge(Condition<OCSymbol> c1, Condition<OCSymbol> c2) {
        if (c1 == null) {
            return c2;
        }
        if (c2 == null) {
            return c1;
        }
        return symbol -> c1.value(symbol) && c2.value(symbol);
    }

    private static void processBuiltinMacros(@NotNull List<String> macros, @NotNull OCImmutableInclusionContext inclusionContext, @NotNull Processor<OCSymbol> result2) {
        if (ApplicationManager.getApplication().isUnitTestMode() && ourSuggestBuiltinMacrosInTests != Boolean.TRUE) {
            return;
        }
        for (String each : macros) {
            OCMacroSymbol macro = inclusionContext.getDefinition(each);
            if (macro == null) continue;
            result2.process((Object)macro);
        }
    }

    public static void setSuggestBuiltInMacrosInTests(boolean suggest) {
        ourSuggestBuiltinMacrosInTests = suggest;
    }

    public boolean invokeAutoPopup(@NotNull PsiElement position, char typeChar) {
        IElementType prevType = position.getNode().getElementType();
        if ('>' == typeChar && ((Object)((Object)OCTokenTypes.MINUS)).equals(prevType)) {
            return true;
        }
        if (':' == typeChar && ((Object)((Object)OCTokenTypes.COLON)).equals(prevType) && !(position.getParent() instanceof OCSelectorExpression)) {
            return true;
        }
        PsiFile containingFile = position.getContainingFile();
        return '*' == typeChar && (((Object)((Object)OCTokenTypes.DEREF)).equals(prevType) || ((Object)((Object)OCTokenTypes.DOT)).equals(prevType)) && containingFile instanceof OCFile && FileSymbolTablesCache.areSymbolsLoaded(position.getProject()) && ((OCFile)containingFile).getKind().isCpp();
    }
}

