/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.completion;

import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.patterns.ElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.util.ProcessingContext;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.editor.completion.OCCompletionContributorBase;
import com.jetbrains.cidr.lang.editor.completion.OCCompletionParameters;
import com.jetbrains.cidr.lang.editor.completion.OCCompletionPatterns;
import com.jetbrains.cidr.lang.editor.completion.OCCompletionProvider;
import com.jetbrains.cidr.lang.psi.OCLiteralExpression;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.resolve.references.OCResourceCompletionProvider;
import com.jetbrains.cidr.lang.resolve.references.OCResourceReference;
import com.jetbrains.cidr.lang.resolve.references.OCResourceReferenceContributor;
import org.jetbrains.annotations.NotNull;

public class OCResourceCompletionContributor
extends OCCompletionContributorBase {
    public OCResourceCompletionContributor() {
        OCCompletionProvider provider2 = new OCCompletionProvider(){

            @Override
            protected void addCompletions(String prefix, @NotNull OCCompletionParameters parameters2, ProcessingContext context, CompletionResultSet result2) {
                String customPrefix;
                PsiElement expression2;
                PsiElement element = parameters2.getRealPosition().getParent();
                if (element instanceof OCReferenceElement) {
                    expression2 = element.getParent();
                    customPrefix = null;
                } else if (element instanceof OCLiteralExpression && ((OCLiteralExpression)element).getTextWithMacros().startsWith("@\"")) {
                    expression2 = element;
                    customPrefix = parameters2.getOffset() > element.getTextOffset() ? ((OCLiteralExpression)element).getTextWithMacros().substring(2, parameters2.getOffset() - element.getTextOffset()) : null;
                } else {
                    expression2 = null;
                    customPrefix = null;
                }
                if (expression2 != null) {
                    OCResourceReferenceContributor.processReferenceProviders((Processor<OCResourceCompletionProvider>)((Processor)provider1 -> {
                        for (PsiReference reference : provider1.getReferencesByElement(expression2, new ProcessingContext())) {
                            for (LookupElement variant : ((OCResourceReference)reference).getLookupElements(customPrefix == null)) {
                                (customPrefix != null ? result2.withPrefixMatcher(customPrefix) : result2).addElement(variant);
                            }
                        }
                        return true;
                    }));
                }
            }
        };
        this.register(CompletionType.BASIC, (ElementPattern<? extends PsiElement>)OCCompletionPatterns.REFERENCE_ELEMENT, provider2);
        this.register(CompletionType.BASIC, (ElementPattern<? extends PsiElement>)OCCompletionPatterns.LITERAL_EXPRESSION, provider2);
        this.register(CompletionType.SMART, (ElementPattern<? extends PsiElement>)OCCompletionPatterns.REFERENCE_ELEMENT, provider2);
        this.register(CompletionType.SMART, (ElementPattern<? extends PsiElement>)OCCompletionPatterns.LITERAL_EXPRESSION, provider2);
    }
}

