/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.completion;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.completion.TemplateParameterTraversalPolicy;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.text.CharArrayUtil;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCArgumentSelector;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCCallExpression;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCLiteralExpression;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.OCMacroCallArgument;
import com.jetbrains.cidr.lang.psi.OCMessageArgument;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.psi.OCTemplateArgumentList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class OCTemplateParameterTraversalPolicy
implements TemplateParameterTraversalPolicy {
    @Nullable
    private static List<TextRange> calcNavigationRanges(Editor editor, PsiFile file2) {
        int linefeed;
        if (LookupManager.getActiveLookup(editor) != null) {
            return null;
        }
        int offset = editor.getCaretModel().getOffset();
        PsiElement node = file2.findElementAt(offset);
        if (node instanceof PsiWhiteSpace && (linefeed = node.getText().indexOf(10)) >= 0 && offset > node.getTextRange().getStartOffset() + linefeed) {
            return null;
        }
        OCStatement parentStatement = (OCStatement)PsiTreeUtil.getParentOfType((PsiElement)node, OCStatement.class);
        if (parentStatement != null) {
            List<TextRange> templateRanges = OCTemplateParameterTraversalPolicy.calcTemplateRanges(editor, parentStatement.getRangeWithMacros());
            if (templateRanges.size() > 1) {
                return templateRanges;
            }
            if (templateRanges.size() == 1) {
                TextRange range = templateRanges.get(0);
                node = file2.findElementAt(range.getStartOffset());
            }
        }
        PsiElement call = OCTemplateParameterTraversalPolicy.findCallParentAtOffset(offset, node);
        ArrayList<TextRange> answer = new ArrayList<TextRange>();
        while (call != null) {
            List<TextRange> ranges = OCTemplateParameterTraversalPolicy.calcExpressionRanges(call);
            if (ranges != null) {
                answer.addAll(ranges);
            }
            call = OCTemplateParameterTraversalPolicy.findCallParentAtOffset(offset, call);
        }
        Collections.sort(answer, (o1, o2) -> o1.getStartOffset() - o2.getStartOffset());
        return answer.isEmpty() ? null : answer;
    }

    @Nullable
    private static List<TextRange> calcExpressionRanges(PsiElement expr) {
        if (expr instanceof OCSendMessageExpression) {
            return OCTemplateParameterTraversalPolicy.calcSendMessageRanges((OCSendMessageExpression)expr);
        }
        if (expr instanceof OCCallExpression) {
            return OCTemplateParameterTraversalPolicy.calcFunctionCallRanges((OCCallExpression)expr);
        }
        if (expr instanceof OCMacroCall) {
            return OCTemplateParameterTraversalPolicy.calcMacroCallRanges((OCMacroCall)expr);
        }
        if (expr instanceof OCTemplateArgumentList) {
            return OCTemplateParameterTraversalPolicy.calcTemplateArgumentListRanges((OCTemplateArgumentList)expr);
        }
        return null;
    }

    private static List<TextRange> calcTemplateArgumentListRanges(OCTemplateArgumentList expr) {
        ArrayList<TextRange> answer = new ArrayList<TextRange>();
        for (OCElement arg : expr.getArguments()) {
            answer.add(arg.getRangeWithMacros());
        }
        return answer;
    }

    private static List<TextRange> calcMacroCallRanges(OCMacroCall expr) {
        ArrayList<TextRange> answer = new ArrayList<TextRange>();
        for (OCMacroCallArgument arg : expr.getArguments()) {
            answer.add(arg.getRangeWithMacros());
        }
        return answer;
    }

    private static List<TextRange> calcFunctionCallRanges(OCCallExpression expr) {
        ArrayList<TextRange> answer = new ArrayList<TextRange>();
        for (OCExpression arg : expr.getArguments()) {
            answer.add(arg.getRangeWithMacros());
        }
        return answer;
    }

    private static List<TextRange> calcTemplateRanges(Editor editor, TextRange inRange) {
        ArrayList<TextRange> answer = new ArrayList<TextRange>();
        HighlighterIterator iterator = ((EditorEx)editor).getHighlighter().createIterator(inRange.getStartOffset());
        int start = -1;
        while (!iterator.atEnd() && iterator.getStart() < inRange.getEndOffset()) {
            IElementType tt = iterator.getTokenType();
            if (tt == OCTokenTypes.TEMPLATE_START_MARK) {
                start = iterator.getStart();
            }
            if (tt == OCTokenTypes.TEMPLATE_STOP_MARK && start >= 0) {
                answer.add(TextRange.create((int)start, (int)iterator.getEnd()));
                start = -1;
            }
            iterator.advance();
        }
        return answer;
    }

    private static List<TextRange> calcSendMessageRanges(OCSendMessageExpression expr) {
        ArrayList<TextRange> answer = new ArrayList<TextRange>();
        for (OCMessageArgument argument : expr.getArguments()) {
            OCArgumentSelector selector2 = argument.getArgumentSelector();
            OCExpression param = argument.getArgumentExpression();
            if (param == null) continue;
            if (param instanceof OCLiteralExpression && "<#".equals(param.getFirstChild().getText())) {
                answer.add(param.getRangeWithMacros());
                continue;
            }
            answer.add(new TextRange(selector2.getTextRange().getEndOffset(), param.getRangeWithMacros().getEndOffset()));
        }
        return answer;
    }

    @Nullable
    private static PsiElement findCallParentAtOffset(int offset, PsiElement leaf) {
        PsiElement last;
        PsiElement expr = PsiTreeUtil.getContextOfType((PsiElement)leaf, (Class[])new Class[]{OCSendMessageExpression.class, OCCallExpression.class, OCBlockStatement.class, OCMacroCall.class, OCTemplateArgumentList.class});
        if (expr == null || expr instanceof OCBlockStatement) {
            return null;
        }
        List<Object> args = expr instanceof OCCallExpression ? ((OCCallExpression)expr).getArguments() : (expr instanceof OCSendMessageExpression ? ((OCSendMessageExpression)expr).getArguments() : (expr instanceof OCMacroCall ? ((OCMacroCall)expr).getArguments() : (expr instanceof OCTemplateArgumentList ? ((OCTemplateArgumentList)expr).getArguments() : null)));
        PsiElement psiElement = last = args != null && args.size() > 0 ? (PsiElement)args.get(args.size() - 1) : null;
        if (last != null && offset >= last.getTextRange().getEndOffset()) {
            return OCTemplateParameterTraversalPolicy.findCallParentAtOffset(offset, expr);
        }
        if (offset == expr.getTextRange().getStartOffset()) {
            return OCTemplateParameterTraversalPolicy.findCallParentAtOffset(offset, expr);
        }
        return expr;
    }

    public boolean isValidForFile(Editor editor, PsiFile file2) {
        return file2 instanceof OCFile && OCTemplateParameterTraversalPolicy.calcNavigationRanges(editor, file2) != null;
    }

    private static TextRange chooseRange(int offset, List<TextRange> ranges, boolean next) {
        if (next) {
            for (TextRange range : ranges) {
                if (range.getStartOffset() <= offset) continue;
                return range;
            }
            return ranges.get(0);
        }
        Collections.reverse(ranges);
        for (TextRange range : ranges) {
            if (range.getEndOffset() >= offset) continue;
            return range;
        }
        return ranges.get(0);
    }

    public void invoke(Editor editor, PsiFile file2, boolean next) {
        if (!FileModificationService.getInstance().prepareFileForWrite(file2)) {
            return;
        }
        PsiDocumentManager.getInstance((Project)file2.getProject()).commitAllDocuments();
        List<TextRange> ranges = OCTemplateParameterTraversalPolicy.calcNavigationRanges(editor, file2);
        if (ranges == null || ranges.isEmpty()) {
            return;
        }
        TextRange range = OCTemplateParameterTraversalPolicy.chooseRange(editor.getCaretModel().getOffset(), ranges, next);
        int end = range.getEndOffset();
        int start = range.getStartOffset();
        CharSequence chars = editor.getDocument().getCharsSequence();
        start = CharArrayUtil.shiftForward((CharSequence)chars, (int)start, (String)" \t\n");
        end = CharArrayUtil.shiftBackward((CharSequence)chars, (int)(end - 1), (String)" \t\n") + 1;
        editor.getCaretModel().moveToOffset(end);
        editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        editor.getCaretModel().moveToOffset(start);
        editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        if (chars.charAt(start) == '<' && chars.charAt(start + 1) == '#') {
            editor.getSelectionModel().setSelection(start, end);
        } else {
            editor.getSelectionModel().removeSelection();
        }
    }
}

