/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.completion;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.CommonProcessors;
import com.intellij.util.ProcessingContext;
import com.intellij.util.Processor;
import com.intellij.util.containers.HashMap;
import com.jetbrains.cidr.lang.editor.completion.OCCompletionContributorBase;
import com.jetbrains.cidr.lang.editor.completion.OCCompletionParameters;
import com.jetbrains.cidr.lang.editor.completion.OCCompletionProvider;
import com.jetbrains.cidr.lang.editor.completion.SymbolLookupBuilderUtil;
import com.jetbrains.cidr.lang.parser.OCPunctuatorElementType;
import com.jetbrains.cidr.lang.psi.OCCodeFragment;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.OCFileSymbols;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCObjectTypeContext;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCCommonProcessors;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class QualifiedSelectorCompletionContributor
extends OCCompletionContributorBase {
    public QualifiedSelectorCompletionContributor() {
        this.register(CompletionType.BASIC, (ElementPattern<? extends PsiElement>)PlatformPatterns.psiElement().withParent(OCQualifiedExpression.class), new OCCompletionProvider(){

            @Override
            protected void addCompletions(String prefix, @NotNull OCCompletionParameters parameters2, ProcessingContext context, CompletionResultSet result2) {
                OCQualifiedExpression expr = (OCQualifiedExpression)parameters2.getPosition().getParent();
                OCObjectTypeContext typeContext = expr.getQualifier().getTypeContext();
                int invocationCount = Integer.MAX_VALUE;
                for (OCPunctuatorElementType qt : expr.qualifyingTokensForCompletion()) {
                    int ic = this.addCompletions(qt, parameters2, result2, expr, typeContext);
                    invocationCount = Math.min(invocationCount, ic);
                }
                if (typeContext != null && invocationCount <= 1) {
                    result2.addLookupAdvertisement("Press " + QualifiedSelectorCompletionContributor.getActionShortcut((String)"SmartTypeCompletion") + " to filter results by type");
                    result2.addLookupAdvertisement("Press " + QualifiedSelectorCompletionContributor.getActionShortcut((String)"CodeCompletion") + (invocationCount == 0 ? "" : " again") + " for symbols from NSObject categories");
                }
            }

            private int addCompletions(@NotNull OCPunctuatorElementType qualifyingToken, final @NotNull OCCompletionParameters parameters2, CompletionResultSet result2, OCQualifiedExpression expr, OCObjectTypeContext typeContext) {
                int i2;
                CommonProcessors.CollectProcessor<OCSymbol> symbols = new CommonProcessors.CollectProcessor<OCSymbol>(){
                    private Set<String> names = new HashSet<String>();
                    private Map<String, OCSymbol> members = new HashMap();

                    public boolean process(OCSymbol symbol) {
                        OCFile file2;
                        PsiElement fragmentContext;
                        if (symbol.getKind().isType() || symbol.isUnnamed()) {
                            return true;
                        }
                        PsiFile original = parameters2.getOriginalFile();
                        if (original instanceof OCCodeFragment && (fragmentContext = original.getContext()) != null) {
                            original = fragmentContext.getContainingFile().getOriginalFile();
                        }
                        if (!(original instanceof OCFile && OCFileSymbols.isSymbolImported((OCFile)original, symbol) || (file2 = symbol.getContainingOCFile()) == null || file2.isHeader())) {
                            return true;
                        }
                        if (symbol.getKind().isConstructorOrDestructor()) {
                            return true;
                        }
                        if (symbol instanceof OCFunctionSymbol || symbol.getKind() == OCSymbolKind.STRUCT_FIELD) {
                            String name = symbol.getName();
                            OCSymbolWithQualifiedName symbolParent = ((OCSymbolWithQualifiedName)symbol).getParent();
                            if (symbolParent == null) {
                                return super.process((Object)symbol);
                            }
                            if (this.members.containsKey(name)) {
                                OCSymbol parent = this.members.get(name);
                                if (parent.equals(symbolParent)) {
                                    return super.process((Object)symbol);
                                }
                                return true;
                            }
                            this.members.put(name, symbolParent);
                            return super.process((Object)symbol);
                        }
                        if (this.names.add(symbol.getSignature())) {
                            return super.process((Object)symbol);
                        }
                        return true;
                    }
                };
                OCCommonProcessors.OrderedProcessor<OCSymbol> orderedProcessor = new OCCommonProcessors.OrderedProcessor<OCSymbol>((Processor<OCSymbol>)symbols, (Condition<T>[])new Condition[]{symbol -> symbol.getKind() == OCSymbolKind.PROPERTY, symbol -> symbol instanceof OCMethodSymbol && symbol.isPredeclaration(), symbol -> symbol.getKind().isFunction(), symbol -> !symbol.getKind().isConstructorOrDestructor(), OCSymbol.NON_FANTOM_SYMBOL_CONDITION});
                Ref qualifierType = new Ref();
                expr.processTargets(null, orderedProcessor, false, qualifyingToken, false, true, (Ref<OCType>)qualifierType);
                orderedProcessor.finish();
                if (qualifierType.isNull()) {
                    qualifierType.set((Object)expr.getQualifier().getResolvedType());
                }
                for (i2 = parameters2.getInvocationCount(); i2 <= 2; ++i2) {
                    boolean isEmpty = true;
                    for (OCSymbol symbol2 : symbols.getResults()) {
                        boolean isFromCurClass = false;
                        if (symbol2 instanceof OCMemberSymbol) {
                            OCClassSymbol parent = (OCClassSymbol)((OCMemberSymbol)symbol2).getParent();
                            if (i2 <= 1 && "NSObject".equals(parent.getName()) && parent.getCategoryName() != null) continue;
                            boolean bl = isFromCurClass = typeContext != null && Comparing.equal((String)parent.getName(), (String)typeContext.getType().getClassName());
                        }
                        if (symbol2.isUnavailable() || symbol2.isForbiddenByARC(expr) || i2 <= 1 && !OCVisibility.isVisible(symbol2, expr, (OCType)qualifierType.get()) || symbol2 instanceof OCMethodSymbol && symbol2.isSynthetic() && (!(symbol2 instanceof OCMethodSymbol) || !((OCMethodSymbol)symbol2).isAccessorWithAliasedName())) continue;
                        LookupElement lookup = SymbolLookupBuilderUtil.lookup(symbol2, null, typeContext != null ? typeContext.getType() : null, expr, isFromCurClass, null);
                        if (!result2.getPrefixMatcher().prefixMatches(lookup)) continue;
                        result2.addElement(lookup);
                        OCQualifiedExpression.COMPLETION_QUALIFYING_TOKEN_KEY.set((UserDataHolder)lookup, (Object)qualifyingToken);
                        isEmpty = false;
                    }
                    if (!isEmpty) break;
                }
                return i2;
            }
        });
    }

    public String handleEmptyLookup(@NotNull CompletionParameters parameters2, Editor editor) {
        PsiElement position = parameters2.getPosition();
        PsiElement parent = position.getParent();
        if (parent instanceof OCQualifiedExpression) {
            OCQualifiedExpression expr = (OCQualifiedExpression)parent;
            OCType resolve2 = expr.getQualifier().getType().resolve(expr.getContainingOCFile());
            if (resolve2.getTerminalType() instanceof OCObjectType) {
                return "No suggestions for properties of class " + resolve2.getTerminalType().getName(expr);
            }
            return "No suggestions for members of " + resolve2.getName(expr);
        }
        return super.handleEmptyLookup(parameters2, editor);
    }
}

