/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.liveTemplates;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.editor.completion.OCCodeContextType;
import com.jetbrains.cidr.lang.editor.liveTemplates.OCElementResult;
import com.jetbrains.cidr.lang.editor.liveTemplates.OCTemplatesUtil;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CPPContainerEnumerationVariableMacro
extends Macro {
    public static final String MACRO_NAME = "variableForIteration";
    private static final Key<List<OCDeclaratorSymbol>> MACRO_LAST_RESULT_KEY = Key.create((String)"variableForIteration");

    public String getName() {
        return MACRO_NAME;
    }

    public String getPresentableName() {
        return "variableForIteration()";
    }

    @Nullable
    public Result calculateResult(@NotNull Expression[] params, @NotNull ExpressionContext context) {
        List<OCDeclaratorSymbol> variables = CPPContainerEnumerationVariableMacro.getVariables(context);
        if (variables.isEmpty()) {
            return null;
        }
        for (OCDeclaratorSymbol var : variables) {
            OCElement def = (OCElement)var.locateDefinition();
            if (def == null) continue;
            return new OCElementResult(def);
        }
        return null;
    }

    @Nullable
    public LookupElement[] calculateLookupItems(@NotNull Expression[] params, @NotNull ExpressionContext context) {
        List<OCDeclaratorSymbol> variables = CPPContainerEnumerationVariableMacro.getVariables(context);
        if (variables.size() < 2) {
            return null;
        }
        LookupElement[] items = new LookupElement[variables.size()];
        int i2 = 0;
        for (OCDeclaratorSymbol var : variables) {
            items[i2++] = LookupElementBuilder.create((String)var.getName()).withIcon(var.getIcon());
        }
        return items;
    }

    @NotNull
    private static List<OCDeclaratorSymbol> getVariables(@NotNull ExpressionContext context) {
        PsiElement place = OCTemplatesUtil.getInsertionPlace(context);
        ArrayList<OCDeclaratorSymbol> results = (ArrayList<OCDeclaratorSymbol>)MACRO_LAST_RESULT_KEY.get((UserDataHolder)place);
        if (results != null) {
            return results;
        }
        List<OCDeclaratorSymbol> variables = OCTemplatesUtil.getVariablesVisibleAt(place, true);
        results = new ArrayList<OCDeclaratorSymbol>();
        for (OCDeclaratorSymbol var : variables) {
            OCType type2 = var.getResolvedType();
            if (type2.isUnresolved(place) || type2.isUnknown() || OCCodeInsightUtil.getCollectionElementType(OCElementFactory.expressionFromText(var.getName(), place, false), type2) == null) continue;
            results.add(var);
        }
        MACRO_LAST_RESULT_KEY.set((UserDataHolder)place, results);
        return results;
    }

    public boolean isAcceptableInContext(TemplateContextType context) {
        return context instanceof OCCodeContextType;
    }
}

