/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.liveTemplates;

import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Result;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.text.BlockSupport;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.refactoring.OCNameSuggester;
import com.jetbrains.cidr.lang.resolve.OCResolveUtil;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCTemplatesUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.cidr.lang.editor.liveTemplates.OCTemplatesUtil");

    private OCTemplatesUtil() {
    }

    @NotNull
    public static List<OCDeclaratorSymbol> getVariablesVisibleAt(PsiElement place, boolean withFields) {
        HashSet names = new HashSet();
        ArrayList<OCDeclaratorSymbol> answer = new ArrayList<OCDeclaratorSymbol>();
        Processor processor2 = symbol -> {
            OCSymbolKind kind2;
            if (symbol instanceof OCDeclaratorSymbol && names.add(symbol.getName()) && ((kind2 = symbol.getKind()).isLocal() || kind2 == OCSymbolKind.STRUCT_FIELD)) {
                answer.add((OCDeclaratorSymbol)symbol);
            }
            return true;
        };
        if (withFields) {
            OCResolveUtil.processSymbols(null, place, (Processor<OCSymbol>)processor2);
        } else {
            OCResolveUtil.processLocalSymbols(null, place, (Processor<OCSymbol>)processor2, false);
        }
        return answer;
    }

    @Nullable
    public static Collection<String> getNames(ExpressionContext context) {
        Project project2 = context.getProject();
        int offset = context.getStartOffset();
        Collection<String> names = null;
        PsiFile file2 = PsiDocumentManager.getInstance((Project)project2).getPsiFile(context.getEditor().getDocument());
        PsiElement element = file2.findElementAt(offset);
        if (element.getNode().getElementType() == OCTokenTypes.IDENTIFIER) {
            names = OCTemplatesUtil.getNamesForIdentifier(project2, element);
        } else {
            PsiFile fileCopy = (PsiFile)file2.copy();
            ApplicationManager.getApplication().runWriteAction(() -> {
                BlockSupport blockSupport = BlockSupport.getInstance(project2);
                try {
                    blockSupport.reparseRange(fileCopy, offset, offset, "xxx");
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
            });
            PsiElement identifierCopy = fileCopy.findElementAt(offset);
            if (identifierCopy.getNode().getElementType() == OCTokenTypes.IDENTIFIER) {
                names = OCTemplatesUtil.getNamesForIdentifier(project2, identifierCopy);
            }
        }
        return names;
    }

    @Nullable
    private static Collection<String> getNamesForIdentifier(Project project2, PsiElement identifier) {
        OCDeclarator var;
        if (identifier.getParent() instanceof OCDeclarator && identifier.equals((var = (OCDeclarator)identifier.getParent()).getNameIdentifier())) {
            return OCNameSuggester.suggestForDeclaration(var, false, Collections.emptyList());
        }
        return null;
    }

    @NotNull
    public static PsiElement getInsertionPlace(@NotNull ExpressionContext context) {
        Editor editor = context.getEditor();
        OCLog.LOG.assertTrue(editor != null && editor.getProject() != null, (Object)"Template call in undefined editor");
        PsiFile file2 = PsiDocumentManager.getInstance((Project)editor.getProject()).getPsiFile(editor.getDocument());
        OCLog.LOG.assertTrue(file2 != null, (Object)"Template call in undefined file");
        PsiElement place = file2.findElementAt(context.getStartOffset());
        OCLog.LOG.assertTrue(place != null, (Object)"Template call in undefined context");
        return place;
    }

    @NotNull
    public static List<OCDeclaratorSymbol> getVariablesWithBeginEnd(@NotNull ExpressionContext context) {
        PsiElement place = OCTemplatesUtil.getInsertionPlace(context);
        ArrayList<OCDeclaratorSymbol> results = new ArrayList<OCDeclaratorSymbol>();
        List<OCDeclaratorSymbol> variables = OCTemplatesUtil.getVariablesVisibleAt(place, true);
        for (OCDeclaratorSymbol var : variables) {
            OCType type2 = var.getResolvedType();
            if (type2.isUnresolved(place) || type2.isUnknown()) continue;
            if (type2 instanceof OCCppReferenceType) {
                type2 = ((OCCppReferenceType)type2).getRefType();
            }
            OCExpression expr = OCElementFactory.expressionFromText(var.getName(), place);
            assert (expr != null);
            OCFile file2 = expr.getContainingOCFile();
            if (!(type2 instanceof OCStructType) || OCCodeInsightUtil.getReturnTypeOfBeginEndPair(expr, (OCStructType)type2, file2).getFirst() != OCCodeInsightUtil.MemberBeginEndSearchResult.OK) continue;
            results.add(var);
        }
        return results;
    }

    @NotNull
    public static List<OCDeclaratorSymbol> getVariablesWithMethods(@NotNull ExpressionContext context, @NotNull List<String> requiredMethods) {
        PsiElement place = OCTemplatesUtil.getInsertionPlace(context);
        ArrayList<OCDeclaratorSymbol> results = new ArrayList<OCDeclaratorSymbol>();
        List<OCDeclaratorSymbol> variables = OCTemplatesUtil.getVariablesVisibleAt(place, true);
        for (OCDeclaratorSymbol var : variables) {
            OCType type2 = var.getResolvedType();
            if (type2.isUnresolved(place) || type2.isUnknown()) continue;
            if (type2 instanceof OCCppReferenceType) {
                type2 = ((OCCppReferenceType)type2).getRefType();
            }
            if (!(type2 instanceof OCStructType)) continue;
            OCExpression expr = OCElementFactory.expressionFromText(var.getName(), place);
            assert (expr != null);
            OCFile file2 = expr.getContainingOCFile();
            OCStructType structType = (OCStructType)type2;
            boolean shouldAdd = true;
            for (String method2 : requiredMethods) {
                if (OCTemplatesUtil.hasMemberFunction(structType, file2, method2)) continue;
                shouldAdd = false;
                break;
            }
            if (!shouldAdd) continue;
            results.add(var);
        }
        return results;
    }

    private static boolean hasMemberFunction(@NotNull OCStructType type2, @NotNull OCFile file2, @NotNull String name) {
        OCResolveContext context = new OCResolveContext(file2);
        return !type2.collectMethods(name, context).isEmpty();
    }

    @NotNull
    public static List<String> getStringsList(@NotNull Expression[] params, ExpressionContext context) {
        ArrayList<String> namesList = new ArrayList<String>();
        for (Expression param : params) {
            Result result2 = param.calculateResult(context);
            if (result2 == null) continue;
            namesList.add(result2.toString());
        }
        return namesList;
    }
}

