/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.parameterInfo;

import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.editor.OCFunctionParameterInfoHandler;
import com.jetbrains.cidr.lang.editor.parameterInfo.OCArgumentListCallPlace;
import com.jetbrains.cidr.lang.editor.parameterInfo.OCFunctionCallOption;
import com.jetbrains.cidr.lang.editor.parameterInfo.OCFunctionCallPlace;
import com.jetbrains.cidr.lang.psi.OCArgumentList;
import com.jetbrains.cidr.lang.psi.OCCompoundInitializer;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class OCCompoundInitializerCallPlace
extends OCFunctionCallPlace<OCCompoundInitializer> {
    public OCCompoundInitializerCallPlace(OCCompoundInitializer initializer) {
        super(initializer);
    }

    @Override
    public void collectCallOptions(@NotNull Collection<OCFunctionCallOption> result2) {
        OCCompoundInitializer initializer = (OCCompoundInitializer)this.getElement();
        PsiElement parent = initializer.getParent();
        OCFunctionCallPlace place = null;
        if (parent instanceof OCArgumentList) {
            OCArgumentList argumentList = (OCArgumentList)parent;
            place = new OCArgumentListCallPlace(argumentList);
        } else if (parent instanceof OCCompoundInitializer) {
            OCCompoundInitializer i2 = (OCCompoundInitializer)parent;
            place = new OCCompoundInitializerCallPlace(i2);
        }
        if (place != null) {
            OCCompoundInitializerCallPlace.collectUsingFromParentOption(place, initializer, result2);
        } else {
            OCType type2 = initializer.inferType();
            if (type2 != null) {
                OCType rt = type2.resolve(initializer.getContainingFile());
                OCCompoundInitializerCallPlace.collectInitializationOptions(rt, initializer, result2);
            }
        }
    }

    private static void collectUsingFromParentOption(@NotNull OCFunctionCallPlace<? extends PsiElement> place, @NotNull OCCompoundInitializer initializer, @NotNull Collection<OCFunctionCallOption> result2) {
        List<OCExpression> expressions2 = place.getArgumentExpressions();
        int initIdx = expressions2.indexOf(initializer);
        assert (initIdx >= 0);
        ArrayList<OCFunctionCallOption> options = new ArrayList<OCFunctionCallOption>();
        place.collectCallOptions(options);
        for (OCFunctionCallOption option : options) {
            OCFunctionType ft = option.getParameterInfo().getType();
            List<OCType> pts = ft.getParameterTypes();
            if (pts.size() <= initIdx || initIdx >= 1 && !OCFunctionParameterInfoHandler.isApplicableBeforeIndex(ft, expressions2, initIdx - 1)) continue;
            OCType initType = pts.get(initIdx);
            OCCompoundInitializerCallPlace.collectInitializationOptions(initType, initializer, result2);
        }
    }

    @Override
    @NotNull
    public List<OCExpression> getArgumentExpressions() {
        return ((OCCompoundInitializer)this.getElement()).getInitializerExpressions();
    }
}

