/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.parameterInfo;

import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.editor.parameterInfo.OCFunctionCallOption;
import com.jetbrains.cidr.lang.editor.parameterInfo.OCFunctionParameterInfo;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCExpressionSymbol;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCVoidType;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCFunctionCallPlace<T extends PsiElement> {
    @NotNull
    private final T myElement;
    private static final Pattern LINE_BREAKS = Pattern.compile("\\s*\n+\\s*");

    public OCFunctionCallPlace(@NotNull T element) {
        this.myElement = element;
    }

    protected static void collectInitializationOptions(@NotNull OCType type2, @NotNull OCElement place, @NotNull Collection<OCFunctionCallOption> result2) {
        if (!place.getContainingOCFile().getKind().isCpp() || !type2.isInstanceable()) {
            return;
        }
        if (type2 instanceof OCStructType) {
            OCFunctionCallPlace.collectConstructorCallOptions(type2, place, result2);
        } else {
            if (!(type2 instanceof OCCppReferenceType)) {
                OCFunctionType t = new OCFunctionType(OCVoidType.instance(), Collections.emptyList());
                result2.add(new OCFunctionCallOption(new OCFunctionParameterInfo(t, null), -2));
            }
            OCFunctionType init = new OCFunctionType(OCVoidType.instance(), Collections.singletonList(type2), Collections.singletonList("<unnamed>"));
            result2.add(new OCFunctionCallOption(new OCFunctionParameterInfo(init, null), -1));
        }
    }

    protected static void collectConstructorCallOptions(@NotNull OCType rt, @NotNull PsiElement place, @NotNull Collection<OCFunctionCallOption> result2) {
        Collection functionSymbols;
        if (rt instanceof OCStructType) {
            CommonProcessors.CollectProcessor constructors = new CommonProcessors.CollectProcessor();
            ((OCStructType)rt).getSymbol().processConstructors((Processor<? super OCFunctionSymbol>)constructors);
            functionSymbols = constructors.getResults();
        } else {
            functionSymbols = null;
        }
        OCFunctionCallPlace.collectCallOptions(result2, place, functionSymbols, null);
    }

    protected static void collectCallOptions(@NotNull Collection<OCFunctionCallOption> result2, @NotNull PsiElement place, @Nullable Collection<OCSymbol> functionSymbols, @Nullable OCType qualifierType) {
        if (functionSymbols != null) {
            for (OCSymbol symbol : functionSymbols) {
                OCType type2;
                OCFunctionSymbol s;
                OCFunctionDefinition funcDef;
                if (symbol == null || (funcDef = (OCFunctionDefinition)PsiTreeUtil.getParentOfType((PsiElement)place, OCFunctionDefinition.class)) != null && (s = funcDef.getSymbol()) != null && s.getKind() == OCSymbolKind.CPP_CONSTRUCTOR_DECLARATION && symbol.isSameSymbol(s) || !OCVisibility.isVisible(symbol, place, qualifierType) || !((type2 = symbol.getType().resolve(place.getContainingFile()).getTerminalType()) instanceof OCFunctionType)) continue;
                OCFunctionType funType = (OCFunctionType)type2;
                List defaultValues = null;
                if (symbol instanceof OCFunctionSymbol && !funType.hasNoParameters()) {
                    List<OCDeclaratorSymbol> params = ((OCFunctionSymbol)symbol).getParameterSymbols(new OCResolveContext(funcDef));
                    defaultValues = ContainerUtil.map(params, symbol1 -> {
                        OCExpressionSymbol initializer = symbol1.getInitializer();
                        if (initializer == null) {
                            return null;
                        }
                        return LINE_BREAKS.matcher(initializer.getPresentableName()).replaceAll(" ");
                    });
                }
                OCFunctionParameterInfo info = new OCFunctionParameterInfo(funType, defaultValues);
                result2.add(new OCFunctionCallOption(info, symbol.getOffset()));
            }
        }
    }

    @NotNull
    public T getElement() {
        return this.myElement;
    }

    public abstract void collectCallOptions(@NotNull Collection<OCFunctionCallOption> var1);

    @NotNull
    public abstract List<OCExpression> getArgumentExpressions();
}

