/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.smartEnter;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.editor.smartEnter.OCFixer;
import com.jetbrains.cidr.lang.editor.smartEnter.OCSmartEnterProcessor;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCDoWhileStatement;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import org.jetbrains.annotations.NotNull;

public class DoWhileConditionFixer
extends OCFixer {
    @Override
    public void apply(@NotNull Editor editor, @NotNull OCSmartEnterProcessor processor2, @NotNull PsiElement psiElement) throws IncorrectOperationException {
        if (!DoWhileConditionFixer.applicable(psiElement)) {
            return;
        }
        OCDoWhileStatement doStatement = (OCDoWhileStatement)psiElement;
        OCStatement body2 = doStatement.getBody();
        if (DoWhileConditionFixer.fixBlockIfNeed(editor, body2, false)) {
            return;
        }
        Document doc = editor.getDocument();
        ASTNode whileKeyword = doStatement.getWhileKeyword();
        if (!(whileKeyword != null || body2 != null && body2 instanceof OCBlockStatement)) {
            int startOffset = DoWhileConditionFixer.getRangeWithMacros(doStatement).getStartOffset();
            doc.replaceString(startOffset, startOffset + "do".length(), (CharSequence)"do {} while()");
            return;
        }
        if (body2 != null) {
            ASTNode lpar = doStatement.getLParenth();
            ASTNode rpar = doStatement.getRParenth();
            if (DoWhileConditionFixer.hasDoEmptyCondition(doStatement)) {
                if (whileKeyword == null) {
                    int endOffset = DoWhileConditionFixer.getRangeWithMacros(doStatement).getEndOffset();
                    doc.insertString(endOffset, (CharSequence)"while()");
                } else if (lpar == null) {
                    doc.insertString(DoWhileConditionFixer.getRangeWithMacros(whileKeyword).getEndOffset(), (CharSequence)"()");
                } else if (rpar == null) {
                    doc.insertString(DoWhileConditionFixer.getRangeWithMacros(lpar).getEndOffset(), (CharSequence)")");
                } else {
                    processor2.registerUnresolvedError(DoWhileConditionFixer.getRangeWithMacros(lpar).getEndOffset());
                }
            } else if (doStatement.getCondition() != null && rpar == null) {
                doc.insertString(DoWhileConditionFixer.getRangeWithMacros(doStatement.getCondition()).getEndOffset(), (CharSequence)")");
            }
        }
    }

    public static boolean applicable(@NotNull PsiElement psiElement) {
        return psiElement instanceof OCDoWhileStatement && !DoWhileConditionFixer.hasMacroBasedStatement(psiElement, OCTokenTypes.DO_KEYWORD);
    }

    private static boolean hasDoEmptyCondition(@NotNull OCDoWhileStatement stmt) {
        if (stmt.getCondition() != null) {
            return false;
        }
        return stmt.getLParenth() == null || OCElementUtil.isIncompleteExpressionError(stmt.getLParenth().getTreeNext().getPsi());
    }
}

