/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.smartEnter;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.editor.smartEnter.OCFixer;
import com.jetbrains.cidr.lang.editor.smartEnter.OCSmartEnterProcessor;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCDeclarationOrExpression;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCForStatement;
import com.jetbrains.cidr.lang.psi.OCForeachStatement;
import com.jetbrains.cidr.lang.psi.OCLoopStatement;
import com.jetbrains.cidr.lang.psi.OCStatement;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class ForStatementFixer
extends OCFixer {
    public static final OCElementType IN_PSEUDOTYPE = new OCElementType("in");

    @Override
    public void apply(@NotNull Editor editor, @NotNull OCSmartEnterProcessor processor2, @NotNull PsiElement psiElement) throws IncorrectOperationException {
        if (psiElement instanceof OCForStatement || psiElement instanceof OCForeachStatement) {
            if (ForStatementFixer.hasMacroBasedStatement(psiElement, OCTokenTypes.FOR_KEYWORD)) {
                return;
            }
            Document doc = editor.getDocument();
            OCLoopStatement forStatement = (OCLoopStatement)psiElement;
            ASTNode rParenth = forStatement.getRParenth();
            ASTNode lParenth = forStatement.getLParenth();
            if (lParenth == null) {
                int stopOffset = doc.getLineEndOffset(doc.getLineNumber(ForStatementFixer.getRangeWithMacros(forStatement).getStartOffset()));
                OCStatement block = forStatement.getBody();
                if (block != null) {
                    stopOffset = Math.min(stopOffset, ForStatementFixer.getRangeWithMacros(block).getStartOffset());
                }
                stopOffset = Math.min(stopOffset, ForStatementFixer.getRangeWithMacros(forStatement).getEndOffset());
                doc.replaceString(ForStatementFixer.getRangeWithMacros(forStatement).getStartOffset(), stopOffset, (CharSequence)"for ()");
                processor2.registerUnresolvedError(ForStatementFixer.getRangeWithMacros(forStatement).getStartOffset() + "for (".length());
                return;
            }
            int lastErrorOffset = -1;
            int insertOffset = ForStatementFixer.getRangeWithMacros(lParenth).getEndOffset();
            if (psiElement instanceof OCForStatement) {
                OCStatement init = ((OCForStatement)forStatement).getInitializer();
                if (ForStatementFixer.fixSemicolonAtTheEnd(editor, init)) {
                    return;
                }
                OCDeclarationOrExpression condition2 = ((OCForStatement)forStatement).getCondition();
                if (ForStatementFixer.fixSemicolonAtTheEnd(editor, condition2)) {
                    return;
                }
                OCStatement update2 = ((OCForStatement)forStatement).getIncrement();
                ASTNode forNode = psiElement.getNode();
                ASTNode lastSemi = TreeUtil.findChildBackward(forNode, OCTokenTypes.SEMICOLON);
                if (lastSemi == null) {
                    lastErrorOffset = ForStatementFixer.getRangeWithMacros(lParenth).getEndOffset();
                } else {
                    insertOffset = ForStatementFixer.hasEmptyStatement(update2) ? ForStatementFixer.getRangeWithMacros(lastSemi).getEndOffset() : ForStatementFixer.getRangeWithMacros(update2).getEndOffset();
                    ASTNode firstSemi = forNode.findChildByType((IElementType)OCTokenTypes.SEMICOLON);
                    assert (firstSemi != null);
                    if (processor2.isFirstFixAttempt() && firstSemi != lastSemi) {
                        int offset = editor.getCaretModel().getOffset();
                        if (offset > insertOffset) {
                            offset = ForStatementFixer.getRangeWithMacros(lParenth).getEndOffset();
                        }
                        lastErrorOffset = offset < ForStatementFixer.getRangeWithMacros(lParenth).getEndOffset() && ForStatementFixer.hasEmptyStatement(init) ? ForStatementFixer.getRangeWithMacros(firstSemi).getStartOffset() : (offset <= ForStatementFixer.getRangeWithMacros(firstSemi).getStartOffset() && ForStatementFixer.hasEmptyStatement(condition2) ? ForStatementFixer.getRangeWithMacros(lastSemi).getStartOffset() : (offset <= ForStatementFixer.getRangeWithMacros(lastSemi).getStartOffset() && ForStatementFixer.hasEmptyStatement(update2) ? insertOffset : -1));
                    } else if (rParenth != null) {
                        if (ForStatementFixer.hasEmptyStatement(init) && lastSemi != firstSemi) {
                            lastErrorOffset = ForStatementFixer.getRangeWithMacros(firstSemi).getStartOffset();
                        } else if (ForStatementFixer.hasEmptyStatement(condition2)) {
                            lastErrorOffset = lastSemi == firstSemi ? ForStatementFixer.getRangeWithMacros(firstSemi).getEndOffset() : ForStatementFixer.getRangeWithMacros(lastSemi).getStartOffset();
                        } else if (ForStatementFixer.hasEmptyStatement(update2)) {
                            lastErrorOffset = ForStatementFixer.getRangeWithMacros(rParenth).getStartOffset();
                        }
                    }
                }
            } else {
                OCElement declaration2 = ((OCForeachStatement)forStatement).getVariableDeclaration();
                if (declaration2 == null) {
                    declaration2 = ((OCForeachStatement)forStatement).getVariableExpression();
                }
                if (!ForStatementFixer.hasEmptyStatement(declaration2)) {
                    insertOffset = lastErrorOffset = ForStatementFixer.moveAfter(declaration2, ((OCForeachStatement)forStatement).isCpp11Foreach() ? OCTokenTypes.COLON : IN_PSEUDOTYPE);
                    OCExpression expression2 = ((OCForeachStatement)forStatement).getCollectionExpression();
                    if (!ForStatementFixer.hasEmptyStatement(expression2)) {
                        insertOffset = ForStatementFixer.getRangeWithMacros(expression2).getEndOffset();
                        lastErrorOffset = -1;
                    }
                }
            }
            if (rParenth == null) {
                doc.insertString(Math.min(insertOffset, doc.getTextLength()), (CharSequence)")");
            }
            if (lastErrorOffset != -1) {
                processor2.registerUnresolvedError(lastErrorOffset);
            }
        }
    }

    @Contract(pure=true)
    private static int moveAfter(@NotNull OCElement declaration2, @NotNull IElementType type2) {
        ASTNode sibling = ForStatementFixer.getNextEssentialLeaf(declaration2.getNode());
        if (sibling != null && (type2 == sibling.getElementType() || type2 == IN_PSEUDOTYPE && "in".equals(sibling.getText()))) {
            return ForStatementFixer.getRangeWithMacros(sibling).getEndOffset();
        }
        return ForStatementFixer.getRangeWithMacros(declaration2).getEndOffset();
    }
}

