/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.smartEnter;

import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.editor.smartEnter.OCFixer;
import com.jetbrains.cidr.lang.editor.smartEnter.OCSmartEnterProcessor;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCCatchSection;
import com.jetbrains.cidr.lang.psi.OCParameterList;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import org.jetbrains.annotations.NotNull;

public class ParameterListFixer
extends OCFixer {
    @Override
    public void apply(@NotNull Editor editor, @NotNull OCSmartEnterProcessor processor2, @NotNull PsiElement psiElement) throws IncorrectOperationException {
        int offset;
        OCParameterList list;
        if (psiElement instanceof OCParameterList && !(psiElement.getParent() instanceof OCCatchSection) && OCElementUtil.getElementType((list = (OCParameterList)psiElement).getLastChild()) != OCTokenTypes.RPAR && (offset = ParameterListFixer.getCompletionPointAfterLPAR(editor, psiElement)) >= 0) {
            PsiElement lastElement = list.getLastElement();
            if (lastElement != null) {
                offset = Math.min(offset, ParameterListFixer.getRangeWithMacros(lastElement).getEndOffset());
            }
            editor.getDocument().insertString(offset, (CharSequence)")");
        }
    }
}

