/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.surround;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.editor.surround.OCStatementSurrounder;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCSynchronizedStatement;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;

public class OCSynchronizedSurrounder
extends OCStatementSurrounder<OCSynchronizedStatement> {
    @Override
    protected String getStatementTemplate(Project project2, PsiElement context) {
        return "@synchronized (a) {\n}";
    }

    @Override
    protected PsiElement getInsertionPlace(OCSynchronizedStatement statement2) {
        return statement2.getBody();
    }

    @Override
    protected TextRange getSelectionRange(OCSynchronizedStatement statement2) {
        OCExpression lock = statement2.getLockExpression();
        int offset = lock.getRangeWithMacros().getStartOffset();
        OCChangeUtil.delete(lock);
        return new TextRange(offset, offset);
    }

    public String getTemplateDescription() {
        return "@synchronized";
    }

    @Override
    protected OCLanguageKind getLanguageKind() {
        return OCLanguageKind.OBJ_C;
    }
}

