/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.surround;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.editor.surround.OCExpressionSurrounder;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import org.jetbrains.annotations.NotNull;

public abstract class OCTextExpressionSurrounder
extends OCExpressionSurrounder {
    @Override
    public TextRange surroundExpression(Project project2, Editor editor, OCExpression expr) throws IncorrectOperationException {
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project2);
        OCExpression template = (OCExpression)codeStyleManager.reformat((PsiElement)OCElementFactory.expressionFromText(this.getBeforeText() + expr.getTextWithMacros() + this.getAfterText(), expr));
        expr = (OCExpression)expr.replace(template);
        int offset = expr.getTextRange().getEndOffset();
        return new TextRange(offset, offset);
    }

    @NotNull
    protected abstract String getBeforeText();

    @NotNull
    protected abstract String getAfterText();
}

