/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.surround;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.editor.surround.OCExpressionSurrounder;
import com.jetbrains.cidr.lang.psi.OCExpression;

class OCaWithCastSurrounder
extends OCExpressionSurrounder {
    OCaWithCastSurrounder() {
    }

    @Override
    public boolean isApplicable(OCExpression expr) {
        return !expr.getType().isVoid();
    }

    @Override
    public TextRange surroundExpression(Project project2, Editor editor, OCExpression expr) throws IncorrectOperationException {
        assert (expr.isValid());
        Template template = OCaWithCastSurrounder.generateTemplate(project2, expr);
        TextRange range = expr.getRangeWithMacros();
        editor.getDocument().deleteString(range.getStartOffset(), range.getEndOffset());
        editor.getCaretModel().moveToOffset(range.getStartOffset());
        editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        TemplateManager.getInstance(project2).startTemplate(editor, template);
        return null;
    }

    private static Template generateTemplate(Project project2, OCExpression expression2) {
        String exprText = expression2.getTextWithMacros();
        TemplateManager templateManager = TemplateManager.getInstance(project2);
        Template template = templateManager.createTemplate("", "");
        template.setToReformat(true);
        template.addTextSegment("((");
        int refCount = 0;
        String typeName = expression2.getType().getGuessedType().getCanonicalName(expression2);
        while (typeName.endsWith("*")) {
            ++refCount;
            typeName = typeName.substring(0, typeName.length() - 1).trim();
        }
        final TextResult result2 = new TextResult(typeName);
        Expression expr = new Expression(){

            public Result calculateResult(ExpressionContext context) {
                return result2;
            }

            public Result calculateQuickResult(ExpressionContext context) {
                return this.calculateResult(context);
            }

            public LookupElement[] calculateLookupItems(ExpressionContext context) {
                return null;
            }
        };
        template.addVariable("type", expr, true);
        StringBuilder builder = new StringBuilder();
        while (refCount > 0) {
            builder.append('*');
            --refCount;
        }
        builder.append(")").append(exprText).append(")");
        template.addTextSegment(builder.toString());
        template.addEndVariable();
        return template;
    }

    public String getTemplateDescription() {
        return CodeInsightBundle.message((String)"surround.with.cast.template", (Object[])new Object[0]);
    }
}

