/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.formatting;

import com.intellij.formatting.Block;
import com.intellij.formatting.Indent;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.cidr.lang.formatting.OCIndentChanger;
import com.jetbrains.cidr.lang.formatting.OCSimpleBlock;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCPunctuatorElementType;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCFormatterUtil {
    public static final TokenSet FORMAT_DIRECTIVES = TokenSet.orSet((TokenSet[])new TokenSet[]{OCTokenTypes.DIRECTIVES, OCElementTypes.DIRECTIVES, TokenSet.create((IElementType[])new IElementType[]{OCTokenTypes.HASH})});
    public static final TokenSet FORMAT_DIRECTIVES_AND_NON_COMPILED = TokenSet.orSet((TokenSet[])new TokenSet[]{OCTokenTypes.DIRECTIVES, OCElementTypes.DIRECTIVES, TokenSet.create((IElementType[])new IElementType[]{OCTokenTypes.HASH, OCTokenTypes.CONDITIONALLY_NON_COMPILED_COMMENT})});
    public static final TokenSet FORMAT_PROBLEM_LEAFS_IN_NONCOMPILED = TokenSet.orSet((TokenSet[])new TokenSet[]{OCTokenTypes.RAW_STRING_LITERALS, TokenSet.create((IElementType[])new IElementType[]{OCTokenTypes.BLOCK_COMMENT})});
    public static final TokenSet FORMAT_DIRECTIVES_INCREASE_INDENT = TokenSet.orSet((TokenSet[])new TokenSet[]{OCTokenTypes.IF_DIRECTIVES, TokenSet.create((IElementType[])new IElementType[]{OCTokenTypes.ELSE_DIRECTIVE, OCTokenTypes.ELIF_DIRECTIVE})});
    private static final TokenSet CLASS_CHILDREN = TokenSet.create((IElementType[])new IElementType[]{OCElementTypes.FUNCTION_DEFINITION, OCElementTypes.FUNCTION_DECLARATION});
    private static TokenSet CLASS_DECL_HEADER_PARTS = TokenSet.create((IElementType[])new IElementType[]{OCElementTypes.INSTANCE_VARIABLES_LIST, OCElementTypes.SUPER_CLASS_REF, OCElementTypes.PROTOCOL_LIST, OCElementTypes.GENERIC_PARAMETERS_LIST, OCElementTypes.CATEGORY_NAME});
    private static TokenSet CLASS_DECL_KEYWORDS = TokenSet.create((IElementType[])new IElementType[]{OCTokenTypes.PROTOCOL_KEYWORD, OCTokenTypes.INTERFACE_KEYWORD, OCTokenTypes.IMPLEMENTATION_KEYWORD});
    public static final TokenSet SPACES_COMMENTS = TokenSet.orSet((TokenSet[])new TokenSet[]{OCTokenTypes.WHITESPACES, OCTokenTypes.COMMENTS});
    public static final TokenSet MACRO_SPACES_COMMENTS = TokenSet.orSet((TokenSet[])new TokenSet[]{TokenSet.create((IElementType[])new IElementType[]{OCElementTypes.MACRO_CALL}), SPACES_COMMENTS});

    public static String _sr(Document document, int startOffset, int endOffset) {
        return OCFormatterUtil.showRangeInDoc(document, startOffset, endOffset);
    }

    public static String _sr(Document document, int offset) {
        return OCFormatterUtil.showRangeInDoc(document, offset, offset);
    }

    public static String showRangeInDoc(Document document, int startOffset, int endOffset) {
        String st = document.getText();
        StringBuilder sb = new StringBuilder(st.length() + 2);
        sb.append(st.substring(0, startOffset));
        sb.append('|');
        sb.append(st.substring(startOffset, endOffset));
        sb.append('|');
        sb.append(st.substring(endOffset));
        return sb.toString();
    }

    public static String showRangeInDoc(Document document, TextRange textRange) {
        return OCFormatterUtil.showRangeInDoc(document, textRange.getStartOffset(), textRange.getEndOffset());
    }

    @Contract(value="null, _->false")
    public static boolean isOrFollows(ASTNode node, IElementType expectedType) {
        while (node != null) {
            if (node.getElementType() == expectedType) {
                return true;
            }
            node = node.getTreePrev();
        }
        return false;
    }

    public static boolean isNotEmptyAndOneOf(ASTNode node, PsiElement ... candidates) {
        return OCElementUtil.getElementType(node) != OCElementTypes.EMPTY_STATEMENT && OCElementUtil.isOneOf(node, candidates);
    }

    @Contract(value="null->false")
    public static boolean isAnyLBrace(IElementType tokenType) {
        return tokenType == OCTokenTypes.LBRACE || tokenType == OCTokenTypes.LBRACKET || tokenType == OCTokenTypes.LPAR;
    }

    @Contract(value="null->false")
    public static boolean isAnyRBrace(IElementType tokenType) {
        return tokenType == OCTokenTypes.RBRACE || tokenType == OCTokenTypes.RBRACKET || tokenType == OCTokenTypes.RPAR;
    }

    @Contract(value="null->false")
    public static boolean isBlock(IElementType type2) {
        return OCElementTypes.BLOCK_STATEMENTS.contains(type2);
    }

    @Contract(value="null->false")
    public static boolean isInsideAnyBraces(@Nullable ASTNode node) {
        if (node == null) {
            return false;
        }
        int counter = 0;
        while ((node = node.getTreePrev()) != null) {
            if (OCFormatterUtil.isAnyLBrace(node.getElementType())) {
                ++counter;
                continue;
            }
            if (!OCFormatterUtil.isAnyRBrace(node.getElementType())) continue;
            --counter;
        }
        return counter > 0;
    }

    @Contract(value="null->false")
    public static boolean isKeyword(@Nullable ASTNode node) {
        if (node == null) {
            return false;
        }
        IElementType elementType = OCElementUtil.getElementType(node);
        return OCTokenTypes.KEYWORDS.contains(elementType);
    }

    @Contract(value="null->false")
    public static boolean isClassHeader(@Nullable ASTNode node) {
        while (node != null && OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(node.getElementType())) {
            node = node.getTreeNext();
        }
        if (node == null) {
            return false;
        }
        IElementType et = node.getElementType();
        if (et == OCElementTypes.OBJC_KEYWORD) {
            ASTNode lc = node.getLastChildNode();
            return CLASS_DECL_KEYWORDS.contains(OCElementUtil.getElementType(lc)) && OCElementTypes.CLASSES.contains(OCElementUtil.getElementType(node.getTreeParent()));
        }
        if (et == OCTokenTypes.IDENTIFIER) {
            return OCElementTypes.CLASSES.contains(OCElementUtil.getElementType(node.getTreeParent()));
        }
        return CLASS_DECL_HEADER_PARTS.contains(et);
    }

    public static boolean isClassMember(ASTNode node) {
        return !OCFormatterUtil.isClassHeader(node) && OCTokenTypes.END_KEYWORD != OCElementUtil.getObjCKeywordElementType(node);
    }

    public static boolean isMessageArgumentValue(@NotNull ASTNode node) {
        return OCElementUtil.getElementType(node.getTreeParent()) == OCElementTypes.MESSAGE_ARGUMENT && node.getElementType() != OCElementTypes.ARGUMENT_SELECTOR;
    }

    public static boolean isVarArgArgument(@Nullable ASTNode node) {
        if (node == null) {
            return false;
        }
        if (node.getElementType() != OCElementTypes.MESSAGE_ARGUMENT) {
            return false;
        }
        ASTNode selector2 = node.findChildByType((IElementType)OCElementTypes.ARGUMENT_SELECTOR);
        return selector2 == null || StringUtil.isEmptyOrSpaces((String)selector2.getText());
    }

    public static boolean isFollowedByVarArg(@Nullable ASTNode node) {
        if (node == null) {
            return false;
        }
        if (node.getElementType() != OCElementTypes.MESSAGE_ARGUMENT) {
            return false;
        }
        while ((node = FormatterUtil.getNextNonWhitespaceSibling(node)) != null) {
            if (!OCFormatterUtil.isVarArgArgument(node)) continue;
            return true;
        }
        return false;
    }

    public static boolean isProtocolListOrReference(IElementType type2) {
        return type2 == OCElementTypes.PROTOCOL_LIST || type2 == OCElementTypes.REFERENCE_ELEMENT;
    }

    public static boolean isDeclarationOrDefinition(IElementType type2) {
        return type2 == OCElementTypes.DECLARATION_STATEMENT || type2 == OCElementTypes.DECLARATION || type2 == OCElementTypes.FUNCTION_DECLARATION || type2 == OCElementTypes.METHOD || type2 == OCElementTypes.PROPERTY || type2 == OCElementTypes.FUNCTION_DEFINITION || type2 == OCElementTypes.CLASS_PREDEF_LIST || OCElementTypes.CLASSES.contains(type2);
    }

    public static boolean isVariablesListOrStructure(IElementType type2) {
        return type2 == OCElementTypes.INSTANCE_VARIABLES_LIST || OCFormatterUtil.isStructure(type2);
    }

    public static boolean isCollectionOrStructureInitializer(@Nullable IElementType type2) {
        return type2 == OCElementTypes.COMPOUND_INITIALIZER || OCElementTypes.NS_COLLECTION_LITERALS.contains(type2);
    }

    public static boolean isStructure(IElementType type2) {
        return OCElementTypes.STRUCTURE_TYPES.contains(type2);
    }

    public static boolean isGlobalDeclarationScope(IElementType type2) {
        return OCFormatterUtil.isNamespace(type2) || type2 == OCTokenTypes.OC_FILE;
    }

    public static boolean isNamespace(IElementType type2) {
        return type2 == OCElementTypes.CPP_NAMESPACE;
    }

    public static boolean isStructureOrNamespace(IElementType type2) {
        return OCFormatterUtil.isStructure(type2) || OCFormatterUtil.isNamespace(type2);
    }

    @Contract(value="null->null")
    public static ASTNode getNextNonWhitespaceOrCommentSibling(@Nullable ASTNode node) {
        ASTNode prevNode;
        ASTNode aSTNode = prevNode = node == null ? null : node.getTreeNext();
        while (prevNode != null && OCFormatterUtil.isInessential(prevNode)) {
            prevNode = prevNode.getTreeNext();
        }
        return prevNode;
    }

    @Contract(value="null->null")
    public static ASTNode getPreviousNonWhitespaceOrCommentSibling(@Nullable ASTNode node) {
        ASTNode prevNode;
        ASTNode aSTNode = prevNode = node == null ? null : node.getTreePrev();
        while (prevNode != null && OCFormatterUtil.isInessential(prevNode)) {
            prevNode = prevNode.getTreePrev();
        }
        return prevNode;
    }

    @Contract(value="null->true")
    public static boolean isInessential(@Nullable ASTNode node) {
        return node == null || FormatterUtil.isWhitespaceOrEmpty(node) || OCTokenTypes.COMMENTS.contains(node.getElementType());
    }

    public static boolean isOCVisibilityKeywordOrCPPVisibilityColon(@Nullable ASTNode node) {
        return OCElementUtil.isOCVisibilityKeyword(node) || OCElementUtil.getElementType(node) == OCTokenTypes.COLON && OCElementUtil.isCPPVisibilityKeyword(OCFormatterUtil.getPreviousNonWhitespaceOrCommentSibling(node));
    }

    public static boolean isForOrForEachStatement(IElementType type2) {
        return type2 == OCElementTypes.FOR_STATEMENT || type2 == OCElementTypes.FOREACH_STATEMENT;
    }

    public static boolean isLoopStatement(IElementType type2) {
        return OCFormatterUtil.isForOrForEachStatement(type2) || type2 == OCElementTypes.WHILE_STATEMENT || type2 == OCElementTypes.DO_WHILE_STATEMENT;
    }

    public static boolean isControlStatement(IElementType type2) {
        return type2 == OCElementTypes.RETURN_STATEMENT || type2 == OCElementTypes.IF_STATEMENT || OCFormatterUtil.isLoopStatement(type2) || type2 == OCElementTypes.SWITCH_STATEMENT || type2 == OCElementTypes.CASE_STATEMENT || type2 == OCElementTypes.TRY_STATEMENT || type2 == OCElementTypes.SYNCHRONIZED_STATEMENT || type2 == OCElementTypes.AUTO_RELEASE_POOL_STATEMENT;
    }

    public static boolean isControlStatementOrSection(IElementType type2) {
        return OCFormatterUtil.isControlStatement(type2) || OCFormatterUtil.isControlSection(type2);
    }

    public static boolean isControlSection(IElementType type2) {
        return type2 == OCElementTypes.CATCH_SECTION || type2 == OCElementTypes.FINALLY_SECTION;
    }

    public static boolean isInsideDirective(@Nullable ASTNode node) {
        for (ASTNode each = node; each != null; each = each.getTreeParent()) {
            if (!OCFormatterUtil.isDirective(each)) continue;
            return true;
        }
        return false;
    }

    public static boolean isDirective(@Nullable ASTNode child) {
        return child != null && FORMAT_DIRECTIVES.contains(child.getElementType());
    }

    @Nullable
    public static <T> T processBraced(@Nullable ASTNode parent, @Nullable IElementType childType, boolean strictStart, @NotNull LeftBracesProcessor<T> processor2) {
        IElementType parentType = OCElementUtil.getElementType(parent);
        if (childType == OCElementTypes.INSTANCE_VARIABLES_LIST) {
            return processor2.processInterfaceOrStructure();
        }
        if (strictStart && OCFormatterUtil.isVariablesListOrStructure(parentType) && childType == OCTokenTypes.LBRACE || !strictStart && OCFormatterUtil.isVariablesListOrStructure(childType)) {
            return processor2.processInterfaceOrStructure();
        }
        if (strictStart && OCFormatterUtil.isNamespace(parentType) && childType == OCTokenTypes.LBRACE || !strictStart && OCFormatterUtil.isNamespace(childType)) {
            return processor2.processNamespace();
        }
        if (OCFormatterUtil.isBlock(childType)) {
            if (parentType == OCElementTypes.METHOD) {
                return processor2.processMethod();
            }
            if (parentType == OCElementTypes.FUNCTION_DEFINITION) {
                return processor2.processFunction();
            }
            if (parentType == OCElementTypes.BLOCK_EXPRESSION || parentType == OCElementTypes.CPP_LAMBDA_EXPRESSION) {
                return processor2.processBlock();
            }
            if (parentType == OCElementTypes.IF_STATEMENT) {
                return processor2.processIfStatement();
            }
            if (OCFormatterUtil.isForOrForEachStatement(parentType)) {
                return processor2.processForOrForEachStatement();
            }
            if (parentType == OCElementTypes.WHILE_STATEMENT) {
                return processor2.processWhileStatement();
            }
            if (parentType == OCElementTypes.DO_WHILE_STATEMENT) {
                return processor2.processDoWhileStatement();
            }
            if (parentType == OCElementTypes.SWITCH_STATEMENT) {
                return processor2.processSwitchStatement();
            }
            if (parentType == OCElementTypes.CASE_STATEMENT) {
                return processor2.processSwitchStatement();
            }
            if (parentType == OCElementTypes.TRY_STATEMENT) {
                return processor2.processTryStatement();
            }
            if (parentType == OCElementTypes.CATCH_SECTION) {
                return processor2.processCatchStatement();
            }
            if (parentType == OCElementTypes.FINALLY_SECTION) {
                return processor2.processFinallyStatement();
            }
            if (parentType == OCElementTypes.SYNCHRONIZED_STATEMENT) {
                return processor2.processSynchronizedStatement();
            }
            if (parentType == OCElementTypes.AUTO_RELEASE_POOL_STATEMENT) {
                return processor2.processAutoreleasePoolStatement();
            }
        }
        return null;
    }

    static boolean isObjCKeywordWithDog(IElementType elementType, ASTNode node, OCElementType requiredType) {
        return elementType == OCElementTypes.OBJC_KEYWORD && OCElementUtil.getObjCKeywordElementType(node) == requiredType;
    }

    public static boolean isCPPClassDeclaration(@Nullable ASTNode node) {
        if (OCElementUtil.getElementType(node) != OCElementTypes.DECLARATION) {
            return false;
        }
        ASTNode typeElement = node.findChildByType((IElementType)OCElementTypes.TYPE_ELEMENT);
        return typeElement != null && OCFormatterUtil.isCPPClass(typeElement.getFirstChildNode());
    }

    public static boolean isCPPClass(@Nullable ASTNode node) {
        return OCFormatterUtil.isClassStructUnion(node) && (node.getFirstChildNode().getElementType() == OCTokenTypes.CLASS_KEYWORD || node.findChildByType(CLASS_CHILDREN) != null);
    }

    public static boolean isClassStructUnion(@Nullable ASTNode node) {
        return OCElementUtil.getElementType(node) == OCElementTypes.STRUCT || OCElementUtil.getElementType(node) == OCElementTypes.UNION;
    }

    @Nullable
    public static ASTNode nextLeafInOwner(@NotNull ASTNode current, @NotNull ASTNode owner) {
        for (ASTNode nextSibling = current.getTreeNext(); nextSibling != null; nextSibling = nextSibling.getTreeNext()) {
            ASTNode first = OCFormatterUtil.firstLeaf(nextSibling);
            if (first == null) continue;
            return first;
        }
        ASTNode parent = current.getTreeParent();
        if (parent == owner || parent instanceof OCFile || parent == null) {
            return null;
        }
        return OCFormatterUtil.nextLeafInOwner(parent, owner);
    }

    @Nullable
    public static ASTNode prevLeafInOwner(@NotNull ASTNode current, @NotNull ASTNode owner) {
        for (ASTNode prevSibling = current.getTreePrev(); prevSibling != null; prevSibling = prevSibling.getTreePrev()) {
            ASTNode last = OCFormatterUtil.lastLeaf(prevSibling);
            if (last == null) continue;
            return last;
        }
        ASTNode parent = current.getTreeParent();
        if (parent == owner || parent instanceof OCFile || parent == null) {
            return null;
        }
        return OCFormatterUtil.prevLeafInOwner(parent, owner);
    }

    @Nullable
    public static ASTNode lastLeaf(@NotNull ASTNode element) {
        return TreeUtil.findLastLeaf(element);
    }

    @Nullable
    public static ASTNode firstLeaf(@NotNull ASTNode element) {
        return TreeUtil.findFirstLeaf(element);
    }

    public static boolean isAncestorOrSelf(@Nullable ASTNode ancestor, @NotNull ASTNode element) {
        if (ancestor == null) {
            return false;
        }
        if (ancestor == element) {
            return true;
        }
        ASTNode parent = element.getTreeParent();
        while (parent != null) {
            if (parent == ancestor) {
                return true;
            }
            parent = parent.getTreeParent();
        }
        return false;
    }

    @NotNull
    static ASTNode getBestCommonOwner(@NotNull ASTNode defaultOwner, @NotNull ASTNode node1, @NotNull ASTNode node2) {
        PsiElement p1 = node1.getPsi();
        PsiElement p2 = node2.getPsi();
        if (p1 != null && p2 != null) {
            PsiElement owner = PsiTreeUtil.findCommonParent((PsiElement)p1, (PsiElement)p2);
            if (owner instanceof LeafElement) {
                owner = owner.getParent();
            }
            if (owner != null && owner.getNode() != null) {
                return owner.getNode();
            }
        }
        return defaultOwner;
    }

    public static boolean isInBlockEnclosed(@Nullable ASTNode child, @NotNull ASTNode parent) {
        boolean isInlineEnclosed = false;
        boolean afterLBrace = false;
        for (ASTNode node = parent.getFirstChildNode(); node != null; node = node.getTreeNext()) {
            IElementType type2 = node.getElementType();
            boolean whitespace = OCElementUtil.isWhitespace(node.getPsi());
            if (child != null && child == node || child == null && !whitespace && type2 != OCTokenTypes.LBRACE && type2 != OCTokenTypes.RBRACE) {
                isInlineEnclosed = true;
                continue;
            }
            if (type2 == OCTokenTypes.LBRACE) {
                afterLBrace = true;
                continue;
            }
            if (!afterLBrace || (isInlineEnclosed || !node.textContains('\n')) && (type2 == OCTokenTypes.RBRACE || whitespace)) continue;
            return false;
        }
        return isInlineEnclosed || child == null;
    }

    @Contract(value="null -> false")
    public static boolean isDirectlyInsideSwitch(@Nullable ASTNode node) {
        if (node == null) {
            return false;
        }
        ASTNode parent = node.getTreeParent();
        IElementType parentType = OCElementUtil.getElementType(parent);
        if (OCElementTypes.BLOCK_STATEMENTS.contains(parentType)) {
            parentType = OCElementUtil.getElementType(parent.getTreeParent());
        }
        return parentType == OCElementTypes.SWITCH_STATEMENT;
    }

    public static LABEL_TYPE getLabelType(@Nullable ASTNode node) {
        LABEL_TYPE ret = LABEL_TYPE.OTHER;
        while (node != null) {
            IElementType nodeType = node.getElementType();
            if (nodeType == OCElementTypes.LABELED_STATEMENT) {
                ret = LABEL_TYPE.LABEL_LIKE;
            } else {
                if (nodeType != OCElementTypes.CASE_STATEMENT) break;
                ret = LABEL_TYPE.CASE_LIKE;
            }
            if (OCFormatterUtil.isDirectlyInsideSwitch(node)) {
                return LABEL_TYPE.CASE_LIKE;
            }
            node = node.getTreeParent();
        }
        return ret;
    }

    private static ASTNode getPrev(@Nullable ASTNode node) {
        IElementType prevType;
        ASTNode prevNode;
        ASTNode aSTNode = prevNode = node == null ? null : node.getTreePrev();
        while (prevNode != null && MACRO_SPACES_COMMENTS.contains(prevType = prevNode.getElementType())) {
            prevNode = prevNode.getTreePrev();
        }
        return prevNode;
    }

    @Contract(value="null,_->false")
    public static boolean isPrecededBy(@Nullable ASTNode node, IElementType expectedType) {
        return OCElementUtil.getElementType(OCFormatterUtil.getPrev(node)) == expectedType;
    }

    @Contract(value="null,_->false")
    public static boolean isPrecededBy(@Nullable ASTNode node, TokenSet expectedTypes) {
        return expectedTypes.contains(OCElementUtil.getElementType(OCFormatterUtil.getPrev(node)));
    }

    public static boolean isFirstEssentialChild(@NotNull ASTNode child) {
        IElementType nextType;
        ASTNode nextNode;
        ASTNode parent = child.getTreeParent();
        if (parent == null) {
            return true;
        }
        for (nextNode = parent.getFirstChildNode(); nextNode != null && ((nextType = nextNode.getElementType()) instanceof OCPunctuatorElementType || MACRO_SPACES_COMMENTS.contains(nextType)); nextNode = nextNode.getTreeNext()) {
        }
        return nextNode == child;
    }

    public static void applyIndentCorrection(boolean useSmartIndent, List<Block> collector, int wrapType, boolean keepLineBreak, Condition<ASTNode> isReindentedNode) {
        if (wrapType == 0 && !keepLineBreak) {
            return;
        }
        boolean needEnforceIndent = useSmartIndent;
        if (!needEnforceIndent) {
            int count = 0;
            for (Block wrapBlock : collector) {
                PsiElement psi;
                ASTNode beforeFirstNode;
                ASTNode firstNode = OCSimpleBlock.extractFirstNode(wrapBlock);
                if (!isReindentedNode.value((Object)firstNode) || ++count <= 1) continue;
                boolean bl = needEnforceIndent = wrapType == 2;
                if (!needEnforceIndent && ((beforeFirstNode = FormatterUtil.getPreviousLeaf(firstNode, new IElementType[0])) == null || !(needEnforceIndent = (psi = beforeFirstNode.getPsi()) != null && psi instanceof PsiWhiteSpace && psi.textContains('\n')))) continue;
                break;
            }
        }
        if (needEnforceIndent) {
            Indent indent = useSmartIndent ? Indent.getSmartIndent((Indent.Type)Indent.Type.CONTINUATION) : Indent.getIndent((Indent.Type)Indent.Type.CONTINUATION, (boolean)false, (boolean)true);
            for (Block wrapBlock : collector) {
                if (!(wrapBlock instanceof OCIndentChanger) || !isReindentedNode.value((Object)OCSimpleBlock.extractFirstNode(wrapBlock))) continue;
                ((OCIndentChanger)wrapBlock).putIndent(indent);
            }
        }
    }

    private static boolean isNestedNamespacePart(@Nullable ASTNode node) {
        if (node != null && node.getElementType() == OCElementTypes.CPP_NAMESPACE) {
            ASTNode first = node.getFirstChildNode();
            return first != null && first.getElementType() == OCTokenTypes.COLON2X;
        }
        return false;
    }

    public static boolean isNestedInlineBlock(@NotNull CommonCodeStyleSettings commonSettings, @NotNull OCCodeStyleSettings ocSettings, @Nullable ASTNode node) {
        return ocSettings.KEEP_NESTED_NAMESPACES_IN_ONE_LINE && OCElementUtil.getElementType(node) == OCElementTypes.CPP_NAMESPACE && OCElementUtil.getElementType(node.getTreeParent()) == OCElementTypes.CPP_NAMESPACE && OCFormatterUtil.isInBlockEnclosed(node, node.getTreeParent()) || OCFormatterUtil.isNestedNamespacePart(node);
    }

    public static boolean isNestedBlockOwner(@NotNull CommonCodeStyleSettings commonSettings, @NotNull OCCodeStyleSettings ocSettings, @NotNull ASTNode owner) {
        ASTNode child = owner.findChildByType((IElementType)OCElementTypes.CPP_NAMESPACE);
        return ocSettings.KEEP_NESTED_NAMESPACES_IN_ONE_LINE && OCElementUtil.getElementType(owner) == OCElementTypes.CPP_NAMESPACE && OCFormatterUtil.isNestedInlineBlock(commonSettings, ocSettings, child) || OCFormatterUtil.isNestedNamespacePart(child);
    }

    public static boolean isNamespaceWithKeyword(@Nullable ASTNode node) {
        return node != null && node.getElementType() == OCElementTypes.CPP_NAMESPACE && !OCFormatterUtil.isNestedNamespacePart(node);
    }

    public static abstract class LeftBracesProcessor<T> {
        public T processNamespace() {
            return this.processGeneral();
        }

        public T processInterfaceOrStructure() {
            return this.processGeneral();
        }

        public T processMethod() {
            return this.processGeneral();
        }

        public T processFunction() {
            return this.processGeneral();
        }

        public T processBlock() {
            return this.processFunction();
        }

        public T processIfStatement() {
            return this.processGeneral();
        }

        public T processForOrForEachStatement() {
            return this.processGeneral();
        }

        public T processWhileStatement() {
            return this.processGeneral();
        }

        public T processDoWhileStatement() {
            return this.processGeneral();
        }

        public T processSwitchStatement() {
            return this.processGeneral();
        }

        public T processTryStatement() {
            return this.processGeneral();
        }

        public T processCatchStatement() {
            return this.processGeneral();
        }

        public T processFinallyStatement() {
            return this.processGeneral();
        }

        public T processSynchronizedStatement() {
            return this.processGeneral();
        }

        public T processAutoreleasePoolStatement() {
            return this.processGeneral();
        }

        public T processGeneral() {
            return null;
        }
    }

    static enum LABEL_TYPE {
        CASE_LIKE,
        LABEL_LIKE,
        OTHER;

    }
}

