/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.formatting;

import com.intellij.formatting.Block;
import com.intellij.formatting.FormatTextRanges;
import com.intellij.formatting.FormattingDocumentModel;
import com.intellij.formatting.FormattingMode;
import com.intellij.formatting.FormattingModel;
import com.intellij.formatting.FormattingModelBuilderEx;
import com.intellij.formatting.Spacing;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.formatter.FormattingDocumentModelImpl;
import com.intellij.psi.formatter.common.AbstractBlock;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.cidr.lang.formatting.OCPsiBasedFormattingModel;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCMethod;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCFormattingModelBuilder
implements FormattingModelBuilderEx {
    public static final Key<Boolean> ALWAYS_CREATE_FULL_MODEL = new Key("Never use DumbModel in dumb app state");
    private static final ThreadLocal<AtomicInteger> myAlwaysCreateFullModel = new ThreadLocal<AtomicInteger>(){

        @Override
        protected AtomicInteger initialValue() {
            return new AtomicInteger(0);
        }
    };

    @NotNull
    public FormattingModel createModel(PsiElement element, CodeStyleSettings settings) {
        return this.createModel(element, settings, FormattingMode.REFORMAT);
    }

    @Override
    @NotNull
    public FormattingModel createModel(@NotNull PsiElement element, @NotNull CodeStyleSettings settings, @NotNull FormattingMode mode) {
        boolean alwaysCreateFullModel;
        boolean bl = alwaysCreateFullModel = OCFormattingModelBuilder.isAlwaysCreateFullModel() || Boolean.TRUE.equals(element.getUserData(ALWAYS_CREATE_FULL_MODEL));
        if (!alwaysCreateFullModel && DumbService.getInstance((Project)element.getProject()).isDumb()) {
            return OCFormattingModelBuilder.createDumbModel(element);
        }
        PsiFile file2 = element.getContainingFile();
        return new OCPsiBasedFormattingModel(file2, settings, mode);
    }

    @Override
    @Nullable
    public CommonCodeStyleSettings.IndentOptions getIndentOptionsToUse(@NotNull PsiFile file2, @NotNull FormatTextRanges ranges, @NotNull CodeStyleSettings settings) {
        return null;
    }

    public TextRange getRangeAffectingIndent(PsiFile file2, int offset, ASTNode elementAtOffset) {
        OCElement parent = (OCElement)PsiTreeUtil.getNonStrictParentOfType((PsiElement)file2.findElementAt(offset), (Class[])new Class[]{OCMethod.class, OCExpression.class});
        return parent != null ? parent.getTextRange() : null;
    }

    public static void requestAlwaysCreateFullModel() {
        myAlwaysCreateFullModel.get().incrementAndGet();
    }

    public static void releaseAlwaysCreateFullModel() {
        myAlwaysCreateFullModel.get().decrementAndGet();
    }

    private static boolean isAlwaysCreateFullModel() {
        return myAlwaysCreateFullModel.get().get() > 0;
    }

    private static FormattingModel createDumbModel(PsiElement element) {
        final AbstractBlock block = new AbstractBlock(element.getNode(), null, null){

            @Override
            protected List<Block> buildChildren() {
                return EMPTY;
            }

            @Nullable
            public Spacing getSpacing(@Nullable Block child1, @NotNull Block child2) {
                return null;
            }

            public boolean isLeaf() {
                return false;
            }
        };
        final Document document = FormattingDocumentModelImpl.createOn(element.getContainingFile()).getDocument();
        final FormattingDocumentModel model = new FormattingDocumentModel(){

            public int getLineNumber(int offset) {
                return document.getLineNumber(offset);
            }

            public int getLineStartOffset(int line) {
                return document.getLineStartOffset(line);
            }

            public CharSequence getText(TextRange textRange) {
                return document.getText(textRange);
            }

            public int getTextLength() {
                return document.getTextLength();
            }

            @NotNull
            public Document getDocument() {
                return document;
            }

            public boolean containsWhiteSpaceSymbolsOnly(int startOffset, int endOffset) {
                return false;
            }

            @NotNull
            public CharSequence adjustWhiteSpaceIfNecessary(@NotNull CharSequence whiteSpaceText, int startOffset, int endOffset, ASTNode nodeAfter, boolean changedViaPsi) {
                return whiteSpaceText;
            }
        };
        return new FormattingModel(){

            @NotNull
            public Block getRootBlock() {
                return block;
            }

            @NotNull
            public FormattingDocumentModel getDocumentModel() {
                return model;
            }

            public TextRange replaceWhiteSpace(TextRange textRange, String whiteSpace) {
                return textRange;
            }

            public TextRange shiftIndentInsideRange(ASTNode node, TextRange range, int indent) {
                return range;
            }

            public void commitChanges() {
            }
        };
    }
}

