/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.generate;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ObjectUtils;
import com.jetbrains.cidr.lang.generate.OCGenerateUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCCaretLocation {
    @NotNull
    private final PsiFile myFile;
    @Nullable
    private final PsiElement myElement;
    private final int myOffsetInElement;

    @NotNull
    public static OCCaretLocation byEditor(@NotNull PsiFile file2, @Nullable Editor editor) {
        PsiElement element = editor == null ? null : OCGenerateUtil.getElementAt(editor, file2);
        int offset = editor == null ? -1 : Math.max(0, editor.getCaretModel().getOffset() - element.getTextRange().getStartOffset());
        return new OCCaretLocation(file2, element, offset);
    }

    @NotNull
    public static OCCaretLocation byOffset(@NotNull PsiFile file2, int offsetInFile) {
        PsiElement element = (PsiElement)ObjectUtils.notNull((Object)file2.findElementAt(offsetInFile), (Object)file2);
        return new OCCaretLocation(file2, element, Math.min(element.getTextRange().getEndOffset(), Math.max(0, offsetInFile - element.getTextRange().getStartOffset())));
    }

    public static OCCaretLocation byFile(@NotNull PsiFile file2) {
        return new OCCaretLocation(file2, null, -1);
    }

    private OCCaretLocation(@NotNull PsiFile file2, @Nullable PsiElement element, int offsetInElement) {
        this.myFile = file2;
        this.myElement = element;
        this.myOffsetInElement = offsetInElement;
    }

    @Nullable
    public PsiElement getElement() {
        return this.myElement;
    }

    @Nullable
    public Integer getOffsetInFile() {
        return this.myElement == null ? null : Integer.valueOf(this.myElement.getTextRange().getStartOffset() + this.myOffsetInElement);
    }

    @NotNull
    public PsiFile getFile() {
        return this.myFile;
    }

    @NotNull
    public Project getProject() {
        return this.myFile.getProject();
    }
}

