/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.generate;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.generate.OCCaretLocation;
import com.jetbrains.cidr.lang.generate.OCGenerateUtil;
import com.jetbrains.cidr.lang.generate.OCNewCppFunctionsLocator;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCCppNamespace;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCStructLike;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceLikeSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCTemplateSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.OCMembersContainer;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCCallableUtil;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCCommonProcessors;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCCppDefinitionsUtil {
    public static SHOULD_GENERATE_DEFINITION shouldGenerateDefinitionsFor(@NotNull OCFunctionSymbol function, boolean checkNoncopyable) {
        OCType type2;
        List<OCType> parameterTypes;
        PsiFile file2 = function.getContainingPsiFile();
        if (!OCCodeInsightUtil.isValid((PsiElement)file2)) {
            return SHOULD_GENERATE_DEFINITION.NO;
        }
        if (function.isPureVirtual()) {
            return SHOULD_GENERATE_DEFINITION.NO;
        }
        if (!function.processSameSymbols((Processor<OCSymbol>)((Processor)s -> s.isPredeclaration() && (!(s instanceof OCFunctionSymbol) || !((OCFunctionSymbol)s).isDefault() && !((OCFunctionSymbol)s).isDelete())))) {
            return SHOULD_GENERATE_DEFINITION.NO;
        }
        if (!(function.getParent() instanceof OCStructSymbol)) {
            return SHOULD_GENERATE_DEFINITION.POSSIBLE;
        }
        if (checkNoncopyable && function.getVisibility() == OCVisibility.PRIVATE && (function.isCppConstructor() || function.isCppOperator() && function.getName().equals("operator=")) && (parameterTypes = function.getType().getParameterTypes()).size() == 1 && (type2 = parameterTypes.get(0)) instanceof OCCppReferenceType && function.getParent().getType().cloneWithConstModifier(file2.getProject()).equalsAfterResolving(((OCCppReferenceType)type2).getRefType(), (PsiElement)file2)) {
            return SHOULD_GENERATE_DEFINITION.POSSIBLE;
        }
        return SHOULD_GENERATE_DEFINITION.REQUIRED;
    }

    @NotNull
    public static OCMembersContainer getFunctionParent(@NotNull OCFunctionSymbol function) {
        return function.getParent() instanceof OCNamespaceLikeSymbol ? (OCNamespaceLikeSymbol)((Object)function.getParent()) : function.getContainingOCFile().getMembersContainer(false);
    }

    public static boolean shouldInlineNewDefinitions(@NotNull OCMembersContainer parent, @NotNull OCCaretLocation location) {
        if (location.getElement() != null) {
            if (!(parent instanceof OCSymbol) && parent.getContainingOCFile().equals(location.getFile()) && OCCppDefinitionsUtil.canDefinitionsBePlacedToAssocFile(parent)) {
                return false;
            }
            if (OCCppDefinitionsUtil.isLocationOutsideParent(location, OCCppDefinitionsUtil.getParentDefinition(parent))) {
                return false;
            }
        }
        return OCCppDefinitionsUtil.getBestLocationBasedOnExistingDefinitions((OCMembersContainer)parent).shouldInline;
    }

    @Nullable
    public static OCGenerateUtil.ReplacePosition getOutsidePreferredPosition(@NotNull PsiFile file2, @NotNull OCMembersContainer parent, @NotNull List<OCFunctionSymbol> functions) {
        OCFile sourceFile;
        if (functions.isEmpty() || !(file2 instanceof OCFile)) {
            return null;
        }
        BasedOnExistingResult basedOnExisting = OCCppDefinitionsUtil.getBestLocationBasedOnExistingDefinitions(parent);
        if (basedOnExisting.outsideLocation != null) {
            return OCCppDefinitionsUtil.getCorrectOutsideInsertPositionNearby((Integer)basedOnExisting.outsideLocation.second, (PsiFile)basedOnExisting.outsideLocation.first);
        }
        if (OCCppDefinitionsUtil.canDefinitionsBePlacedToAssocFile(parent) && !functions.stream().anyMatch(OCFunctionSymbol::isTemplateSymbol) && (sourceFile = ((OCFile)file2).getAssociatedFile()) != null && !sourceFile.isHeader()) {
            PsiElement insertionParent = OCCppDefinitionsUtil.findInsertionParentInFile(sourceFile, (OCNamespaceSymbol)ObjectUtils.tryCast((Object)parent, OCNamespaceSymbol.class));
            ASTNode child = insertionParent.getNode().findChildByType((IElementType)OCTokenTypes.RBRACE);
            PsiElement rBrace = child != null ? child.getPsi() : null;
            int desiredOffset = rBrace != null ? rBrace.getTextRange().getStartOffset() : insertionParent.getTextRange().getEndOffset();
            return OCCppDefinitionsUtil.getCorrectOutsideInsertPositionNearby(desiredOffset, sourceFile);
        }
        PsiElement fallbackLocation = OCCppDefinitionsUtil.defaultFallbackLocation(file2, OCCppDefinitionsUtil.getParentDefinition(parent), functions);
        return OCCppDefinitionsUtil.getCorrectOutsideInsertPositionNearby(fallbackLocation.getTextRange().getEndOffset(), fallbackLocation.getContainingFile());
    }

    @NotNull
    public static List<OCGenerateUtil.Replacement> getGenerateDefinitionReplacements(@NotNull OCCaretLocation location, @NotNull OCMembersContainer parent, @NotNull List<OCFunctionSymbol> functions, @NotNull List<? extends OCCallable> predefinitions, @NotNull InlinePolicy inlinePolicy) {
        if (inlinePolicy.shouldInline(location, parent)) {
            ArrayList<OCGenerateUtil.Replacement> replacements = new ArrayList<OCGenerateUtil.Replacement>(functions.size());
            assert (functions.size() == predefinitions.size());
            for (int i2 = 0; i2 < functions.size(); ++i2) {
                PsiElement semicolon;
                OCFunctionSymbol symbol = functions.get(i2);
                OCCallable predefinition = predefinitions.get(i2);
                if (predefinition == null) continue;
                PsiElement lastChild = predefinition.getLastChild();
                PsiElement psiElement = semicolon = !OCElementUtil.isElementSignificant(lastChild) ? OCElementUtil.getPrevSignificantSibling(lastChild) : lastChild;
                if (semicolon == null || OCElementUtil.getElementType(semicolon) != OCTokenTypes.SEMICOLON) continue;
                replacements.add(new OCGenerateUtil.Replacement(new OCGenerateUtil.ReplacePosition(predefinition.getContainingOCFile(), semicolon.getTextRange(), predefinition, false), OCCallableUtil.defaultFunctionBody(symbol, OCCallableUtil.getDefaultBaseToCall(symbol), predefinition)));
            }
            return replacements;
        }
        return OCCppDefinitionsUtil.getOutsideReplacements(location, parent, functions, null);
    }

    @NotNull
    public static List<OCGenerateUtil.Replacement> getNewFunctionsReplacements(@NotNull OCCaretLocation location, @NotNull OCStructLike structDefinition, @NotNull OCMembersContainer parent, @NotNull List<OCFunctionSymbol> symbols, @Nullable List<String> bodies, @NotNull InlinePolicy inlinePolicy) {
        if (symbols.isEmpty()) {
            return Collections.emptyList();
        }
        StringBuilder insideClassText = new StringBuilder();
        boolean shouldInline = inlinePolicy.shouldInline(location, parent);
        PsiElement contextToCalculateNames = OCCallableUtil.getCorrectContextToCalculateNames(structDefinition);
        int insertPositionInsideClass = OCCppDefinitionsUtil.getInsertPositionForFunctionsInsideClass(structDefinition, location, symbols.get(0));
        OCVisibility initialVisibility = OCVisibility.getVisibilityAtOffset(structDefinition, insertPositionInsideClass);
        assert (initialVisibility != null);
        OCVisibility curVisibility = initialVisibility;
        for (int i2 = 0; i2 < symbols.size(); ++i2) {
            OCFunctionSymbol functionSymbol = symbols.get(i2);
            OCVisibility visibility = functionSymbol.getVisibility();
            if (visibility != curVisibility) {
                insideClassText.append((Object)visibility).append(": ");
                curVisibility = visibility;
            }
            String afterSignature = shouldInline ? (bodies == null ? OCCallableUtil.defaultFunctionBody(functionSymbol, OCCallableUtil.getDefaultBaseToCall(functionSymbol), contextToCalculateNames) : bodies.get(i2)) : ";";
            insideClassText.append(OCCallableUtil.functionSignature(functionSymbol, "", OCCallableUtil.getCorrectContextToCalculateNames(structDefinition))).append(afterSignature);
        }
        if (OCCppDefinitionsUtil.shouldRestoreVisibility(structDefinition, insertPositionInsideClass, initialVisibility, curVisibility)) {
            insideClassText.append((Object)initialVisibility).append(": ");
        }
        PsiFile structDefinitionFile = structDefinition.getContainingFile();
        Document structDefinitionDocument = PsiDocumentManager.getInstance((Project)location.getProject()).getDocument(structDefinitionFile);
        if (structDefinitionDocument == null) {
            OCLog.LOG.warn("No document for " + structDefinitionFile);
            return Collections.emptyList();
        }
        List<OCGenerateUtil.Replacement> insideClassReplacements = Collections.singletonList(new OCGenerateUtil.Replacement(new OCGenerateUtil.ReplacePosition(structDefinitionFile, TextRange.from((int)insertPositionInsideClass, (int)0), contextToCalculateNames), insideClassText.toString()));
        List outsideClassReplacements = shouldInline ? Collections.emptyList() : OCCppDefinitionsUtil.getOutsideReplacements(location, parent, symbols, bodies);
        return ContainerUtil.concat(insideClassReplacements, outsideClassReplacements);
    }

    @Nullable
    public static PsiElement getParentDefinition(@NotNull OCMembersContainer parent) {
        return parent instanceof OCSymbol ? ((OCSymbol)((Object)parent)).locateDefinition() : parent.getContainingOCFile();
    }

    @NotNull
    private static List<OCGenerateUtil.Replacement> getOutsideReplacements(@NotNull OCCaretLocation location, @NotNull OCMembersContainer parent, @NotNull List<OCFunctionSymbol> functions, @Nullable List<String> bodies) {
        OCGenerateUtil.ReplacePosition position;
        OCGenerateUtil.ReplacePosition replacePosition = position = OCCppDefinitionsUtil.shouldGenerateOutsideDefinitionAtCaret(location, parent) ? OCCppDefinitionsUtil.getCorrectOutsideInsertPositionNearby(location) : OCCppDefinitionsUtil.getOutsidePreferredPosition(location.getFile(), parent, functions);
        if (position == null) {
            OCLog.LOG.warn("Can't find outside position for file '" + location.getFile() + "'");
            return Collections.emptyList();
        }
        StringBuilder text = new StringBuilder();
        for (int i2 = 0; i2 < functions.size(); ++i2) {
            OCFunctionSymbol function = functions.get(i2);
            text.append(OCCallableUtil.functionSignature(OCCallableUtil.removeDeclarationSpecifiers(function), OCCallableUtil.getFunctionParentQualifier(function, position.context), position.context)).append(bodies != null ? bodies.get(i2) : OCCallableUtil.defaultFunctionBody(function, OCCallableUtil.getDefaultBaseToCall(function), position.context));
        }
        return Collections.singletonList(new OCGenerateUtil.Replacement(position, text.toString()));
    }

    @NotNull
    private static BasedOnExistingResult getBestLocationBasedOnExistingDefinitions(@NotNull OCMembersContainer parent) {
        OCFile topLevelFile = parent instanceof OCSymbol ? null : parent.getContainingOCFile();
        class OffsetProcessor
        implements Processor {
            public boolean hasInlineDefinition = false;
            public boolean hasOutsideDefinition = false;
            public int maxOffset = 0;
            public PsiFile file = null;
            final /* synthetic */ OCFile val$topLevelFile;

            OffsetProcessor(OCFile oCFile) {
                this.val$topLevelFile = oCFile;
            }

            @Nullable
            Pair<PsiFile, Integer> location() {
                return this.file == null ? null : Pair.create((Object)this.file, (Object)this.maxOffset);
            }

            boolean shouldBeInlined(@NotNull OCMembersContainer parent) {
                return !this.hasOutsideDefinition && (this.hasInlineDefinition || !OCCppDefinitionsUtil.canDefinitionsBePlacedToAssocFile(parent));
            }

            public boolean process(Object o) {
                if (!(o instanceof OCSymbol)) {
                    return true;
                }
                OCSymbol symbol = (OCSymbol)o;
                if (symbol.isPredeclaration()) {
                    PsiFile definitionFile;
                    Object definition;
                    if (this.val$topLevelFile != null && symbol.getContainingOCFile() != this.val$topLevelFile) {
                        return true;
                    }
                    OCSymbol definitionSymbol = symbol.getDefinitionSymbol();
                    if (definitionSymbol != null && (definition = definitionSymbol.locateDefinition()) != null && (definitionFile = definition.getContainingFile()) != null) {
                        if (this.file == null && OCCodeInsightUtil.isValid((PsiElement)definitionFile)) {
                            this.file = definitionFile;
                            this.hasOutsideDefinition = true;
                        }
                        if (this.file != null && this.file.equals(definitionFile)) {
                            this.maxOffset = Math.max(this.maxOffset, definition.getTextRange().getEndOffset());
                        }
                    }
                } else if (symbol instanceof OCFunctionSymbol) {
                    this.hasInlineDefinition = true;
                }
                return true;
            }
        }
        OffsetProcessor processor2 = new OffsetProcessor(topLevelFile);
        parent.processMembers(null, processor2);
        return new BasedOnExistingResult(processor2.shouldBeInlined(parent), processor2.location());
    }

    private static boolean canDefinitionsBePlacedToAssocFile(@NotNull OCMembersContainer parent) {
        OCFile file2 = parent.getContainingOCFile();
        if (file2 == null || !file2.isHeader()) {
            return false;
        }
        OCFile assoc = file2.getAssociatedFile();
        if (assoc == null || assoc.isHeader()) {
            return false;
        }
        return !(parent instanceof OCTemplateSymbol) || !((OCTemplateSymbol)((Object)parent)).isTemplateSymbol();
    }

    @Nullable
    private static OCGenerateUtil.ReplacePosition getCorrectOutsideInsertPositionNearby(@NotNull OCCaretLocation location) {
        return location.getOffsetInFile() == null ? null : OCCppDefinitionsUtil.getCorrectOutsideInsertPositionNearby(location.getOffsetInFile(), location.getFile());
    }

    @Nullable
    private static OCGenerateUtil.ReplacePosition getCorrectOutsideInsertPositionNearby(int originalOffset, @NotNull PsiFile file2) {
        PsiElement atCaret;
        Document document = PsiDocumentManager.getInstance((Project)file2.getProject()).getDocument(file2);
        if (document == null) {
            OCLog.LOG.warn("No document for " + file2);
            return null;
        }
        PsiElement prev = null;
        for (PsiElement curr = atCaret = (PsiElement)ObjectUtils.notNull((Object)file2.findElementAt(originalOffset), (Object)file2); curr != null; curr = curr.getParent()) {
            if (curr instanceof OCCppNamespace || curr instanceof PsiFile) {
                int preferredOffset = -1;
                PsiElement context = null;
                if (curr instanceof OCCppNamespace && prev != null) {
                    boolean insideNamespaceHeader = false;
                    for (PsiElement nsChild = curr.getFirstChild(); nsChild != curr.getLastChild(); nsChild = nsChild.getNextSibling()) {
                        if (nsChild.equals(prev)) {
                            insideNamespaceHeader = true;
                        }
                        if (OCElementUtil.getElementType(nsChild) != OCTokenTypes.LBRACE) continue;
                        if (!insideNamespaceHeader) break;
                        preferredOffset = nsChild.getTextRange().getEndOffset();
                        context = curr;
                        break;
                    }
                }
                if (context == null) {
                    boolean isInsideComment = prev instanceof PsiComment && originalOffset > prev.getTextRange().getStartOffset();
                    preferredOffset = (prev == atCaret || prev == null) && !isInsideComment ? originalOffset : prev.getTextRange().getEndOffset();
                    context = curr;
                }
                return new OCGenerateUtil.ReplacePosition(file2, TextRange.from((int)preferredOffset, (int)0), OCCallableUtil.getCorrectContextToCalculateNames(context));
            }
            prev = curr;
        }
        return null;
    }

    @NotNull
    private static PsiElement defaultFallbackLocation(@NotNull PsiFile file2, @Nullable PsiElement parentDefinition, @NotNull List<OCFunctionSymbol> functions) {
        int maxOffset = -1;
        OCFunctionDeclaration result2 = null;
        for (OCFunctionSymbol symbol : functions) {
            OCFunctionDeclaration definition = symbol.locateFunctionDefinition();
            if (definition == null) continue;
            int offset = definition.getTextRange().getEndOffset();
            if (!file2.equals(definition.getContainingFile()) || offset <= maxOffset) continue;
            maxOffset = offset;
            result2 = definition;
        }
        if (result2 != null) {
            return result2;
        }
        if (parentDefinition != null && file2.equals(parentDefinition.getContainingFile())) {
            return parentDefinition;
        }
        return file2;
    }

    private static int getInsertPositionForFunctionsInsideClass(@NotNull OCStructLike structDefinition, @NotNull OCCaretLocation location, @NotNull OCFunctionSymbol newFunction) {
        int defaultOffset = OCNewCppFunctionsLocator.locateNewFunction(structDefinition, newFunction);
        if (location.getOffsetInFile() == null || !location.getFile().equals(structDefinition.getContainingFile())) {
            return defaultOffset;
        }
        int offset = location.getOffsetInFile();
        if (!OCNewCppFunctionsLocator.getValidLocationRange(structDefinition).contains(offset)) {
            return defaultOffset;
        }
        if (OCCppDefinitionsUtil.isLocationOutsideParent(location, structDefinition)) {
            return defaultOffset;
        }
        PsiElement elementToInsertAfter = null;
        boolean betweenVisibilityAndColon = false;
        for (PsiElement child = structDefinition.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (OCElementUtil.isVisibilityKeyword(child.getNode())) {
                betweenVisibilityAndColon = true;
            } else if (OCElementUtil.getElementType(child) == OCTokenTypes.COLON) {
                betweenVisibilityAndColon = false;
            }
            if (betweenVisibilityAndColon || child.getTextRange().getEndOffset() < offset) continue;
            elementToInsertAfter = child;
            break;
        }
        if (elementToInsertAfter instanceof PsiWhiteSpace && elementToInsertAfter.getTextRange().contains(offset)) {
            return offset;
        }
        if (elementToInsertAfter != null) {
            return elementToInsertAfter.getTextRange().getEndOffset();
        }
        return defaultOffset;
    }

    private static boolean shouldRestoreVisibility(@NotNull OCStructLike definition, int pos, @NotNull OCVisibility initial, @Nullable OCVisibility lastNew) {
        if (initial == lastNew) {
            return false;
        }
        for (PsiElement child = definition.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getTextRange().getStartOffset() < pos) continue;
            if (child instanceof OCDeclaration) {
                return true;
            }
            if (OCVisibility.getVisibilityFromElement(child) == null) continue;
            return false;
        }
        return false;
    }

    private static boolean isLocationOutsideParent(@NotNull OCCaretLocation location, @Nullable PsiElement parentDefinition) {
        assert (location.getElement() != null);
        return !PsiTreeUtil.isAncestor((PsiElement)parentDefinition, (PsiElement)location.getElement(), (boolean)false);
    }

    private static boolean shouldGenerateOutsideDefinitionAtCaret(@NotNull OCCaretLocation location, @NotNull OCMembersContainer parent) {
        if (location.getElement() == null) {
            return false;
        }
        if (!(parent instanceof OCSymbol)) {
            return !parent.getContainingOCFile().equals(location.getFile()) || !OCCppDefinitionsUtil.canDefinitionsBePlacedToAssocFile(parent);
        }
        return OCCppDefinitionsUtil.isLocationOutsideParent(location, OCCppDefinitionsUtil.getParentDefinition(parent));
    }

    @NotNull
    private static PsiElement findInsertionParentInFile(OCFile file2, OCNamespaceSymbol parent) {
        Object namespacePsi;
        ArrayList<OCNamespaceSymbol> parentsPath = new ArrayList<OCNamespaceSymbol>();
        while (parent != null) {
            if (!(parent instanceof OCStructSymbol)) {
                parentsPath.add(0, parent);
            }
            parent = (OCNamespaceSymbol)parent.getParent();
        }
        OCNamespaceLikeSymbol current = file2.getMembersContainer(false);
        for (OCNamespaceSymbol symbol : parentsPath) {
            final VirtualFile virtualFile = file2.getContainingFile().getVirtualFile();
            CommonProcessors.FindFirstProcessor<OCNamespaceSymbol> finder = new CommonProcessors.FindFirstProcessor<OCNamespaceSymbol>(){

                protected boolean accept(OCNamespaceSymbol symbol) {
                    return virtualFile != null && virtualFile.equals(symbol.getContainingFile());
                }
            };
            current.processMembers(symbol.getName(), new OCCommonProcessors.TypeFilteredProcessor((Processor<OCNamespaceSymbol>)finder, OCNamespaceSymbol.class));
            if (!finder.isFound()) break;
            current = (OCNamespaceLikeSymbol)finder.getFoundValue();
        }
        if (current instanceof OCNamespaceSymbol && (namespacePsi = ((OCNamespaceSymbol)current).locateDefinition()) != null) {
            return namespacePsi;
        }
        return file2;
    }

    private static class BasedOnExistingResult {
        public final boolean shouldInline;
        @Nullable
        public final Pair<PsiFile, Integer> outsideLocation;

        private BasedOnExistingResult(boolean inline, @Nullable Pair<PsiFile, Integer> location) {
            this.shouldInline = inline;
            this.outsideLocation = location;
            assert (this.outsideLocation == null || !this.shouldInline);
        }
    }

    public static enum InlinePolicy {
        INLINE{

            @Override
            public boolean shouldInline(@NotNull OCCaretLocation location, @NotNull OCMembersContainer parent) {
                return true;
            }
        }
        ,
        OUTSIDE{

            @Override
            public boolean shouldInline(@NotNull OCCaretLocation location, @NotNull OCMembersContainer parent) {
                return false;
            }
        }
        ,
        PREFERRED{

            @Override
            public boolean shouldInline(@NotNull OCCaretLocation location, @NotNull OCMembersContainer parent) {
                return OCCppDefinitionsUtil.shouldInlineNewDefinitions(parent, location);
            }
        };


        public abstract boolean shouldInline(@NotNull OCCaretLocation var1, @NotNull OCMembersContainer var2);

        public static InlinePolicy get(boolean inline) {
            return inline ? INLINE : OUTSIDE;
        }
    }

    public static enum SHOULD_GENERATE_DEFINITION {
        NO,
        POSSIBLE,
        REQUIRED;

    }
}

