/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.generate;

import com.intellij.psi.PsiElement;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.generate.actions.OCCppActionContext;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class OCGenerateComparisonOperatorsContext
extends OCCppActionContext<OCStructSymbol, OCDeclaratorSymbol> {
    @NotNull
    private List<String> myOperatorsToGenerate = Collections.emptyList();
    @NotNull
    private List<String> myExistingOperators = Collections.emptyList();

    public OCGenerateComparisonOperatorsContext(OCStructSymbol parent, PsiElement context) {
        super(parent, context);
    }

    @Override
    public boolean allFunctionsExist() {
        return this.myOperatorsToGenerate.size() == this.myExistingOperators.size();
    }

    @NotNull
    public List<String> getOperatorsToGenerate() {
        return this.myOperatorsToGenerate;
    }

    public void setOperatorsToGenerate(@NotNull List<String> operatorsToGenerate) {
        this.myOperatorsToGenerate = operatorsToGenerate;
    }

    @NotNull
    public Collection<String> getExistingOperators() {
        return this.myExistingOperators;
    }

    public void setExistingOperators(@NotNull List<String> existingOperators) {
        this.myExistingOperators = existingOperators;
    }

    @Override
    @NotNull
    public Collection<OCDeclaratorSymbol> getMemberCandidates() {
        ArrayList<OCDeclaratorSymbol> list = new ArrayList<OCDeclaratorSymbol>();
        ((OCStructSymbol)this.getParent()).processFields((Processor<OCDeclaratorSymbol>)((Processor)field -> {
            if (field.getKind() == OCSymbolKind.STRUCT_FIELD && !field.isFriendOrStatic() && !OCCodeInsightUtil.isUnnamed(field)) {
                list.add((OCDeclaratorSymbol)field);
            }
            return true;
        }));
        return list;
    }
}

