/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.generate.actions;

import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.generate.actions.OCActionContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceLikeSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.symtable.OCMembersContainer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCCppActionContext<P extends OCMembersContainer, M extends OCSymbolWithQualifiedName<?>>
extends OCActionContext<P, M> {
    @Nullable
    private Editor myEditor;
    @Nullable
    private PsiFile myEditorFile;
    private boolean myReplaceExisting = false;
    private Collection<OCFunctionSymbol> myExisting;

    public OCCppActionContext(P parent, PsiElement context) {
        super(parent, context);
    }

    @Override
    public Map<OCSymbol, OCSymbol> createParentsMap(Collection<M> candidates) {
        HashMap<OCSymbol, OCSymbol> map2 = new HashMap<OCSymbol, OCSymbol>();
        OCNamespaceSymbol parent = this.getParent() instanceof OCNamespaceLikeSymbol.FileSymbolsProvider ? OCNamespaceSymbol.createGlobalNamespaceSymbol(((OCNamespaceLikeSymbol.FileSymbolsProvider)this.getParent()).getFile()) : null;
        for (OCSymbolWithQualifiedName candidate : candidates) {
            if (candidate.getParent() != null) {
                while (candidate != null) {
                    map2.put(candidate, candidate.getParent());
                    candidate = candidate.getParent();
                }
                continue;
            }
            if (parent == null) continue;
            map2.put(candidate, parent);
        }
        return map2;
    }

    public boolean allFunctionsExist() {
        return true;
    }

    public void storeEditor(@Nullable Editor editor, @NotNull PsiFile editorFile) {
        this.myEditor = editor;
        this.myEditorFile = editorFile;
    }

    @Nullable
    public Editor getEditor() {
        return this.myEditor;
    }

    @Nullable
    public PsiFile getEditorFile() {
        return this.myEditorFile;
    }

    public boolean isReplaceExisting() {
        return this.myReplaceExisting;
    }

    public void setReplaceExisting(boolean replaceExisting) {
        this.myReplaceExisting = replaceExisting;
    }

    public void setExisting(Collection<OCFunctionSymbol> existing) {
        this.myExisting = existing;
    }

    public Collection<OCFunctionSymbol> getExisting() {
        return this.myExisting;
    }
}

