/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.generate.actions;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.generate.OCCaretLocation;
import com.jetbrains.cidr.lang.generate.OCCppDefinitionsUtil;
import com.jetbrains.cidr.lang.generate.OCGenerateUtil;
import com.jetbrains.cidr.lang.quickfixes.OCSymbolQuickFix;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCGenerateDefinitionQuickFix
extends OCSymbolQuickFix<OCFunctionSymbol> {
    private final boolean myInline;

    public OCGenerateDefinitionQuickFix(@Nullable OCFunctionSymbol symbol, boolean inline) {
        super(symbol);
        this.myInline = inline;
    }

    @Override
    protected boolean isAvailable(OCFunctionSymbol symbol) {
        return OCCppDefinitionsUtil.shouldGenerateDefinitionsFor(symbol, true) == OCCppDefinitionsUtil.SHOULD_GENERATE_DEFINITION.REQUIRED;
    }

    @Override
    protected String getTextInternal(OCFunctionSymbol symbol) {
        if (this.myInline) {
            return OCBundle.message("generate.definitions.quickfix.inlineText", symbol.getNameWithKindLowercase());
        }
        return OCBundle.message("generate.definitions.quickfix.outsideText", symbol.getNameWithKindLowercase());
    }

    @Override
    protected void invoke(@NotNull OCFunctionSymbol symbol) {
        if (this.isAvailable(symbol)) {
            PsiFile file2 = symbol.getContainingPsiFile();
            assert (file2 != null);
            List<OCGenerateUtil.Replacement> replacements = OCCppDefinitionsUtil.getGenerateDefinitionReplacements(OCCaretLocation.byFile(file2), OCCppDefinitionsUtil.getFunctionParent(symbol), Collections.singletonList(symbol), Collections.singletonList(symbol.locateFunctionDefinition()), OCCppDefinitionsUtil.InlinePolicy.get(this.myInline));
            if (FileModificationService.getInstance().preparePsiElementsForWrite(OCGenerateUtil.getAffectedFiles(replacements))) {
                OCGenerateUtil.applyReplacements(file2.getProject(), replacements, true);
            }
        }
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        return OCBundle.message("generate.definitions.intention.familyName", new Object[0]);
    }
}

