/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.generate.actions;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.generate.OCCaretLocation;
import com.jetbrains.cidr.lang.generate.OCCppDefinitionsUtil;
import com.jetbrains.cidr.lang.generate.OCGenerateUtil;
import com.jetbrains.cidr.lang.generate.actions.OCCppActionContext;
import com.jetbrains.cidr.lang.generate.actions.OCGenerateStreamOutputOperatorContext;
import com.jetbrains.cidr.lang.generate.handlers.OCCCppGenerateHandlerBase;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCIncludeDirective;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.psi.OCStructLike;
import com.jetbrains.cidr.lang.quickfixes.OCImportSymbolFix;
import com.jetbrains.cidr.lang.refactoring.OCNameSuggester;
import com.jetbrains.cidr.lang.resolve.OCResolveUtil;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCCallableUtil;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCFakeFunctionSymbolBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001B\u0005\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0004H\u0014J&\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\u0004H\u0014J.\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00042\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00030\u0018H\u0014J.\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00042\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00030\u0018H\u0014J\u0018\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\u0010\u0010\u001e\u001a\n \u001f*\u0004\u0018\u00010\t0\tH\u0014J\b\u0010 \u001a\u00020\tH\u0014J\b\u0010!\u001a\u00020\tH\u0014J\u0010\u0010\"\u001a\n \u001f*\u0004\u0018\u00010\t0\tH\u0014J\u0012\u0010#\u001a\u0004\u0018\u00010\u00072\u0006\u0010$\u001a\u00020%H\u0002J,\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00042\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00030'H\u0014J6\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00030'2\u0006\u0010\u0016\u001a\u00020\u00042\b\u0010+\u001a\u0004\u0018\u00010,2\u0006\u0010$\u001a\u00020%2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00030'H\u0014J\b\u0010.\u001a\u00020\u000bH\u0014R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/jetbrains/cidr/lang/generate/actions/OCGenerateStreamOutputOperatorHandler;", "Lcom/jetbrains/cidr/lang/generate/handlers/OCCCppGenerateHandlerBase;", "Lcom/jetbrains/cidr/lang/symbols/cpp/OCStructSymbol;", "Lcom/jetbrains/cidr/lang/symbols/cpp/OCDeclaratorSymbol;", "Lcom/jetbrains/cidr/lang/generate/actions/OCGenerateStreamOutputOperatorContext;", "()V", "myOStreamRefType", "Lcom/jetbrains/cidr/lang/types/OCType;", "ostreamInclude", "", "allowEmptySelection", "", "context", "checkExistingFunctions", "", "Lcom/jetbrains/cidr/lang/symbols/cpp/OCFunctionSymbol;", "project", "Lcom/intellij/openapi/project/Project;", "location", "Lcom/jetbrains/cidr/lang/generate/OCCaretLocation;", "doPerformAction", "", "actionContext", "chosenCandidates", "", "doWriteCommandAction", "evaluateActionContext", "parent", "element", "Lcom/intellij/psi/PsiElement;", "getActionTitle", "kotlin.jvm.PlatformType", "getAllDefinedText", "getExistingTabName", "getMembersChooserTitle", "getOStreamRefType", "file", "Lcom/intellij/psi/PsiFile;", "getReplacements", "", "Lcom/jetbrains/cidr/lang/generate/OCGenerateUtil$Replacement;", "fields", "getSelectedCandidates", "editor", "Lcom/intellij/openapi/editor/Editor;", "candidates", "shouldAutoFixImports", "cidr-lang"})
public class OCGenerateStreamOutputOperatorHandler
extends OCCCppGenerateHandlerBase<OCStructSymbol, OCDeclaratorSymbol, OCGenerateStreamOutputOperatorContext> {
    private final String ostreamInclude = ApplicationManager.getApplication().isUnitTestMode() ? "\"ostream.h\"" : "<ostream>";
    private OCType myOStreamRefType;

    private final OCType getOStreamRefType(PsiFile file2) {
        if (this.myOStreamRefType == null) {
            OCFunctionDeclaration oCFunctionDeclaration = (OCFunctionDeclaration)PsiTreeUtil.findChildOfType((PsiElement)OCElementFactory.codeFragment("#include " + this.ostreamInclude + "\n" + "std::ostream& __clion_dummy_foo();", file2.getProject(), (PsiElement)file2, false, false), OCFunctionDeclaration.class);
            this.myOStreamRefType = oCFunctionDeclaration != null ? oCFunctionDeclaration.getReturnType() : null;
        }
        return this.myOStreamRefType;
    }

    @Override
    @NotNull
    protected List<OCGenerateUtil.Replacement> getReplacements(@NotNull OCCaretLocation location, @NotNull OCGenerateStreamOutputOperatorContext actionContext, @NotNull List<? extends OCDeclaratorSymbol> fields) {
        Intrinsics.checkParameterIsNotNull((Object)location, (String)"location");
        Intrinsics.checkParameterIsNotNull((Object)actionContext, (String)"actionContext");
        Intrinsics.checkParameterIsNotNull(fields, (String)"fields");
        PsiFile psiFile = location.getFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"location.file");
        OCType streamRefType = this.getOStreamRefType(psiFile);
        if (streamRefType == null) {
            OCLog.LOG.warn("Unable to locate ostream");
            return CollectionsKt.emptyList();
        }
        OCCppReferenceType selfCref = OCCppReferenceType.to(((OCStructSymbol)actionContext.getParent()).getType().cloneWithConstModifier(location.getProject()));
        String string = (String)CollectionsKt.firstOrNull((Iterable)OCNameSuggester.suggestForType((OCType)((OCStructSymbol)actionContext.getParent()).getType(), (PsiElement)location.getFile(), CollectionsKt.emptyList()));
        if (string == null) {
            string = "rhs";
        }
        String varName = string;
        OCFakeFunctionSymbolBuilder builder = new OCFakeFunctionSymbolBuilder("operator<<").setReturnType(streamRefType).setContainer((OCSymbolWithQualifiedName)actionContext.getParent()).setVisibility(OCVisibility.PUBLIC).setIsFriend(true).setIsOperator(true).addParam(streamRefType, "os").addParam(selfCref, varName);
        Object element = ((OCStructSymbol)actionContext.getParent()).locateDefinition();
        if (element == null || !(element instanceof OCStruct)) {
            return CollectionsKt.emptyList();
        }
        StringBuilder exprBuilder = new StringBuilder();
        ((OCStructSymbol)actionContext.getParent()).processBaseClasses(new OCResolveContext((PsiElement)location.getFile()), new OCStructSymbol.BaseClassProcessor(exprBuilder, (PsiElement)element, varName){
            final /* synthetic */ StringBuilder $exprBuilder;
            final /* synthetic */ PsiElement $element;
            final /* synthetic */ String $varName;

            public final boolean process(OCSymbol<PsiElement> symbol, OCVisibility visibility) {
                CharSequence charSequence = this.$exprBuilder;
                if (charSequence.length() > 0) {
                    this.$exprBuilder.append(" << ' '");
                }
                String name = symbol.getType().getBestNameInContext(OCCallableUtil.getCorrectContextToCalculateNames(this.$element));
                this.$exprBuilder.append(" << ").append("static_cast<const " + name + " &>(" + this.$varName + ")");
                return true;
            }
            {
                this.$exprBuilder = stringBuilder;
                this.$element = psiElement;
                this.$varName = string;
            }
        });
        for (OCDeclaratorSymbol oCDeclaratorSymbol : fields) {
            CharSequence charSequence = exprBuilder;
            String spaceIfNotFirst = charSequence.length() == 0 ? "" : " ";
            exprBuilder.append(" << " + "\"" + spaceIfNotFirst + oCDeclaratorSymbol.getName() + ": " + "\"" + " << " + varName + "." + oCDeclaratorSymbol.getName());
        }
        CharSequence charSequence = exprBuilder;
        String string2 = !(charSequence.length() == 0) ? "os " + exprBuilder + ";" + "\n" : "";
        List<OCGenerateUtil.Replacement> list = OCCppDefinitionsUtil.getNewFunctionsReplacements(location, (OCStructLike)element, actionContext.getParent(), CollectionsKt.listOf((Object)builder.get(location.getProject())), CollectionsKt.listOf((Object)("{" + "\n" + string2 + "return os;" + "\n" + "}")), this.getInlinePolicy((OCCppActionContext)actionContext));
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"OCCppDefinitionsUtil.get\u2026inePolicy(actionContext))");
        return list;
    }

    @Override
    protected boolean allowEmptySelection(@NotNull OCGenerateStreamOutputOperatorContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected Collection<OCFunctionSymbol> checkExistingFunctions(@NotNull Project project2, @NotNull OCCaretLocation location, @NotNull OCGenerateStreamOutputOperatorContext context) {
        Collection<OCFunctionSymbol> collection;
        void $receiver$iv$iv;
        void $receiver$iv;
        ArrayList arrayList;
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)location, (String)"location");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Iterable iterable = OCResolveUtil.findExistingFunctions(project2, CollectionsKt.listOf((Object)"operator<<"), CollectionsKt.listOf((Object[])new OCStructType[]{null, ((OCStructSymbol)context.getParent()).getType()}), (OCSymbol)context.getParent(), new OCResolveContext(((OCStructSymbol)context.getParent()).getContainingOCFile()));
        ArrayList arrayList2 = arrayList;
        ArrayList arrayList3 = arrayList;
        void var5_7 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            Pair pair = (Pair)item$iv$iv;
            collection = destination$iv$iv;
            OCFunctionSymbol oCFunctionSymbol = (OCFunctionSymbol)it.second;
            collection.add(oCFunctionSymbol);
        }
        collection = (List)destination$iv$iv;
        arrayList2(collection);
        return arrayList3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void doPerformAction(@NotNull Project project2, @NotNull OCCaretLocation location, @NotNull OCGenerateStreamOutputOperatorContext actionContext, @NotNull List<OCDeclaratorSymbol> chosenCandidates) {
        boolean bl;
        OCGenerateStreamOutputOperatorContext oCGenerateStreamOutputOperatorContext;
        block2: {
            void $receiver$iv;
            Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)location, (String)"location");
            Intrinsics.checkParameterIsNotNull((Object)actionContext, (String)"actionContext");
            Intrinsics.checkParameterIsNotNull(chosenCandidates, (String)"chosenCandidates");
            Object element = ((OCStructSymbol)actionContext.getParent()).locateDefinition();
            if (element == null || !(element instanceof OCStruct)) {
                return;
            }
            actionContext.setDeclarationFile(((OCStruct)element).getContainingOCFile());
            Iterable iterable = PsiTreeUtil.findChildrenOfType((PsiElement)((OCStruct)element).getContainingOCFile(), OCIncludeDirective.class);
            oCGenerateStreamOutputOperatorContext = actionContext;
            for (Object element$iv : $receiver$iv) {
                OCIncludeDirective it = (OCIncludeDirective)element$iv;
                String text = it.getReferenceText();
                if (!(Intrinsics.areEqual((Object)text, (Object)"ostream") || Intrinsics.areEqual((Object)text, (Object)"iostream") || ApplicationManager.getApplication().isUnitTestMode() && Intrinsics.areEqual((Object)text, (Object)"ostream.h"))) continue;
                bl = true;
                break block2;
            }
            bl = false;
        }
        boolean bl2 = bl;
        oCGenerateStreamOutputOperatorContext.setHasRequiredIncludes(bl2);
        super.doPerformAction(project2, location, (OCCppActionContext)actionContext, chosenCandidates);
    }

    @Override
    @NotNull
    protected String getAllDefinedText() {
        String string = OCBundle.message("generate.stream.output.usages.all.defined", new Object[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"OCBundle.message(\"genera\u2026tput.usages.all.defined\")");
        return string;
    }

    @Override
    @NotNull
    protected String getExistingTabName() {
        String string = OCBundle.message("generate.stream.output.usages.existing.text", new Object[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"OCBundle.message(\"genera\u2026ut.usages.existing.text\")");
        return string;
    }

    @Override
    protected void doWriteCommandAction(@NotNull Project project2, @NotNull OCCaretLocation location, @NotNull OCGenerateStreamOutputOperatorContext actionContext, @NotNull List<OCDeclaratorSymbol> chosenCandidates) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)location, (String)"location");
        Intrinsics.checkParameterIsNotNull((Object)actionContext, (String)"actionContext");
        Intrinsics.checkParameterIsNotNull(chosenCandidates, (String)"chosenCandidates");
        super.doWriteCommandAction(project2, location, (OCCppActionContext)actionContext, chosenCandidates);
        OCFile f = actionContext.getDeclarationFile();
        if (f != null && !actionContext.getHasRequiredIncludes()) {
            PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
            OCImportSymbolFix.addImportToFile(f, "#include " + this.ostreamInclude, OCImportSymbolFix.ImportStyle.INCLUDE, f.getTextRange().getEndOffset());
        }
    }

    @Override
    protected boolean shouldAutoFixImports() {
        return false;
    }

    @Override
    @NotNull
    protected OCGenerateStreamOutputOperatorContext evaluateActionContext(@NotNull OCStructSymbol parent, @NotNull PsiElement element) {
        Intrinsics.checkParameterIsNotNull((Object)parent, (String)"parent");
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        return new OCGenerateStreamOutputOperatorContext(parent, element);
    }

    @Override
    protected String getActionTitle() {
        return OCBundle.message("generate.stream.output.action.title", new Object[0]);
    }

    @Override
    protected String getMembersChooserTitle() {
        return OCBundle.message("generate.stream.output.member.chooser.title", new Object[0]);
    }

    @Override
    @NotNull
    protected List<OCDeclaratorSymbol> getSelectedCandidates(@NotNull OCGenerateStreamOutputOperatorContext actionContext, @Nullable Editor editor, @NotNull PsiFile file2, @NotNull List<? extends OCDeclaratorSymbol> candidates) {
        Intrinsics.checkParameterIsNotNull((Object)actionContext, (String)"actionContext");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Intrinsics.checkParameterIsNotNull(candidates, (String)"candidates");
        return candidates;
    }
}

