/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.generate.handlers;

import com.jetbrains.cidr.lang.generate.OCCaretLocation;
import com.jetbrains.cidr.lang.generate.OCCppDefinitionsUtil;
import com.jetbrains.cidr.lang.generate.OCGenerateUtil;
import com.jetbrains.cidr.lang.generate.actions.OCGenerateGetterSetterContext;
import com.jetbrains.cidr.lang.generate.handlers.OCCCppGenerateHandlerBase;
import com.jetbrains.cidr.lang.psi.OCStructLike;
import com.jetbrains.cidr.lang.refactoring.OCNameSuggester;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.types.OCArrayType;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeUtils;
import com.jetbrains.cidr.lang.util.OCFakeFunctionSymbolBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class OCGenerateCppGetterSetterHandlerBase
extends OCCCppGenerateHandlerBase<OCStructSymbol, OCDeclaratorSymbol, OCGenerateGetterSetterContext> {
    @Override
    protected String getMembersChooserTitle() {
        return "Select Fields to " + this.getActionTitle();
    }

    @Override
    protected boolean allowUnions() {
        return true;
    }

    @Override
    @NotNull
    protected List<OCGenerateUtil.Replacement> getReplacements(@NotNull OCCaretLocation location, @NotNull OCGenerateGetterSetterContext actionContext, @NotNull List<OCDeclaratorSymbol> fields) {
        Object element = ((OCStructSymbol)actionContext.getParent()).locateDefinition();
        if (element == null || !(element instanceof OCStructLike)) {
            return Collections.emptyList();
        }
        OCStructLike structLike = (OCStructLike)element;
        ArrayList<OCFunctionSymbol> symbols = new ArrayList<OCFunctionSymbol>();
        ArrayList<String> bodies = new ArrayList<String>();
        for (OCDeclaratorSymbol field : fields) {
            String paramName = OCNameSuggester.getCppFieldNameWithoutPrefixAndSuffix(field);
            boolean disallowConst = field.getType() instanceof OCPointerType && (!(field.getType() instanceof OCArrayType) || field.isFriendOrStatic()) || field.getType() instanceof OCCppReferenceType;
            OCType paramType = OCTypeUtils.getExtractExpressionType(field.getType(), structLike, disallowConst);
            boolean isStatic = field.isStatic();
            if (actionContext.needGetter(field)) {
                symbols.add(new OCFakeFunctionSymbolBuilder(OCNameSuggester.getCppGetterName(field)).setReturnType(paramType).setVisibility(OCVisibility.PUBLIC).setContainer((OCSymbolWithQualifiedName)actionContext.getParent()).setIsStatic(isStatic).setIsConst(!isStatic).get(structLike.getProject()));
                bodies.add("{\n return " + field.getName() + ";\n}");
            }
            if (!actionContext.needSetter(field)) continue;
            symbols.add(new OCFakeFunctionSymbolBuilder(OCNameSuggester.getCppSetterName(field)).setVisibility(OCVisibility.PUBLIC).setContainer((OCSymbolWithQualifiedName)actionContext.getParent()).setIsStatic(isStatic).addParam(paramType, paramName).get(structLike.getProject()));
            StringBuilder body2 = new StringBuilder("{\n");
            if (paramName.equals(field.getName())) {
                body2.append(((OCStructSymbol)actionContext.getParent()).getName()).append("::");
            }
            body2.append(field.getName()).append(" = ").append(paramName).append(";\n}");
            bodies.add(body2.toString());
        }
        return OCCppDefinitionsUtil.getNewFunctionsReplacements(location, structLike, actionContext.getParent(), symbols, bodies, this.getInlinePolicy(actionContext));
    }
}

