/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.generate.handlers;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiElement;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.generate.OCCaretLocation;
import com.jetbrains.cidr.lang.generate.OCCppDefinitionsUtil;
import com.jetbrains.cidr.lang.generate.OCGenerateUtil;
import com.jetbrains.cidr.lang.generate.actions.OCCppActionContext;
import com.jetbrains.cidr.lang.generate.handlers.OCCCppGenerateHandlerBase;
import com.jetbrains.cidr.lang.psi.OCStructLike;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.util.OCFakeFunctionSymbolBuilder;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCGenerateDestructorHandler
extends OCCCppGenerateHandlerBase<OCStructSymbol, OCDeclaratorSymbol, OCCppActionContext<OCStructSymbol, OCDeclaratorSymbol>> {
    @Override
    protected String getActionTitle() {
        return "Generate Destructor";
    }

    @Override
    protected String getMembersChooserTitle() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected boolean enableChooseDialog(Collection<OCDeclaratorSymbol> candidates) {
        return false;
    }

    @Override
    protected boolean allowEmptySelection(OCCppActionContext<OCStructSymbol, OCDeclaratorSymbol> context) {
        return true;
    }

    @Override
    @Nullable
    protected OCCppActionContext<OCStructSymbol, OCDeclaratorSymbol> evaluateActionContext(OCStructSymbol parent, PsiElement element) {
        return new OCCppActionContext<OCStructSymbol, OCDeclaratorSymbol>(parent, element){

            @Override
            @NotNull
            public Collection<OCDeclaratorSymbol> getMemberCandidates() {
                return Collections.emptyList();
            }
        };
    }

    @Override
    protected boolean allowUnions() {
        return true;
    }

    @Override
    @NotNull
    protected List<OCGenerateUtil.Replacement> getReplacements(@NotNull OCCaretLocation location, @NotNull OCCppActionContext<OCStructSymbol, OCDeclaratorSymbol> actionContext, @NotNull List<OCDeclaratorSymbol> fields) {
        OCStructSymbol parent = (OCStructSymbol)actionContext.getParent();
        if (!parent.processMembers("~" + parent.getName(), (Processor<OCSymbol>)new CommonProcessors.FindFirstProcessor())) {
            int code2;
            String message2 = "Destructor is already defined.\nDo you wish to continue?";
            int n = code2 = ApplicationManager.getApplication().isUnitTestMode() ? 1 : Messages.showYesNoDialog((String)message2, (String)this.getActionTitle(), (Icon)Messages.getQuestionIcon());
            if (code2 != 0) {
                return Collections.emptyList();
            }
        }
        OCLog.LOG.assertTrue(fields.isEmpty());
        Object element = parent.locateDefinition();
        if (element == null || !(element instanceof OCStructLike)) {
            return Collections.emptyList();
        }
        OCStructLike structDefinition = (OCStructLike)element;
        OCFunctionSymbol symbol = new OCFakeFunctionSymbolBuilder("~" + parent.getName()).setIsVirtual(parent.getKind() == OCSymbolKind.STRUCT).setIsCtorOrDtor(true).setVisibility(OCVisibility.PUBLIC).setContainer(parent).get(location.getProject());
        return OCCppDefinitionsUtil.getNewFunctionsReplacements(location, structDefinition, actionContext.getParent(), Collections.singletonList(symbol), null, this.getInlinePolicy(actionContext));
    }
}

