/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.generate.handlers;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.generate.actions.OCGenerateMethodActionContext;
import com.jetbrains.cidr.lang.generate.handlers.OCGenerateMethodHandler;
import com.jetbrains.cidr.lang.psi.OCInterface;
import com.jetbrains.cidr.lang.refactoring.OCNameSuggester;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCImplementationSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCRealType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCCallableUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCGenerateIsEqualAndHashHandler
extends OCGenerateMethodHandler {
    @Override
    protected String getActionTitle() {
        return "Generate -isEqual: and -hash";
    }

    @Override
    protected String[] getMethodNames() {
        return new String[]{"isEqual:", "hash"};
    }

    @Override
    protected boolean allowEmptySelection(OCGenerateMethodActionContext context) {
        return true;
    }

    @Override
    protected boolean isExistingMethod(String selector2) {
        return super.isExistingMethod(selector2) || selector2.startsWith("isEqualTo");
    }

    @Override
    @NotNull
    protected String getInsertText(@NotNull PsiElement element, @Nullable PsiElement at, @NotNull List<OCInstanceVariableSymbol> ivars, @NotNull OCGenerateMethodActionContext context) {
        StringBuilder builder = new StringBuilder();
        OCMethodSymbol isEqualMethod = context.getBaseMethods().get(0);
        OCMethodSymbol hashMethod = context.getBaseMethods().get(1);
        OCObjectType superType = context.getType().getSuperType();
        HashSet<String> superMethodNames = new HashSet<String>();
        if (superType != null) {
            superType.processMembers(OCMethodSymbol.class, symbol -> {
                String name = symbol.getName();
                if (name.endsWith(":")) {
                    superMethodNames.add(name.substring(0, name.length() - 1));
                }
                return true;
            });
        }
        Collection<String> suggestions = OCNameSuggester.suggestForType((OCType)context.getType(), null, "");
        String customMethodName = "isEqualTo" + StringUtil.capitalize((String)(suggestions.isEmpty() ? "other" : suggestions.iterator().next()));
        customMethodName = OCNameSuggester.suggestUniqueName(null, customMethodName, null, superMethodNames);
        suggestions = OCNameSuggester.suggestForType(OCSymbolKind.PARAMETER, context.getType(), element.getLastChild(), "");
        String paramName = suggestions.isEmpty() ? "other" : suggestions.iterator().next();
        String customSignature = "-(BOOL)" + customMethodName + ":(" + context.getInterfaceSymbol().getName() + "*)" + paramName;
        if (element instanceof OCInterface) {
            builder.append(OCCallableUtil.methodSignature(isEqualMethod, element)).append(";");
            builder.append(customSignature).append(";");
            builder.append(OCCallableUtil.methodSignature(hashMethod, element)).append(";");
        } else {
            String isEqualBody = OCGenerateIsEqualAndHashHandler.getIsEqualBody(ivars, paramName, element, context);
            builder.append(OCCallableUtil.methodText(isEqualMethod, customMethodName, element));
            builder.append(OCCallableUtil.methodText(customSignature, isEqualBody, element));
            builder.append(OCGenerateIsEqualAndHashHandler.getHashMethod(ivars, element, context));
        }
        return builder.toString();
    }

    private static String getIsEqualBody(List<OCInstanceVariableSymbol> ivars, String paramName, PsiElement context, OCGenerateMethodActionContext actionContext) {
        OCImplementationSymbol classSymbol;
        StringBuilder body2 = new StringBuilder();
        body2.append("if (self == ").append(paramName).append(")\nreturn YES;\n");
        body2.append("if (").append(paramName).append(" == nil)\nreturn NO;\n");
        OCObjectType superType = actionContext.getType().getSuperType();
        OCImplementationSymbol oCImplementationSymbol = classSymbol = superType != null ? superType.getImplementation() : null;
        if (classSymbol != null && !classSymbol.processMembersInAllCategories("isEqual:", OCMethodSymbol.class, new CommonProcessors.FindFirstProcessor(), true)) {
            body2.append("if (![super isEqual: ").append(paramName).append("])\nreturn NO;\n");
        }
        for (OCInstanceVariableSymbol ivar : ivars) {
            OCPropertySymbol property = ivar.getAssociatedProperty();
            OCType type2 = ivar.getType().resolve(context.getContainingFile(), true);
            if (property != null) {
                OCGenerateIsEqualAndHashHandler.appendIsEqualMember(body2, context, "self." + property.getName(), paramName + "." + property.getName(), type2);
                continue;
            }
            OCGenerateIsEqualAndHashHandler.appendIsEqualMember(body2, context, ivar.getName(), paramName + "->" + ivar.getName(), type2);
        }
        body2.append("return YES;");
        return body2.toString();
    }

    private static void appendIsEqualMember(StringBuilder builder, final PsiElement context, String selfName, String otherName, final OCType type2) {
        if (OCGenerateIsEqualAndHashHandler.processStructFields(type2, (Processor<OCDeclaratorSymbol>)((Processor)field -> {
            OCGenerateIsEqualAndHashHandler.appendIsEqualMember(builder, context, selfName + "." + field.getName(), otherName + "." + field.getName(), field.getResolvedType());
            return true;
        }))) {
            return;
        }
        builder.append("if (").append(selfName).append("!=").append(otherName);
        if (type2.isPointerToObject()) {
            OCObjectType objType = (OCObjectType)type2.getTerminalType();
            CommonProcessors.FindFirstProcessor<OCMethodSymbol> finder = new CommonProcessors.FindFirstProcessor<OCMethodSymbol>(){

                protected boolean accept(OCMethodSymbol symbol) {
                    String prefix = "isEqualTo";
                    if (symbol.getName().startsWith(prefix) && symbol.getName().length() > prefix.length() + 2 && symbol.getSelectors().size() == 1) {
                        OCDeclaratorSymbol param = symbol.getSelectors().get(0).getParameter();
                        return param != null && param.getType().resolve(context.getContainingFile()).isCompatible(type2, context);
                    }
                    return false;
                }
            };
            objType.processMembers((String)null, OCMethodSymbol.class, finder);
            OCMethodSymbol customMethod = (OCMethodSymbol)finder.getFoundValue();
            OCDeclaratorSymbol parameter = customMethod != null ? customMethod.getSelectors().get(0).getParameter() : null;
            String methodName = parameter != null && parameter.getResolvedType().isCompatible(type2, (PsiElement)context.getContainingFile()) ? customMethod.getName() : "isEqual:";
            builder.append("&&![").append(selfName).append(" ").append(methodName).append(otherName).append("]");
        }
        builder.append(")\nreturn NO;\n");
    }

    private static String getHashMethod(List<OCInstanceVariableSymbol> ivars, PsiElement context, OCGenerateMethodActionContext actionContext) {
        OCImplementationSymbol classSymbol;
        ArrayList<String> strings = new ArrayList<String>();
        OCObjectType superType = actionContext.getType().getSuperType();
        OCImplementationSymbol oCImplementationSymbol = classSymbol = superType != null ? superType.getImplementation() : null;
        if (classSymbol != null && !classSymbol.processMembersInAllCategories("hash", OCMethodSymbol.class, new CommonProcessors.FindFirstProcessor(), true)) {
            strings.add("[super hash];\n");
        }
        for (OCInstanceVariableSymbol ivar : ivars) {
            OCPropertySymbol property = ivar.getAssociatedProperty();
            OCType type2 = ivar.getType().resolve(context.getContainingFile(), true);
            OCGenerateIsEqualAndHashHandler.appendHashMember(strings, property != null ? "self." + property.getName() : ivar.getName(), type2, context);
        }
        StringBuilder function = new StringBuilder();
        function.append(OCCallableUtil.methodSignature(actionContext.getBaseMethods().get(1), context)).append("{\n");
        if (strings.size() > 1) {
            boolean isFirst = true;
            for (String string : strings) {
                if (isFirst) {
                    function.append("NSUInteger hash = ");
                } else {
                    function.append("hash = hash * 31u + ");
                }
                function.append(string);
                isFirst = false;
            }
            function.append("return hash;\n}\n");
        } else if (strings.size() == 1) {
            function.append("return ").append((String)strings.get(0)).append("}\n");
        } else {
            function.append("return [super hash];}\n");
        }
        return function.toString();
    }

    private static void appendHashMember(List<String> strings, String memberName, OCType type2, PsiElement context) {
        if (type2.isPointerToObject()) {
            strings.add("[" + memberName + " hash];\n");
        } else if (type2 == OCRealType.FLOAT) {
            strings.add("[[NSNumber numberWithFloat:" + memberName + "] hash];\n");
        } else if (type2 instanceof OCRealType) {
            strings.add("[[NSNumber numberWithDouble:" + memberName + "] hash];\n");
        } else if (type2 instanceof OCIntType) {
            boolean convertToNSUInteger = strings.isEmpty() && (((OCIntType)type2).isSigned() || ((OCIntType)type2).getRank(context) > OCIntType.UINT.getRank(context));
            strings.add((convertToNSUInteger ? "(NSUInteger)" : "") + memberName + ";\n");
        } else if (type2 instanceof OCStructType && !type2.isScalar()) {
            if (!OCGenerateIsEqualAndHashHandler.processStructFields(type2, (Processor<OCDeclaratorSymbol>)((Processor)field -> {
                OCGenerateIsEqualAndHashHandler.appendHashMember(strings, memberName + "." + field.getName(), field.getResolvedType(), context);
                return true;
            }))) {
                strings.add("(NSUInteger)" + memberName + ";\n");
            }
        } else {
            strings.add("(NSUInteger)" + memberName + ";\n");
        }
    }
}

