/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.generate.handlers;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.generate.actions.OCGenerateMethodActionContext;
import com.jetbrains.cidr.lang.generate.handlers.OCObjCClassTextActionHandlerBase;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCClassDeclarationBase;
import com.jetbrains.cidr.lang.psi.OCImplementation;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.quickfixes.OCImportSymbolFix;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.refactoring.util.OCElementsMover;
import com.jetbrains.cidr.lang.settings.OCBooleanOption;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.settings.OCOption;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolOffsetUtil;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCProtocolSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.OCGlobalProjectSymbolsCache;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCCommonProcessors;
import com.jetbrains.cidr.lang.util.OCDeclarationKind;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCGenerateMethodHandler
extends OCObjCClassTextActionHandlerBase<OCInstanceVariableSymbol, OCGenerateMethodActionContext> {
    private static final OCBooleanOption DECLARE_IN_INTERFACE = new OCBooleanOption("Declare in interface");

    @Override
    protected void loadOptions(PsiFile file2, Editor editor, @NotNull OCGenerateMethodActionContext actionContext, @Nullable OCCodeStyleSettings settings, @NotNull List<Pair<OCOption, Object>> options) {
        options.add((Pair<OCOption, Object>)new Pair((Object)DECLARE_IN_INTERFACE, (Object)(settings == null || settings.DECLARE_GENERATED_METHODS ? 1 : 0)));
        super.loadOptions(file2, editor, actionContext, settings, options);
    }

    @Override
    protected void saveOptions(PsiFile file2, @NotNull OCCodeStyleSettings settings, Map<OCOption, Object> optionValues) {
        settings.DECLARE_GENERATED_METHODS = OCGenerateMethodHandler.getOption(optionValues, DECLARE_IN_INTERFACE);
        super.saveOptions(file2, settings, optionValues);
    }

    @Override
    protected String getMembersChooserTitle() {
        return "Select Members";
    }

    @Override
    @Nullable
    protected OCGenerateMethodActionContext evaluateActionContext(OCClassSymbol parent, PsiElement element) {
        if (!(parent.locateDefinition() instanceof OCClassDeclaration)) {
            return null;
        }
        OCObjectType type2 = parent.getResolvedType(true);
        return new OCGenerateMethodActionContext(parent, ContainerUtil.map((Object[])this.getMethodNames(), methodName -> this.searchForMethod((String)methodName, type2, parent.getProject())), type2, element){

            @Override
            public List<OCClassSymbol> getSymbolsToModify() {
                if (OCGenerateMethodHandler.this.getOption(this, DECLARE_IN_INTERFACE).booleanValue()) {
                    return Arrays.asList(this.myInterfaceSymbol, this.myImplementationSymbol);
                }
                return Collections.singletonList(this.myImplementationSymbol);
            }

            @Override
            protected boolean showSymbol(OCInstanceVariableSymbol symbol) {
                return OCGenerateMethodHandler.this.showSymbolInChooser(symbol, this);
            }
        };
    }

    @Override
    @NotNull
    protected Collection<OCInstanceVariableSymbol> getSelectedCandidates(@NotNull OCGenerateMethodActionContext actionContext, @Nullable Editor editor, @NotNull PsiFile file2, @NotNull List<OCInstanceVariableSymbol> candidates) {
        return candidates;
    }

    protected boolean showSymbolInChooser(OCInstanceVariableSymbol symbol, OCGenerateMethodActionContext actionContext) {
        return true;
    }

    @Nullable
    protected String getParentProtocol() {
        return null;
    }

    private OCMethodSymbol searchForMethod(String methodName, OCObjectType type2, Project project2) {
        CommonProcessors.FindFirstProcessor<OCMethodSymbol> finder = new CommonProcessors.FindFirstProcessor<OCMethodSymbol>(){

            protected boolean accept(OCMethodSymbol symbol) {
                return !symbol.isStatic();
            }
        };
        if (this.getParentProtocol() != null) {
            CommonProcessors.FindFirstProcessor protocolFinder = new CommonProcessors.FindFirstProcessor();
            OCCommonProcessors.TypeFilteredProcessor processor2 = new OCCommonProcessors.TypeFilteredProcessor((Processor<OCProtocolSymbol>)protocolFinder, OCProtocolSymbol.class);
            OCGlobalProjectSymbolsCache.processTopLevelSymbols(project2, processor2, this.getParentProtocol());
            OCProtocolSymbol protocol = (OCProtocolSymbol)protocolFinder.getFoundValue();
            if (protocol != null) {
                protocol.processMembers(methodName, OCMethodSymbol.class, finder);
            }
        } else if (type2 != null) {
            type2.processMembers(methodName, OCMethodSymbol.class, finder);
        }
        return (OCMethodSymbol)finder.getFoundValue();
    }

    protected abstract String[] getMethodNames();

    @Override
    protected boolean checkContext(@NotNull Project project2, @Nullable Editor editor, @Nullable OCGenerateMethodActionContext context) {
        Object existingMethod;
        if (!super.checkContext(project2, editor, context)) {
            return false;
        }
        OCMethodSymbol existingSymbol = this.findExistingMethod(context);
        context.setDeleteExisting(true);
        Object v0 = existingMethod = existingSymbol != null ? existingSymbol.locateDefinition() : null;
        if (existingMethod != null) {
            int code2;
            String message2 = existingSymbol.getNameWithKindUppercase() + " is already defined.\nDo you wish to replace the existing method?";
            int n = code2 = ApplicationManager.getApplication().isUnitTestMode() ? 0 : Messages.showYesNoCancelDialog((String)message2, (String)this.getActionTitle(), (Icon)Messages.getQuestionIcon());
            if (code2 == 0) {
                return true;
            }
            if (code2 == 1) {
                context.setDeleteExisting(false);
                return true;
            }
            return false;
        }
        return true;
    }

    protected OCMethodSymbol findExistingMethod(OCGenerateMethodActionContext context) {
        CommonProcessors.FindFirstProcessor finder = new CommonProcessors.FindFirstProcessor();
        for (String methodName : this.getMethodNames()) {
            if (!context.getImplementationSymbol().processMembersInAllCategories(methodName, OCMethodSymbol.class, finder, true)) break;
        }
        return (OCMethodSymbol)finder.getFoundValue();
    }

    protected boolean isExistingMethod(String selector2) {
        for (String methodName : this.getMethodNames()) {
            if (!selector2.equals(methodName)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void performAction(@NotNull Project project2, @NotNull PsiElement element, int caretPos, @Nullable PsiElement at, @NotNull List<OCInstanceVariableSymbol> members, @NotNull OCGenerateMethodActionContext context) {
        if (this.getParentProtocol() != null && element instanceof OCImplementation) {
            OCClassDeclarationBase anInterface = (OCClassDeclarationBase)context.getInterfaceSymbol().locateDefinition();
            OCProtocolSymbol protocol = (OCProtocolSymbol)context.getBaseMethod().getParent();
            if (anInterface instanceof OCClassDeclaration && !context.getType().implementsProtocol(protocol)) {
                new OCElementsMover().addBaseProtocol((OCClassDeclaration)anInterface, protocol.getName());
            }
        }
        if (context.isDeleteExisting()) {
            for (OCMethod method2 : ((OCClassDeclaration)element).getMethods()) {
                if (!this.isExistingMethod(method2.getSelector())) continue;
                OCChangeUtil.delete(method2);
            }
        }
        if (element instanceof OCImplementation) {
            for (OCInstanceVariableSymbol member : members) {
                if (((OCClassSymbol)member.getParent()).isSameCategory(context.getInterfaceSymbol())) continue;
                new OCImportSymbolFix(element, (OCSymbol)member.getParent(), false).fixFirstItem(project2, element.getContainingFile());
            }
        }
        super.performAction(project2, element, caretPos, at, members, context);
    }

    @Override
    protected int getInsertPosition(PsiElement element, int caretOffset, PsiElement at, List<OCInstanceVariableSymbol> members, OCGenerateMethodActionContext actionContext) {
        if (at == null || caretOffset < ((OCClassDeclaration)element).getMethodsStartOffset(true)) {
            return OCDeclarationKind.InstanceMethod.getChildrenEndOffset(element);
        }
        return ((OCClassDeclaration)element).getMethodsInsertPosition(true, at, caretOffset);
    }

    protected static boolean processStructFields(OCType type2, Processor<OCDeclaratorSymbol> processor2) {
        OCStructSymbol structSymbol;
        if (type2 instanceof OCStructType && !type2.isScalar() && (structSymbol = ((OCStructType)type2).getSymbol()).isPOD()) {
            CommonProcessors.CollectProcessor collector = new CommonProcessors.CollectProcessor();
            structSymbol.processFields((Processor<OCDeclaratorSymbol>)collector);
            ArrayList fields = new ArrayList(collector.getResults());
            Collections.sort(fields, (o1, o2) -> OCSymbolOffsetUtil.compare(o1.getComplexOffset(), o2.getComplexOffset()));
            for (OCDeclaratorSymbol field : fields) {
                processor2.process((Object)field);
            }
            return true;
        }
        return false;
    }
}

