/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.generate.handlers;

import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.CommonProcessors;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.generate.OCMemberChooser;
import com.jetbrains.cidr.lang.generate.OCMemberChooserObject;
import com.jetbrains.cidr.lang.generate.actions.OCGenerateFromIvarsActionContext;
import com.jetbrains.cidr.lang.generate.handlers.OCClassActionHandlerBase;
import com.jetbrains.cidr.lang.inspections.OCNotReleasedIvarInspection;
import com.jetbrains.cidr.lang.intentions.OCMoveToPrivateCategoryIntentionAction;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCProperty;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.psi.OCSynthesizePropertiesList;
import com.jetbrains.cidr.lang.quickfixes.OCReleaseVariablesIntentionAction;
import com.jetbrains.cidr.lang.refactoring.OCConvertMemberRefactoringProcessor;
import com.jetbrains.cidr.lang.refactoring.OCNameSuggester;
import com.jetbrains.cidr.lang.settings.OCBooleanOption;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.settings.OCOption;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCSynthesizeSymbol;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCGeneratePropertiesHandler
extends OCClassActionHandlerBase<OCClassSymbol, OCInstanceVariableSymbol, OCGenerateFromIvarsActionContext> {
    private static final OCBooleanOption SHOW_SYNTHESIZED = new OCBooleanOption("Show ivars with synthesized properties");
    private static final OCBooleanOption CONVERT_USAGES = new OCBooleanOption(UIUtil.removeMnemonic((String)OCBundle.message("refactoring.convertIvarUsagesToProperties", new Object[0])));

    @Override
    protected String getMembersChooserTitle() {
        return "Select Instance Variables to make Properties";
    }

    @Override
    protected String getActionTitle() {
        return "Generate Properties from Instance Variables";
    }

    @Override
    protected String getNoMembersMessage(@NotNull OCGenerateFromIvarsActionContext context) {
        return context.getParentNameUppercase() + " has no instance variables to generate properties from";
    }

    @Override
    protected Class<? extends OCSymbolDeclarator> getParentClass() {
        return OCClassDeclaration.class;
    }

    @Override
    protected void loadOptions(PsiFile file2, Editor editor, @NotNull OCGenerateFromIvarsActionContext actionContext, @Nullable OCCodeStyleSettings settings, @NotNull List<Pair<OCOption, Object>> options) {
        options.add((Pair<OCOption, Object>)new Pair((Object)SHOW_SYNTHESIZED, (Object)true));
        if (OCCompilerHelper.supportsAutosynthesis(file2)) {
            options.add((Pair<OCOption, Object>)new Pair((Object)CONVERT_USAGES, (Object)true));
        }
        super.loadOptions(file2, editor, actionContext, settings, options);
    }

    @Override
    @NotNull
    protected OCGenerateFromIvarsActionContext evaluateActionContext(OCClassSymbol parent, PsiElement element) {
        return new OCGenerateFromIvarsActionContext(parent, parent.getResolvedType(true), element);
    }

    @Override
    @NotNull
    protected Condition<OCInstanceVariableSymbol> getCandidatesFilter(@NotNull OCGenerateFromIvarsActionContext actionContext) {
        return symbol -> symbol.getGeneratedFromProperty() == null;
    }

    @Override
    protected void performAction(@NotNull Project project2, @Nullable Editor editor, @NotNull PsiFile file2, @NotNull OCGenerateFromIvarsActionContext context, @NotNull List<OCInstanceVariableSymbol> ivars) {
        this.performAction(file2, context, ivars, null, null, false, this.convertUsages(context), false);
    }

    protected boolean convertUsages(OCGenerateFromIvarsActionContext context) {
        Boolean value2 = this.getOption(context, CONVERT_USAGES);
        return value2 != null ? value2 : true;
    }

    protected void performAction(PsiFile file2, OCGenerateFromIvarsActionContext context, List<OCInstanceVariableSymbol> ivars, @Nullable String customName, @Nullable OCPropertySymbol.PropertySemantics customSemantics, boolean isReadonly, boolean convertUsages, final boolean putToPrivateCategory) {
        FeatureUsageTracker.getInstance().triggerFeatureUsed("codeassists.altInsert");
        OCInterfaceSymbol interfaceSymbol = (OCInterfaceSymbol)context.getInterfaceSymbol();
        HashMap newNames = new HashMap();
        HashMap newDeclarations = new HashMap();
        HashMap existingDeclarations = new HashMap();
        ArrayList synthesizes = new ArrayList();
        boolean replaceAllIvars = this.replaceAllIvars();
        PsiFile psiContext = context.getContext().isValid() ? context.getContext() : file2;
        ArrayList nonReleasedIvars = new ArrayList();
        OCNotReleasedIvarInspection.IvarsInfo ivarsInfo = OCNotReleasedIvarInspection.startInspection(file2);
        ApplicationManager.getApplication().runWriteAction(() -> OCGeneratePropertiesHandler.lambda$performAction$1(ivars, customName, newNames, convertUsages, interfaceSymbol, customSemantics, file2, (PsiElement)psiContext, isReadonly, newDeclarations, existingDeclarations, replaceAllIvars, synthesizes, ivarsInfo, nonReleasedIvars));
        OCReleaseVariablesIntentionAction releaseAction = OCCompilerHelper.isArcDisabled(file2) && !nonReleasedIvars.isEmpty() ? new OCReleaseVariablesIntentionAction(nonReleasedIvars) : null;
        OCConvertMemberRefactoringProcessor<OCInstanceVariableSymbol> processor2 = new OCConvertMemberRefactoringProcessor<OCInstanceVariableSymbol>((OCClassSymbol)interfaceSymbol, ivars, newNames, newDeclarations, existingDeclarations, replaceAllIvars ? null : synthesizes, releaseAction, (OCElementType)OCTokenTypes.DOT, this.getActionTitle(), convertUsages){

            @Override
            protected boolean showConflicts(@NotNull MultiMap<PsiElement, String> conflicts, @Nullable UsageInfo[] usages) {
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    OCGeneratePropertiesHandler.this.passConflictsToTest(new ArrayList<String>(conflicts.values()));
                    this.prepareSuccessful();
                    return true;
                }
                return super.showConflicts(conflicts, usages);
            }

            @Override
            protected void performRefactoring(@NotNull UsageInfo[] usages) {
                OCMoveToPrivateCategoryIntentionAction action;
                PsiElement newDeclaration;
                super.performRefactoring(usages);
                PsiElement psiElement = newDeclaration = this.myNewDeclarations.isEmpty() ? null : (PsiElement)this.myNewDeclarations.values().iterator().next();
                if (putToPrivateCategory && newDeclaration instanceof OCProperty && (action = new OCMoveToPrivateCategoryIntentionAction(){

                    @Override
                    protected OCMemberSymbol locateCandidate(@NotNull Project project2, Editor editor, PsiFile file2) {
                        return (OCMemberSymbol)((OCProperty)newDeclaration).getDeclaration().getDeclarators().get(0).getSymbol();
                    }
                }).isAvailable(this.myProject, null, newDeclaration.getContainingFile())) {
                    action.invoke(this.myProject, null, newDeclaration.getContainingFile());
                }
            }
        };
        processor2.run();
    }

    protected void passConflictsToTest(List<String> conflicts) {
    }

    protected boolean replaceAllIvars() {
        return false;
    }

    @Override
    protected OCMemberChooserObject[] getChooserNodes(OCMemberChooser chooser, Collection<OCInstanceVariableSymbol> candidates, OCGenerateFromIvarsActionContext actionContext, int moreNodesLevel) {
        if (OCGeneratePropertiesHandler.getOption(chooser.getOptionSelections(), SHOW_SYNTHESIZED).booleanValue()) {
            return super.getChooserNodes(chooser, candidates, actionContext, moreNodesLevel);
        }
        HashSet synthesizedIvars = new HashSet();
        actionContext.getType().processMembers(OCSynthesizeSymbol.class, symbol -> {
            if (symbol.isSynthesize()) {
                synthesizedIvars.add(symbol.getIvarName());
            }
            return true;
        });
        if (OCCompilerHelper.supportsAutosynthesis(actionContext.getContext().getContainingFile())) {
            actionContext.getInterfaceSymbol().processMembersInAllCategories(null, OCPropertySymbol.class, propertySymbol -> {
                OCInstanceVariableSymbol ivar = propertySymbol.getAssociatedIvar();
                if (ivar != null) {
                    synthesizedIvars.add(ivar.getName());
                }
                return true;
            }, false);
        }
        return super.getChooserNodes(chooser, ContainerUtil.filter(candidates, ivar -> !synthesizedIvars.contains(ivar.getName())), actionContext, moreNodesLevel);
    }

    @Override
    protected void optionValueChanged(OCMemberChooser chooser, Collection<OCInstanceVariableSymbol> candidates, OCOption option, OCGenerateFromIvarsActionContext actionContext) {
        if (SHOW_SYNTHESIZED.equals(option)) {
            chooser.resetElements(this.getChooserNodes(chooser, candidates, actionContext, 0));
        }
    }

    private static /* synthetic */ void lambda$performAction$1(List ivars, @Nullable String customName, Map newNames, boolean convertUsages, OCInterfaceSymbol interfaceSymbol, @Nullable OCPropertySymbol.PropertySemantics customSemantics, PsiFile file2, PsiElement psiContext, boolean isReadonly, Map newDeclarations, Map existingDeclarations, boolean replaceAllIvars, List synthesizes, OCNotReleasedIvarInspection.IvarsInfo ivarsInfo, List nonReleasedIvars) {
        for (OCInstanceVariableSymbol ivar : ivars) {
            OCType ivarType;
            OCPropertySymbol associatedProperty = ivar.getAssociatedProperty();
            String propName = customName != null ? customName : (associatedProperty != null ? associatedProperty.getName() : OCNameSuggester.getNonCollidingName(ivar, true));
            newNames.put(ivar, convertUsages ? propName : OCNameSuggester.getClang4ImplicitIvarName(propName));
            CommonProcessors.FindFirstProcessor finder = new CommonProcessors.FindFirstProcessor();
            if (interfaceSymbol != null) {
                interfaceSymbol.processMembers(propName, OCPropertySymbol.class, finder);
            }
            if (!finder.isFound()) {
                OCPropertySymbol.PropertySemantics semantics = null;
                OCType type2 = ivar.getResolvedType();
                if (customSemantics != null) {
                    semantics = customSemantics;
                } else if (OCCompilerHelper.isArcEnabled(file2) && type2.isPointerToObjectCompatible()) {
                    semantics = ivar.getARCAttribute(psiContext).getPropertyCompatibleSemantics(type2, psiContext);
                }
                OCProperty property = OCElementFactory.propertyDeclaration(propName, type2, psiContext, semantics, isReadonly);
                newDeclarations.put(ivar, property);
            } else {
                existingDeclarations.put(ivar, finder.getFoundValue());
            }
            if (!(replaceAllIvars || OCCompilerHelper.supportsAutosynthesis(file2) && OCNameSuggester.getClang4ImplicitIvarName(propName).equals(ivar.getName()))) {
                OCSynthesizePropertiesList synthesize = OCElementFactory.synthesizeList("@synthesize", propName, propName.equals(ivar.getName()) ? null : ivar.getName(), psiContext);
                synthesizes.add(synthesize);
            }
            if (!(ivarType = ivar.getResolvedType()).isPointerToObjectCompatible() || ivarsInfo == null || OCNotReleasedIvarInspection.isIvarReleased(ivar, file2, ivarsInfo)) continue;
            nonReleasedIvars.add(ivar);
        }
    }
}

