/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.generate.handlers.implement;

import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.generate.OCCaretLocation;
import com.jetbrains.cidr.lang.generate.OCMemberChooser;
import com.jetbrains.cidr.lang.generate.OCMemberChooserObject;
import com.jetbrains.cidr.lang.generate.actions.OCOverrideImplementCppActionContext;
import com.jetbrains.cidr.lang.generate.handlers.implement.OCOverrideImplementCppFunctionsHandlerBase;
import com.jetbrains.cidr.lang.quickfixes.OCMakeFunctionVirtualFix;
import com.jetbrains.cidr.lang.search.OCFunctionAncestorsQuery;
import com.jetbrains.cidr.lang.settings.OCBooleanOption;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.settings.OCOption;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCOverrideImplementCppFunctionsHandler
extends OCOverrideImplementCppFunctionsHandlerBase {
    private static final OCBooleanOption SHOW_NON_VIRTUAL_FUNCTIONS = new OCBooleanOption(OCBundle.message("override.implement.cpp.action.showNonVirtual", new Object[0]));

    protected boolean defaultShowNonVirtualOption(PsiFile file2, @Nullable Editor editor) {
        return true;
    }

    @Override
    @Nullable
    public String getActionName() {
        return OCBundle.message("override.implement.cpp.action.name", new Object[0]);
    }

    @Override
    protected String getMembersChooserTitle() {
        return OCBundle.message("override.implement.cpp.action.memberChooserTitle", new Object[0]);
    }

    @Override
    protected String getNoMembersMessage(@NotNull OCOverrideImplementCppActionContext context) {
        return OCBundle.message("override.implement.cpp.action.noMember", context.getParentNameUppercase());
    }

    @Override
    @NotNull
    protected String getNoParentsMessage() {
        return OCBundle.message("override.implement.cpp.action.noParent", new Object[0]);
    }

    @Override
    protected OCOverrideImplementCppActionContext evaluateActionContext(OCStructSymbol parent, PsiElement context) {
        return new OCOverrideImplementCppActionContext(parent, context, false);
    }

    @Override
    protected OCMemberChooserObject[] getChooserNodes(OCMemberChooser chooser, Collection<OCFunctionSymbol> candidates, OCOverrideImplementCppActionContext actionContext, int moreNodesLevel) {
        Boolean showNonVirtual = OCOverrideImplementCppFunctionsHandler.getOption(chooser.getOptionSelections(), SHOW_NON_VIRTUAL_FUNCTIONS);
        return super.getChooserNodes(chooser, (Collection<OCFunctionSymbol>)ContainerUtil.filter(candidates, symbol -> {
            VirtualFile file2 = symbol.getContainingFile();
            return showNonVirtual != false && file2 != null && file2.isWritable() || symbol.isVirtual() || symbol.isOverride() || symbol.isFinal() || OCFunctionAncestorsQuery.findFirstVirtual(symbol, false) != null;
        }), actionContext, moreNodesLevel);
    }

    @Override
    protected void loadOptions(PsiFile file2, Editor editor, @NotNull OCOverrideImplementCppActionContext actionContext, @Nullable OCCodeStyleSettings settings, @NotNull List<Pair<OCOption, Object>> options) {
        options.add((Pair<OCOption, Object>)new Pair((Object)SHOW_NON_VIRTUAL_FUNCTIONS, (Object)this.defaultShowNonVirtualOption(file2, editor)));
        super.loadOptions(file2, editor, actionContext, settings, options);
    }

    @Override
    protected void optionValueChanged(OCMemberChooser chooser, Collection<OCFunctionSymbol> candidates, OCOption option, OCOverrideImplementCppActionContext actionContext) {
        if (SHOW_NON_VIRTUAL_FUNCTIONS.equals(option)) {
            chooser.resetElements(this.getChooserNodes(chooser, candidates, actionContext, 0));
        }
    }

    @Override
    protected void doPerformAction(final @NotNull Project project2, @NotNull OCCaretLocation location, final @NotNull OCOverrideImplementCppActionContext actionContext, final @NotNull List<OCFunctionSymbol> chosenCandidates) {
        super.doPerformAction(project2, location, actionContext, (List<OCFunctionSymbol>)ContainerUtil.map(chosenCandidates, symbol -> {
            if (!symbol.isVirtual() && !((OCStructSymbol)actionContext.getParent()).equals(symbol.getParent())) {
                return new OCFunctionSymbol((OCFunctionSymbol)symbol){

                    @Override
                    public boolean isVirtual() {
                        return true;
                    }
                };
            }
            return symbol;
        }));
        new WriteCommandAction(project2, new PsiFile[]{location.getFile()}){

            protected void run(@NotNull Result result2) throws Throwable {
                Collections.sort(chosenCandidates, (o1, o2) -> o2.getOffset() - o1.getOffset());
                for (OCFunctionSymbol candidate : chosenCandidates) {
                    OCMakeFunctionVirtualFix fix = new OCMakeFunctionVirtualFix(candidate, false);
                    Editor editor = actionContext.getEditor();
                    PsiFile file2 = actionContext.getEditorFile();
                    if (((OCStructSymbol)actionContext.getParent()).equals(candidate.getParent()) || OCFunctionAncestorsQuery.findFirstVirtual(candidate, false) != null || !fix.isAvailable(project2, editor, file2)) continue;
                    fix.invoke(project2, editor, file2);
                }
            }
        }.execute();
    }
}

