/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.generate.handlers.implement;

import com.intellij.psi.PsiElement;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.generate.actions.OCOverrideImplementActionContext;
import com.jetbrains.cidr.lang.generate.handlers.implement.OCImplementOCMethodsHandler;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.util.OCCallableUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class OCOverrideImplementOCMethodHandler
extends OCImplementOCMethodsHandler {
    @Override
    protected String getNoMembersMessage(@NotNull OCOverrideImplementActionContext context) {
        return context.getParentNameUppercase() + " has no methods to override/implement";
    }

    @Override
    protected boolean defaultShowOptional() {
        return true;
    }

    @Override
    protected boolean defaultShowSynthesizedAccessors() {
        return true;
    }

    @Override
    @NotNull
    protected OCOverrideImplementActionContext evaluateActionContext(OCClassSymbol parent, final PsiElement element) {
        return new OCOverrideImplementActionContext(parent, parent.getResolvedType(true), element){

            @Override
            @NotNull
            public Collection<OCMethodSymbol> getMemberCandidates() {
                HashSet names = new HashSet();
                ArrayList<OCMethodSymbol> candidates = new ArrayList<OCMethodSymbol>();
                OCObjectType type2 = this.getType();
                OCObjectType superType = type2.getSuperType();
                if (superType == null || type2.getClassSymbol() == null || superType.getClassSymbol() == null) {
                    return Collections.emptyList();
                }
                type2.processInterfaceMethods(this.getInterfaceSymbol(), null, (Processor<OCMethodSymbol>)((Processor)symbol -> {
                    if (names.add(symbol.getSignature())) {
                        candidates.add((OCMethodSymbol)symbol);
                        this.myAbstractMethods.add(symbol);
                    }
                    return true;
                }), element, false);
                superType.processMembers(null, OCMethodSymbol.class, symbol -> {
                    if (names.add(symbol.getSignature())) {
                        candidates.add((OCMethodSymbol)symbol);
                    }
                    return true;
                }, true, false);
                return candidates;
            }
        };
    }

    @Override
    protected String getMembersChooserTitle() {
        return "Choose Methods to Override/Implement";
    }

    @Override
    protected boolean selectAllCandidates() {
        return false;
    }

    @Override
    protected String generateMethodText(OCMethodSymbol baseMethod, PsiElement context, OCOverrideImplementActionContext actionContext) {
        String templateName = actionContext.isAbstract(baseMethod) ? "OC Implemented Method Body.m" : "OC Overridden Method Body.m";
        HashMap<String, String> map2 = new HashMap<String, String>();
        OCPropertySymbol property = baseMethod.getGeneratedFromProperty();
        if (property != null) {
            map2.put("IVAR_IS_AVAILABLE", actionContext.isIvarAvailable(property) ? "true" : "false");
        }
        return OCCallableUtil.methodFromTemplate(baseMethod, templateName, context, map2);
    }
}

