/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.hierarchy;

import com.intellij.ide.hierarchy.HierarchyBrowser;
import com.intellij.ide.hierarchy.HierarchyProvider;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.hierarchy.OCTypeHierarchyBrowser;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCIncludeDirective;
import org.jetbrains.annotations.NotNull;

public class OCIncludeHierarchyProvider
implements HierarchyProvider {
    public PsiElement getTarget(@NotNull DataContext dataContext) {
        PsiElement psi = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
        if (psi instanceof OCIncludeDirective) {
            return ((OCIncludeDirective)psi).getIncludedFile();
        }
        PsiElement psiFile = (PsiElement)CommonDataKeys.PSI_FILE.getData(dataContext);
        return psiFile != null && psiFile instanceof OCFile ? psiFile : null;
    }

    @NotNull
    public HierarchyBrowser createHierarchyBrowser(PsiElement target) {
        return new OCTypeHierarchyBrowser(target.getProject(), (OCElement)target);
    }

    public void browserActivated(@NotNull HierarchyBrowser hierarchyBrowser) {
        OCTypeHierarchyBrowser browser = (OCTypeHierarchyBrowser)hierarchyBrowser;
        String typeName = browser.isImplementation() ? OCTypeHierarchyBrowser.SUPERTYPES_HIERARCHY_TYPE : OCTypeHierarchyBrowser.SUBTYPES_HIERARCHY_TYPE;
        browser.changeView(typeName);
    }
}

