/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.hierarchy.call;

import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.HashMap;
import com.jetbrains.cidr.lang.hierarchy.call.OCCallHierarchyNodeDescriptor;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class OCCallHierarchyNodeAggregator {
    private final Map<String, OCCallHierarchyNodeDescriptor> myMap;
    private final HierarchyNodeDescriptor myParentDescriptor;

    public OCCallHierarchyNodeAggregator(OCCallHierarchyNodeDescriptor parentDescriptor) {
        this.myParentDescriptor = parentDescriptor;
        this.myMap = new HashMap();
    }

    @Nullable
    public OCCallHierarchyNodeDescriptor addNodeDescriptor(OCSymbol known, @Nullable String selectorName, OCElement context) {
        OCCallHierarchyNodeDescriptor desc;
        String name;
        if (known instanceof OCFunctionSymbol) {
            OCQualifiedName qualifiedName = ((OCFunctionSymbol)known).getResolvedQualifiedName();
            name = qualifiedName != null ? qualifiedName.toString() + ((OCFunctionSymbol)known).getParametersSignature() : known.getSignature();
        } else if (known instanceof OCMethodSymbol) {
            OCMethodSymbol methodSymbol = (OCMethodSymbol)known;
            if (methodSymbol.getDefinitionSymbol() == null && methodSymbol.getGeneratedFromProperty() != null) {
                return null;
            }
            name = ((OCClassSymbol)methodSymbol.getParent()).getName() + "." + known.getSignature();
        } else {
            name = selectorName;
        }
        if (this.myMap.containsKey(name)) {
            desc = this.myMap.get(name);
            desc.incrementUsageCount();
        } else {
            Object element;
            Project project2 = this.myParentDescriptor.getProject();
            desc = known != null ? new OCCallHierarchyNodeDescriptor(project2, this.myParentDescriptor, (PsiElement)((element = known.locateDefinition()) != null ? element : context), false, false) : new OCCallHierarchyNodeDescriptor(project2, this.myParentDescriptor, context, false, false);
            this.myMap.put(name, desc);
        }
        return desc;
    }

    public Object[] getChildren() {
        return this.myMap.values().toArray();
    }
}

