/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.hierarchy.call;

import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.ide.hierarchy.HierarchyTreeStructure;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.hierarchy.call.OCCallHierarchyNodeAggregator;
import com.jetbrains.cidr.lang.hierarchy.call.OCCallHierarchyNodeDescriptor;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCProperty;
import com.jetbrains.cidr.lang.psi.OCPropertyAttribute;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.search.OCFunctionReferenceSearch;
import com.jetbrains.cidr.lang.search.OCMethodReferencesSearch;
import com.jetbrains.cidr.lang.search.usages.OCReadWriteAccessDetector;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbolImpl;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class OCCallerMethodsTreeStructure
extends HierarchyTreeStructure {
    private final String myScopeType;

    public OCCallerMethodsTreeStructure(Project project2, OCCallable method2, String scopeType) {
        super(project2, new OCCallHierarchyNodeDescriptor(project2, null, method2, true, true));
        this.myScopeType = scopeType;
    }

    @Override
    @NotNull
    protected final Object[] buildChildren(@NotNull HierarchyNodeDescriptor descriptor) {
        Object methodElement;
        OCCallHierarchyNodeDescriptor nodeDescriptor = (OCCallHierarchyNodeDescriptor)descriptor;
        final OCCallHierarchyNodeAggregator aggregator = new OCCallHierarchyNodeAggregator(nodeDescriptor);
        OCCallable enclosingElement = nodeDescriptor.getEnclosingElement();
        OCSymbol symbol = enclosingElement.getSymbol();
        PsiElement baseMethod = ((OCCallHierarchyNodeDescriptor)this.getBaseDescriptor()).getTargetElement();
        final SearchScope searchScope = this.getSearchScope(this.myScopeType, (PsiElement)baseMethod.getContainingFile());
        if (symbol != null && (methodElement = symbol.locateDefinition()) != null) {
            class Consumer
            implements Processor<PsiReference> {
                private final HashSet<PsiElement> myProcessed = new HashSet();

                Consumer() {
                }

                public boolean process(PsiReference psiReference) {
                    PsiElement element = psiReference.getElement();
                    String selectorName = null;
                    if (element instanceof OCElement && this.myProcessed.add(element)) {
                        OCSymbol parentSymbol;
                        if (element instanceof OCSendMessageExpression) {
                            OCSendMessageExpression sendMessage = (OCSendMessageExpression)element;
                            selectorName = sendMessage.getMessageSelector();
                        } else if (element instanceof OCPropertyAttribute) {
                            boolean isSetter;
                            OCProperty property = ((OCPropertyAttribute)element).getParentProperty();
                            String attributeName = ((OCPropertyAttribute)element).getName();
                            if (attributeName == null) {
                                return true;
                            }
                            OCPropertySymbol.PropertyAttribute attr = OCPropertySymbolImpl.parseAttribute(attributeName);
                            boolean isGetter = attr == OCPropertySymbol.PropertyAttribute.GETTER;
                            boolean bl = isSetter = attr == OCPropertySymbol.PropertyAttribute.SETTER;
                            if (property == null) {
                                return true;
                            }
                            OCDeclaration declaration2 = property.getDeclaration();
                            if (declaration2 == null) {
                                return true;
                            }
                            List<OCDeclarator> declarators = declaration2.getDeclarators();
                            if (declarators.size() != 1) {
                                return true;
                            }
                            ReferencesSearch.SearchParameters queryParameters = new ReferencesSearch.SearchParameters((PsiElement)declarators.get(0), searchScope, false);
                            ReferencesSearch.search((ReferencesSearch.SearchParameters)queryParameters).forEach(reference -> {
                                ReadWriteAccessDetector.Access access;
                                PsiElement element1 = reference.getElement();
                                if ((element1 instanceof OCReferenceElement || element1 instanceof OCQualifiedExpression) && ((access = new OCReadWriteAccessDetector().getExpressionAccess(element1)) == ReadWriteAccessDetector.Access.Read && isGetter || access == ReadWriteAccessDetector.Access.Write && isSetter || access == ReadWriteAccessDetector.Access.ReadWrite && (isGetter || isSetter))) {
                                    return this.process((PsiReference)reference);
                                }
                                return true;
                            });
                            return true;
                        }
                        OCCallable parent = (OCCallable)PsiTreeUtil.getContextOfType((PsiElement)element, (Class[])new Class[]{OCCallable.class});
                        if (parent != null && (parentSymbol = parent.getSymbol()) != null) {
                            aggregator.addNodeDescriptor(parentSymbol, selectorName, (OCElement)element);
                        }
                    }
                    return true;
                }
            }
            if (symbol instanceof OCMethodSymbol) {
                ReferencesSearch.SearchParameters queryParameters = new ReferencesSearch.SearchParameters(methodElement, searchScope, false);
                new OCMethodReferencesSearch(true).execute(queryParameters, new Consumer());
            } else if (symbol instanceof OCFunctionSymbol) {
                ReferencesSearch.SearchParameters queryParameters = new ReferencesSearch.SearchParameters(methodElement, searchScope, false);
                new OCFunctionReferenceSearch(true).execute(queryParameters, new Consumer());
            }
        }
        return aggregator.getChildren();
    }

    @Override
    public boolean isAlwaysShowPlus() {
        return true;
    }
}

