/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.inspections;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.PairProcessor;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.hash.HashMap;
import com.intellij.util.containers.hash.HashSet;
import com.jetbrains.cidr.lang.dfa.OCControlFlowBuilder;
import com.jetbrains.cidr.lang.dfa.OCControlFlowGraph;
import com.jetbrains.cidr.lang.dfa.OCInstruction;
import com.jetbrains.cidr.lang.inspections.OCInspections;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCDefineDirective;
import com.jetbrains.cidr.lang.psi.OCDoWhileStatement;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCForStatement;
import com.jetbrains.cidr.lang.psi.OCLambdaExpression;
import com.jetbrains.cidr.lang.psi.OCLoopStatement;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.psi.OCWhileStatement;
import com.jetbrains.cidr.lang.psi.impl.OCMacroReferenceElementImpl;
import com.jetbrains.cidr.lang.psi.visitors.OCRecursiveVisitor;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.types.OCMagicType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeUtils;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCLoopDoesntUseConditionVariableInspection
extends OCInspections.GeneralCpp {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        return "Loop condition isn't updated inside the loop";
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        return new ForLoopThatDoesntUseLoopVariableVisitor(holder);
    }

    private class ForLoopThatDoesntUseLoopVariableVisitor
    extends OCVisitor {
        private final ProblemsHolder myHolder;
        private final HashMap<OCCallable, OCControlFlowGraph> myGraphs;

        public ForLoopThatDoesntUseLoopVariableVisitor(ProblemsHolder holder) {
            this.myHolder = holder;
            this.myGraphs = new HashMap();
        }

        @Override
        public void visitForStatement(@NotNull OCForStatement statement2) {
            this.processLoop(statement2, statement2.getCondition(), statement2.getBody(), statement2.getIncrement());
        }

        @Override
        public void visitWhileStatement(OCWhileStatement statement2) {
            this.processLoop(statement2, statement2.getCondition(), statement2.getBody(), null);
        }

        @Override
        public void visitDoWhileStatement(OCDoWhileStatement statement2) {
            this.processLoop(statement2, statement2.getCondition(), statement2.getBody(), null);
        }

        private void processLoop(@NotNull OCLoopStatement loop, @Nullable OCElement condition2, @Nullable OCStatement body2, @Nullable OCStatement increment) {
            if (condition2 == null) {
                return;
            }
            Ref declaratorUsed = new Ref((Object)false);
            HashSet usedSymbols = new HashSet();
            if (OCCodeInsightUtil.hasSideEffects(condition2)) {
                return;
            }
            OCCallable callable = this.getTopmostCallable(loop);
            if (callable == null) {
                return;
            }
            OCControlFlowGraph graph = this.getCFG(callable);
            this.processAllUsedSymbol(condition2, (PairProcessor<OCSymbolDeclarator, OCElement>)((PairProcessor)(arg_0, arg_1) -> ForLoopThatDoesntUseLoopVariableVisitor.lambda$processLoop$0(declaratorUsed, (Set)usedSymbols, arg_0, arg_1)));
            if (((Boolean)declaratorUsed.get()).booleanValue() || usedSymbols.isEmpty()) {
                return;
            }
            for (OCSymbolDeclarator declarator : usedSymbols) {
                if (!this.declaratorIsUsed(declarator, graph, body2, increment)) continue;
                declaratorUsed.set((Object)true);
                break;
            }
            if (!((Boolean)declaratorUsed.get()).booleanValue()) {
                String message2 = usedSymbols.size() > 1 ? "Local variables used in loop condition are not updated in the loop" : "Local variable used in loop condition is not updated in the loop";
                OCLoopDoesntUseConditionVariableInspection.this.registerProblem(this.myHolder, null, null, this.myHolder.isOnTheFly(), condition2, message2, "warn_variables_not_in_loop_body", ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new IntentionAction[0]);
            }
        }

        private void processAllUsedSymbol(@NotNull OCElement condition2, final @NotNull PairProcessor<OCSymbolDeclarator, OCElement> processor2) {
            condition2.accept(new OCRecursiveVisitor(){
                public boolean myStopped = false;

                @Override
                public void visitReferenceElement(OCReferenceElement element) {
                    this.checkReferences(element);
                    super.visitReferenceElement(element);
                }

                @Override
                public void visitQualifiedExpression(OCQualifiedExpression expression2) {
                    this.checkReferences(expression2);
                    super.visitQualifiedExpression(expression2);
                }

                @Override
                public void visitSendMessageExpression(OCSendMessageExpression expression2) {
                    this.checkReferences(expression2);
                    super.visitSendMessageExpression(expression2);
                }

                @Override
                public void visitExpression(OCExpression expression2) {
                    this.checkReferences(expression2);
                    super.visitExpression(expression2);
                }

                private void checkReferences(OCElement element) {
                    PsiElement resolved;
                    PsiReference ref;
                    if (!(this.myStopped || (ref = element.getReference()) == null || !((resolved = ref.resolve()) instanceof OCSymbolDeclarator) || resolved instanceof OCDefineDirective || resolved instanceof OCMacroReferenceElementImpl || processor2.process((Object)((OCSymbolDeclarator)resolved), (Object)element))) {
                        this.myStopped = true;
                    }
                }
            });
        }

        private boolean declaratorIsUsed(@NotNull OCSymbolDeclarator declarator, @NotNull OCControlFlowGraph graph, @Nullable OCStatement body2, @Nullable OCStatement increment) {
            Object symbol = declarator.getSymbol();
            if (symbol == null) {
                return true;
            }
            OCResolveContext resolveContext = new OCResolveContext(declarator);
            OCType declaratorType = symbol.getType().resolve(resolveContext);
            if (OCTypeUtils.isInstanceOfType(declaratorType, OCStructType.class, OCMagicType.class)) {
                return true;
            }
            MultiMap<OCInstruction.InstructionKind, OCInstruction> instructions = graph.getInstructions((OCSymbol)symbol);
            if (instructions == null) {
                return false;
            }
            for (OCInstruction instruction : instructions.values()) {
                switch (instruction.getKind()) {
                    case REFERENCE: {
                        return true;
                    }
                    case WRITE_IN_BLOCK: {
                        return true;
                    }
                    case WRITE: {
                        if (!this.inLoopScope(body2, increment, instruction.getLValue())) break;
                        return true;
                    }
                    case READ_IN_BLOCK: {
                        if (!OCTypeUtils.isInstanceOfType(declaratorType, OCPointerType.class)) break;
                        return true;
                    }
                    case READ: {
                        if (!OCTypeUtils.isInstanceOfType(declaratorType, OCPointerType.class) || !this.inLoopScope(body2, increment, instruction.getRValue())) break;
                        return true;
                    }
                }
            }
            return false;
        }

        private boolean inLoopScope(@Nullable OCStatement body2, @Nullable OCStatement increment, @Nullable PsiElement element) {
            if (element == null) {
                return false;
            }
            return PsiTreeUtil.isAncestor((PsiElement)body2, (PsiElement)element, (boolean)false) || PsiTreeUtil.isAncestor((PsiElement)increment, (PsiElement)element, (boolean)false);
        }

        private OCControlFlowGraph getCFG(@NotNull OCCallable callable) {
            if (this.myGraphs.containsKey((Object)callable)) {
                return (OCControlFlowGraph)this.myGraphs.get((Object)callable);
            }
            OCControlFlowGraph graph = new OCControlFlowGraph(callable, null);
            OCControlFlowBuilder builder = new OCControlFlowBuilder(null, graph, null);
            builder.processFirstCodeFragment(callable);
            this.myGraphs.put((Object)callable, (Object)graph);
            return graph;
        }

        private OCCallable getTopmostCallable(@NotNull PsiElement element) {
            OCCallable callable = (OCCallable)PsiTreeUtil.getParentOfType((PsiElement)element, OCCallable.class);
            while (callable instanceof OCLambdaExpression) {
                callable = (OCCallable)PsiTreeUtil.getParentOfType((PsiElement)callable, OCCallable.class);
            }
            return callable;
        }

        private static /* synthetic */ boolean lambda$processLoop$0(Ref declaratorUsed, Set usedSymbols, OCSymbolDeclarator declarator, OCElement element) {
            Object symbol = declarator.getSymbol();
            if (symbol == null || !symbol.getKind().isLocal() || symbol instanceof OCDeclaratorSymbol && ((OCDeclaratorSymbol)symbol).isBlockModifiable()) {
                declaratorUsed.set((Object)true);
                return false;
            }
            usedSymbols.add(declarator);
            return true;
        }
    }
}

