/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.inspections;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.IntentionWrapper;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.ui.CheckBox;
import com.jetbrains.cidr.lang.daemon.OCGetSymbolVisitor;
import com.jetbrains.cidr.lang.dfa.OCDataFlowAnalyzer;
import com.jetbrains.cidr.lang.dfa.OCNotReleasedVariablesChecker;
import com.jetbrains.cidr.lang.inspections.OCInspections;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.psi.OCArgumentSelector;
import com.jetbrains.cidr.lang.psi.OCAssignmentExpression;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCCallExpression;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCExpressionStatement;
import com.jetbrains.cidr.lang.psi.OCImplementation;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.psi.OCSynthesizeProperty;
import com.jetbrains.cidr.lang.psi.visitors.OCRecursiveVisitor;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.quickfixes.OCChangeTextIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCReleaseVariablesIntentionAction;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCImplementationSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCSynthesizeSymbol;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerHelper;
import java.awt.Component;
import java.awt.FlowLayout;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCNotReleasedIvarInspection
extends OCInspections.GeneralObjC {
    private static Key<IvarsInfo> IVARS_INFO_KEY = Key.create((String)"IVARS_INFO_KEY");
    public boolean releaseInDealloc = true;

    public JComponent createOptionsPanel() {
        JPanel panel2 = new JPanel(new FlowLayout(0));
        CheckBox checkBox = new CheckBox("Release should be in dealloc or any of its callees", (InspectionProfileEntry)this, "releaseInDealloc");
        panel2.add((Component)checkBox);
        return panel2;
    }

    public void inspectionStarted(@NotNull LocalInspectionToolSession session2, boolean isOnTheFly) {
        if (!OCCompilerHelper.isArcDisabled(session2.getFile())) {
            return;
        }
        IvarsInfo ivarsInfo = new IvarsInfo();
        session2.putUserData(IVARS_INFO_KEY, (Object)ivarsInfo);
        session2.getFile().accept((PsiElementVisitor)new InitialVisitor(ivarsInfo));
    }

    public static IvarsInfo startInspection(@NotNull PsiFile file2) {
        OCNotReleasedIvarInspection inspection = new OCNotReleasedIvarInspection();
        LocalInspectionToolSession session2 = new LocalInspectionToolSession(file2, 0, file2.getTextLength());
        inspection.inspectionStarted(session2, true);
        return (IvarsInfo)session2.getUserData(IVARS_INFO_KEY);
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session2) {
        final IvarsInfo ivarsInfo = (IvarsInfo)session2.getUserData(IVARS_INFO_KEY);
        if (!OCCompilerHelper.isArcDisabled(holder.getFile()) || ivarsInfo == null) {
            return new OCVisitor();
        }
        final OCRecursiveVisitor visitor = new OCRecursiveVisitor(){
            private OCMethodSymbol curMethod;

            @Override
            public void visitSendMessageExpression(OCSendMessageExpression expression2) {
                OCInstanceVariableSymbol symbol = OCNotReleasedIvarInspection.getReceiverIvar(expression2.getReceiverExpression());
                if ("retain".equals(expression2.getMessageSelector()) && symbol != null && !OCNotReleasedIvarInspection.isIvarReleased(symbol, expression2, this.curMethod, holder.getFile(), ivarsInfo) && !(expression2.getParent() instanceof OCAssignmentExpression)) {
                    OCNotReleasedIvarInspection.this.reportWarning(symbol, expression2.getReceiverExpression(), holder);
                }
            }

            @Override
            public void visitAssignmentExpression(OCAssignmentExpression expression2) {
                OCInstanceVariableSymbol symbol = OCNotReleasedIvarInspection.getReceiverIvar(expression2.getReceiverExpression());
                OCExpression sourceExpression = expression2.getSourceExpression();
                if (OCElementUtil.isRetainCall(sourceExpression, true) && symbol != null && !OCNotReleasedIvarInspection.isIvarReleased(symbol, expression2, this.curMethod, holder.getFile(), ivarsInfo)) {
                    if (sourceExpression instanceof OCSendMessageExpression) {
                        OCSendMessageExpression call = (OCSendMessageExpression)sourceExpression;
                        OCInstanceVariableSymbol receiver2 = OCNotReleasedIvarInspection.getReceiverIvar(call.getReceiverExpression());
                        if ("retain".equals(call.getMessageSelector()) && receiver2 != null && OCNotReleasedIvarInspection.isIvarReleased(receiver2, call, this.curMethod, holder.getFile(), ivarsInfo)) {
                            return;
                        }
                    }
                    OCNotReleasedIvarInspection.this.reportWarning(symbol, expression2.getReceiverExpression(), holder);
                }
            }

            @Override
            public void visitSynthesizeProperty(OCSynthesizeProperty statement2) {
                OCInstanceVariableSymbol ivar;
                OCReferenceElement propertyRef = statement2.getPropertyRef();
                OCReferenceElement ivarRef = statement2.getInstanceVariableRef();
                if (propertyRef == null) {
                    return;
                }
                OCPropertySymbol property = (OCPropertySymbol)propertyRef.resolveToSymbol();
                if (property != null && !property.isRetained()) {
                    property = property.getAssociatedPropertyInPrivateCategory();
                }
                OCInstanceVariableSymbol oCInstanceVariableSymbol = ivar = property != null ? property.getAssociatedIvar() : null;
                if (ivar == null) {
                    OCSynthesizeSymbol synthesizeSymbol = (OCSynthesizeSymbol)statement2.getSymbol();
                    OCInstanceVariableSymbol oCInstanceVariableSymbol2 = ivar = synthesizeSymbol != null ? synthesizeSymbol.getIvarSymbol() : null;
                }
                if (property != null && ivar != null && property.isRetained() && !OCNotReleasedIvarInspection.isIvarReleased(ivar, holder.getFile(), ivarsInfo)) {
                    OCNotReleasedIvarInspection.this.reportWarning(ivar, ivarRef != null ? ivarRef : propertyRef, holder);
                }
            }

            @Override
            public void visitMethod(OCMethod method2) {
                this.curMethod = (OCMethodSymbol)method2.getSymbol();
                super.visitMethod(method2);
                this.curMethod = null;
            }
        };
        final Ref isProcessed = Ref.create((Object)false);
        return new OCVisitor(){

            public void visitElement(PsiElement element) {
                if (!((Boolean)isProcessed.get()).booleanValue()) {
                    element.getContainingFile().accept((PsiElementVisitor)visitor);
                    isProcessed.set((Object)true);
                }
            }
        };
    }

    public void reportWarning(OCInstanceVariableSymbol ivar, PsiElement element, ProblemsHolder holder) {
        String message2 = ivar.getNameWithKindUppercase() + " is not released in 'dealloc' method";
        IntentionWrapper fix = new IntentionWrapper((IntentionAction)new OCReleaseVariablesIntentionAction(Collections.singletonList(ivar)), holder.getFile());
        this.registerProblem(holder, null, null, holder.isOnTheFly(), element, message2, "CIDR", ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new IntentionAction[]{fix});
    }

    public static boolean isIvarReleased(OCInstanceVariableSymbol ivar, @NotNull PsiFile file2, @NotNull IvarsInfo ivarsInfo) {
        return OCNotReleasedIvarInspection.isIvarReleased(ivar, null, null, file2, ivarsInfo);
    }

    private static boolean isIvarReleased(OCInstanceVariableSymbol ivar, @Nullable PsiElement element, @Nullable OCMethodSymbol outerMethod, @NotNull PsiFile file2, @NotNull IvarsInfo ivarsInfo) {
        if (!ivar.getType().resolve(file2).isPointerToObjectCompatible() || ivarsInfo.myReleasedIvars.contains(ivar)) {
            return true;
        }
        Map map2 = (Map)ivarsInfo.myLocalReleases.get(ivar);
        if (outerMethod != null && element != null && map2 != null) {
            PsiElement localRelease = (PsiElement)map2.get(outerMethod);
            return localRelease != null && element.getTextOffset() < localRelease.getTextOffset();
        }
        return false;
    }

    public void inspectionFinished(@NotNull LocalInspectionToolSession session2, @NotNull ProblemsHolder holder) {
        IvarsInfo ivarsInfo = (IvarsInfo)session2.getUserData(IVARS_INFO_KEY);
        if (!OCCompilerHelper.isArcDisabled(session2.getFile()) || ivarsInfo == null) {
            return;
        }
        for (Pair pair : ivarsInfo.myLocalRetainedIvars) {
            if (OCNotReleasedIvarInspection.isIvarReleased((OCInstanceVariableSymbol)pair.getFirst(), holder.getFile(), ivarsInfo)) continue;
            this.reportWarning((OCInstanceVariableSymbol)pair.getFirst(), (PsiElement)pair.getSecond(), holder);
        }
        for (OCMethodSymbol method2 : ivarsInfo.myDeallocs.keySet()) {
            PsiFile file2;
            PsiElement closingBrace = (PsiElement)ivarsInfo.myDeallocs.get(method2);
            if (closingBrace == null || !(file2 = closingBrace.getContainingFile()).equals(holder.getFile())) continue;
            String message2 = method2.getNameWithKindUppercase() + " misses the call to [super dealloc] at the last statement";
            OCChangeTextIntentionAction fix = new OCChangeTextIntentionAction(file2, closingBrace.getTextOffset(), 0, "[super dealloc];\n", "Add call to [super dealloc]");
            this.registerProblem(holder, null, null, holder.isOnTheFly(), closingBrace, message2, "CIDR", ProblemHighlightType.GENERIC_ERROR_OR_WARNING, fix);
        }
    }

    @Nullable
    public static OCSendMessageExpression getCallToSuper(OCStatement stmt) {
        if (!(stmt instanceof OCExpressionStatement)) {
            return null;
        }
        OCExpression expression2 = ((OCExpressionStatement)stmt).getExpression();
        if (!(expression2 instanceof OCSendMessageExpression)) {
            return null;
        }
        OCSendMessageExpression call = (OCSendMessageExpression)expression2;
        OCExpression receiver2 = call.getReceiverExpression();
        return call.getMessageSelector().equals("dealloc") && receiver2 instanceof OCReferenceExpression && ((OCReferenceExpression)receiver2).getSelfSuperToken() == OCElementTypes.SelfSuperToken.SUPER ? call : null;
    }

    @Nullable
    public static OCInstanceVariableSymbol getReceiverIvar(@Nullable OCExpression receiver2) {
        return OCNotReleasedIvarInspection.getReceiverIvar(receiver2, true);
    }

    @Nullable
    public static OCInstanceVariableSymbol getReceiverIvar(@Nullable OCExpression receiver2, boolean onlySelf) {
        OCSymbol symbol = OCNotReleasedIvarInspection.getReceiverSymbol(receiver2, onlySelf);
        if (symbol instanceof OCInstanceVariableSymbol) {
            return (OCInstanceVariableSymbol)symbol;
        }
        if (symbol instanceof OCPropertySymbol && !((OCPropertySymbol)symbol).isRetained()) {
            return ((OCPropertySymbol)symbol).getAssociatedIvar();
        }
        return null;
    }

    @Nullable
    public static OCSymbol getReceiverSymbol(@Nullable OCExpression receiver2, boolean onlySelf) {
        OCSymbol symbol = null;
        if (receiver2 instanceof OCReferenceExpression) {
            symbol = ((OCReferenceExpression)receiver2).resolveToSymbol();
        } else if (receiver2 instanceof OCQualifiedExpression) {
            OCExpression qualifier = ((OCQualifiedExpression)receiver2).getQualifier();
            if (!onlySelf || qualifier instanceof OCReferenceExpression && ((OCReferenceExpression)qualifier).getSelfSuperToken() == OCElementTypes.SelfSuperToken.SELF) {
                symbol = ((OCQualifiedExpression)receiver2).resolveToSymbol();
            }
        }
        return symbol;
    }

    private class InitialVisitor
    extends OCRecursiveVisitor {
        private IvarsInfo myIvarsInfo;
        private OCMethodSymbol curMethod;

        public InitialVisitor(IvarsInfo ivarsInfo) {
            this.myIvarsInfo = ivarsInfo;
        }

        public void visitFile(PsiFile file2) {
            for (PsiElement element : file2.getChildren()) {
                if (!(element instanceof OCImplementation)) continue;
                this.myIvarsInfo.myTraversedCallables.clear();
                this.visitImplementation((OCImplementation)element);
            }
        }

        @Override
        public void visitImplementation(OCImplementation implementation) {
            OCImplementationSymbol originalClass;
            super.visitImplementation(implementation);
            VirtualFile virtualFile = implementation.getContainingFile().getVirtualFile();
            if (virtualFile == null) {
                return;
            }
            OCObjectType type2 = implementation.getType();
            OCImplementationSymbol oCImplementationSymbol = originalClass = type2 != null ? type2.getImplementation() : null;
            while (type2 != null) {
                OCImplementationSymbol symbol = type2.getImplementation();
                if (symbol == null) {
                    OCInterfaceSymbol anInterface = type2.getInterface();
                    OCImplementationSymbol oCImplementationSymbol2 = symbol = anInterface != null ? anInterface.getImplementation() : null;
                    if (symbol == null) break;
                }
                Processor processor2 = symbol1 -> {
                    Object method2 = symbol1.locateDefinition();
                    if (method2 instanceof OCMethod) {
                        OCBlockStatement body2;
                        boolean isDealloc = "dealloc".equals(symbol1.getName());
                        if (!this.myIvarsInfo.myTraversedCallables.contains(symbol1)) {
                            this.myIvarsInfo.myTraversedCallables.add(symbol1);
                            method2.accept((PsiElementVisitor)new CallableVisitor(virtualFile, (OCClassSymbol)symbol1.getParent(), originalClass, isDealloc, this.myIvarsInfo));
                        }
                        if (isDealloc && (body2 = ((OCMethod)method2).getBody()) != null) {
                            PsiElement element;
                            int statementsCnt = body2.getStatements().size();
                            PsiElement psiElement = element = statementsCnt > 0 ? OCNotReleasedIvarInspection.getCallToSuper(body2.getStatements().get(statementsCnt - 1)) : null;
                            if (element == null) {
                                element = body2.getClosingBrace();
                                this.myIvarsInfo.myDeallocs.put(symbol1, element);
                            } else {
                                this.myIvarsInfo.myDeallocs.put(symbol1, null);
                            }
                        }
                    }
                    return true;
                };
                if (OCNotReleasedIvarInspection.this.releaseInDealloc) {
                    symbol.processMembers("dealloc", OCMethodSymbol.class, processor2);
                    OCType appDelegate = OCReferenceType.resolvedFromText("NSObject", "UIApplicationDelegate", implementation.getContainingFile());
                    OCType senTest = OCReferenceType.resolvedFromText("SenTest", implementation.getContainingFile());
                    OCType managedObject = OCReferenceType.resolvedFromText("NSManagedObject", implementation.getContainingFile());
                    if (appDelegate instanceof OCObjectType && appDelegate.isCompatible(type2, implementation)) {
                        symbol.processMembers("applicationWillTerminate:", OCMethodSymbol.class, processor2);
                    }
                    if (managedObject instanceof OCObjectType && managedObject.isCompatible(type2, implementation)) {
                        symbol.processMembers("didTurnIntoFault", OCMethodSymbol.class, processor2);
                    }
                    if (senTest instanceof OCObjectType && senTest.isCompatible(type2, implementation)) {
                        symbol.processMembers("tearDown", OCMethodSymbol.class, processor2);
                    }
                } else {
                    symbol.processMembers(null, OCMethodSymbol.class, processor2);
                }
                type2 = type2.getSuperType();
            }
        }

        @Override
        public void visitMethod(OCMethod method2) {
            this.curMethod = (OCMethodSymbol)method2.getSymbol();
            super.visitMethod(method2);
            OCDataFlowAnalyzer analyzer = new OCDataFlowAnalyzer(method2, null, null);
            analyzer.buildControlFlowGraph();
            for (OCSymbol symbol : analyzer.getGraph().getLocalSymbols()) {
                if (symbol.isUnnamed()) continue;
                analyzer.analyzeNotReleased(symbol, new OCNotReleasedVariablesChecker(analyzer.getGraph(), symbol){

                    @Override
                    protected void handleAssignedIvar(@NotNull Pair<OCInstanceVariableSymbol, PsiElement> pair) {
                        InitialVisitor.this.myIvarsInfo.myLocalRetainedIvars.add(pair);
                    }
                }, false);
            }
            this.curMethod = null;
        }

        @Override
        public void visitSendMessageExpression(OCSendMessageExpression expression2) {
            OCInstanceVariableSymbol ivar;
            super.visitSendMessageExpression(expression2);
            if (this.curMethod != null && OCElementUtil.isReleaseCall(expression2) && (ivar = OCNotReleasedIvarInspection.getReceiverIvar(expression2.getReceiverExpression(), false)) != null) {
                HashMap<OCMethodSymbol, OCArgumentSelector> map2 = (HashMap<OCMethodSymbol, OCArgumentSelector>)this.myIvarsInfo.myLocalReleases.get(ivar);
                if (map2 == null) {
                    map2 = new HashMap<OCMethodSymbol, OCArgumentSelector>();
                    this.myIvarsInfo.myLocalReleases.put(ivar, map2);
                }
                map2.put(this.curMethod, expression2.getArgumentSelectors().get(0));
            }
        }
    }

    private static class CallableVisitor
    extends OCRecursiveVisitor {
        private VirtualFile myContainingFile;
        private boolean isDealloc;
        private OCClassSymbol myClass;
        private IvarsInfo myIvarsInfo;
        private OCClassSymbol myOriginalClass;

        private CallableVisitor(VirtualFile containingFile, OCClassSymbol clazz, OCClassSymbol originalClass, boolean isDealloc, @NotNull IvarsInfo ivarsInfo) {
            this.myContainingFile = containingFile;
            this.myOriginalClass = originalClass;
            this.isDealloc = isDealloc;
            this.myClass = clazz;
            this.myIvarsInfo = ivarsInfo;
        }

        @Override
        public void visitSendMessageExpression(OCSendMessageExpression expression2) {
            super.visitSendMessageExpression(expression2);
            if (OCElementUtil.isReleaseCall(expression2)) {
                OCInstanceVariableSymbol ivar = OCNotReleasedIvarInspection.getReceiverIvar(expression2.getReceiverExpression(), false);
                if (ivar != null) {
                    this.myIvarsInfo.myReleasedIvars.add(ivar);
                }
                return;
            }
            for (OCMethodSymbol method2 : expression2.getProbableResponders().getFilteredByStaticnessResponders()) {
                OCPropertySymbol property = method2.getGeneratedFromProperty();
                if (property != null) {
                    if (!method2.isSetter()) continue;
                    this.processSetter(property);
                    continue;
                }
                this.processCallable(method2);
            }
        }

        @Override
        public void visitQualifiedExpression(OCQualifiedExpression expression2) {
            OCClassSymbol symbolParent;
            super.visitQualifiedExpression(expression2);
            PsiElement parent = expression2.getParent();
            OCSymbol symbol = expression2.resolveToSymbol();
            if (symbol instanceof OCMemberSymbol && (symbolParent = (OCClassSymbol)((OCMemberSymbol)symbol).getParent()) != null && Comparing.equal((String)symbolParent.getName(), (String)this.myClass.getName())) {
                if (this.isDealloc && symbol instanceof OCInstanceVariableSymbol) {
                    this.myIvarsInfo.myReleasedIvars.add((OCInstanceVariableSymbol)symbol);
                } else if (symbol instanceof OCPropertySymbol && parent instanceof OCAssignmentExpression && ((OCAssignmentExpression)parent).getReceiverExpression() == expression2) {
                    this.processSetter((OCPropertySymbol)symbol);
                } else if (symbol instanceof OCMethodSymbol) {
                    this.processCallable(symbol);
                }
            }
        }

        @Override
        public void visitReferenceElement(OCReferenceElement referenceElement) {
            OCSymbol ivar;
            super.visitReferenceElement(referenceElement);
            if (this.isDealloc && (ivar = referenceElement.resolveToSymbol()) instanceof OCInstanceVariableSymbol) {
                this.myIvarsInfo.myReleasedIvars.add((OCInstanceVariableSymbol)ivar);
            }
        }

        @Override
        public void visitCallExpression(OCCallExpression expression2) {
            super.visitCallExpression(expression2);
            OCExpression function = expression2.getFunctionReferenceExpression();
            OCGetSymbolVisitor visitor = new OCGetSymbolVisitor();
            function.accept(visitor);
            OCSymbol functionSymbol = visitor.getSymbol();
            if (functionSymbol instanceof OCFunctionSymbol) {
                this.processCallable(functionSymbol);
            }
        }

        private void processSetter(OCPropertySymbol property) {
            OCInstanceVariableSymbol ivar;
            if (property.processAccessorMethods((Processor<? super OCMethodSymbol>)((Processor)method2 -> {
                if (method2.isSetter()) {
                    this.processCallable((OCSymbol)method2);
                    return false;
                }
                return true;
            }), false) && property.isRetained() && (ivar = property.getAssociatedIvar()) != null) {
                this.myIvarsInfo.myReleasedIvars.add(ivar);
            }
        }

        private void processCallable(OCSymbol callable) {
            OCSymbol targetCallable = callable;
            if (!targetCallable.isDefinition()) {
                targetCallable = targetCallable.getAssociatedSymbol();
            }
            if (callable instanceof OCMethodSymbol) {
                OCClassSymbol callableParent = (OCClassSymbol)((OCMethodSymbol)callable).getParent();
                if (this.myOriginalClass != null && (targetCallable == null || !Comparing.equal((String)callableParent.getName(), (String)this.myOriginalClass.getName())) && this.myOriginalClass.isSubclass(callableParent)) {
                    CommonProcessors.FindFirstProcessor finder = new CommonProcessors.FindFirstProcessor();
                    this.myOriginalClass.processMembers(callable.getName(), OCMethodSymbol.class, finder);
                    targetCallable = (OCSymbol)finder.getFoundValue();
                }
            }
            if (targetCallable != null && !this.myIvarsInfo.myTraversedCallables.contains(targetCallable) && this.myContainingFile.equals(targetCallable.getContainingFile())) {
                this.myIvarsInfo.myTraversedCallables.add(targetCallable);
                Object definition = targetCallable.locateDefinition();
                if (definition instanceof OCDeclarator) {
                    definition = definition.getParent();
                }
                if (definition instanceof OCCallable) {
                    boolean curDealloc = this.isDealloc;
                    this.isDealloc = false;
                    definition.accept((PsiElementVisitor)this);
                    this.isDealloc = curDealloc;
                }
            }
        }
    }

    public static class IvarsInfo {
        private Set<OCInstanceVariableSymbol> myReleasedIvars = new HashSet<OCInstanceVariableSymbol>();
        private Map<OCInstanceVariableSymbol, Map<OCMethodSymbol, PsiElement>> myLocalReleases = new HashMap<OCInstanceVariableSymbol, Map<OCMethodSymbol, PsiElement>>();
        private Set<OCSymbol> myTraversedCallables = new HashSet<OCSymbol>();
        private Map<OCMethodSymbol, PsiElement> myDeallocs = new HashMap<OCMethodSymbol, PsiElement>();
        private List<Pair<OCInstanceVariableSymbol, PsiElement>> myLocalRetainedIvars = new ArrayList<Pair<OCInstanceVariableSymbol, PsiElement>>();
    }
}

