/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.inspections;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.CheckBox;
import com.jetbrains.cidr.lang.inspections.OCInspections;
import com.jetbrains.cidr.lang.intentions.OCConvertIfToTernaryIntentionAction;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.parser.OCMacroRange;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCBinaryExpression;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCConditionalExpression;
import com.jetbrains.cidr.lang.psi.OCDeclarationOrExpression;
import com.jetbrains.cidr.lang.psi.OCDoWhileStatement;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCEmptyStatement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCForStatement;
import com.jetbrains.cidr.lang.psi.OCIfStatement;
import com.jetbrains.cidr.lang.psi.OCLoopStatement;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.OCParenthesizedExpression;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.psi.OCUnaryExpression;
import com.jetbrains.cidr.lang.psi.OCWhileStatement;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.quickfixes.OCChangeElementIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCRemoveElementsIntentionAction;
import com.jetbrains.cidr.lang.resolve.references.OCOperatorReference;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.types.OCBlockPointerType;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCMagicType;
import com.jetbrains.cidr.lang.types.OCRealType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeUtils;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.util.OCExpressionEvaluator;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCSimplifyInspection
extends OCInspections.GeneralCpp {
    private static Key<Map<PsiElement, Pair<PsiElement, Simplifier>>> SIMPLIFIABLE_ELEMENTS = Key.create((String)"SIMPLIFIABLE_ELEMENTS");
    public boolean enableSimplifyEqualToYesNo = true;
    public boolean enableSimplifyIfWithConstantBranch = false;
    private static Set<String> GOOD_MACROS = ContainerUtil.set((Object[])new String[]{"YES", "NO", "true", "false", "TRUE", "FALSE"});

    public JComponent createOptionsPanel() {
        JPanel panel2 = new JPanel((LayoutManager)new VerticalFlowLayout());
        CheckBox checkBox1 = new CheckBox("Simplify \"condition == true\"", (InspectionProfileEntry)this, "enableSimplifyEqualToYesNo");
        CheckBox checkBox2 = new CheckBox("Simplify \"condition1 ? true : condition2\"", (InspectionProfileEntry)this, "enableSimplifyIfWithConstantBranch");
        panel2.add((Component)checkBox1);
        panel2.add((Component)checkBox2);
        return panel2;
    }

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        return "Simplifiable statement";
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session2) {
        final HashMap map2 = new HashMap();
        session2.putUserData(SIMPLIFIABLE_ELEMENTS, map2);
        return new SimplifyVisitor(){

            @Override
            protected void simplify(@NotNull PsiElement element, PsiElement simplified, Simplifier simplifier) {
                if (simplified != null) {
                    map2.put(element, Pair.create((Object)simplified, (Object)simplifier));
                }
            }
        };
    }

    public static void simplify(PsiElement element) {
        element.accept((PsiElementVisitor)new SimplifyVisitor(){

            @Override
            protected void simplify(@NotNull PsiElement element, @Nullable PsiElement simplified, Simplifier simplifier) {
                if (simplified != null) {
                    OCSimplifyInspection.getSimplifyFix(element, simplified).invoke(element.getProject(), null, element.getContainingFile());
                } else {
                    this.visitElement(element);
                }
            }

            public void visitElement(PsiElement element) {
                for (PsiElement child : element.getChildren()) {
                    child.accept((PsiElementVisitor)this);
                }
            }
        });
    }

    public void inspectionFinished(@NotNull LocalInspectionToolSession session2, @NotNull ProblemsHolder problemsHolder) {
        Map map2 = (Map)session2.getUserData(SIMPLIFIABLE_ELEMENTS);
        assert (map2 != null);
        block0: for (PsiElement element : map2.keySet()) {
            if (OCElementUtil.isPartOfMacroSubstitution(element)) continue;
            for (PsiElement parent = element.getParent(); parent != null; parent = parent.getParent()) {
                Pair parentInspection = (Pair)map2.get(parent);
                if (parentInspection != null && !((Simplifier)parentInspection.getSecond()).isWarningDisabled(this)) continue block0;
            }
            Pair pair = (Pair)map2.get(element);
            PsiElement simplified = (PsiElement)pair.getFirst();
            OCDeclarationOrExpression warningElement = element instanceof OCIfStatement ? ((OCIfStatement)element).getCondition() : (element instanceof OCLoopStatement ? ((OCLoopStatement)element).getCondition() : element);
            String message2 = OCSimplifyInspection.getSimplifyMessage(element, simplified);
            IntentionAction fix = OCSimplifyInspection.getSimplifyFix(element, simplified);
            ProblemHighlightType highlightType = ((Simplifier)pair.getSecond()).isWarningDisabled(this) ? ProblemHighlightType.INFORMATION : ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
            this.registerProblem(problemsHolder, null, null, problemsHolder.isOnTheFly(), warningElement, message2, "CIDR", highlightType, fix);
        }
    }

    public static String getSimplifyMessage(PsiElement element, PsiElement simplified) {
        if (element instanceof OCIfStatement) {
            OCStatement thenBranch = ((OCIfStatement)element).getThenBranch();
            OCStatement elseBranch = ((OCIfStatement)element).getElseBranch();
            if (simplified == thenBranch) {
                return thenBranch != null && elseBranch != null && OCElementUtil.areElementsEquivalent(thenBranch, elseBranch, false, new OCResolveContext(element)) ? "'if' statement has identical branches" : "Condition is always true";
            }
            if (simplified == elseBranch || simplified instanceof OCEmptyStatement) {
                return "Condition is always false";
            }
            return "Statement can be simplified";
        }
        if (element instanceof OCLoopStatement) {
            return "Condition is always false";
        }
        return "Expression can be simplified to '" + OCElementUtil.getTextWithMacros(simplified) + "'";
    }

    public static IntentionAction getSimplifyFix(final PsiElement element, final PsiElement simplified) {
        final String subject = OCSimplifyInspection.getStatementName(element);
        if (element instanceof OCStatement && element.getParent() instanceof OCBlockStatement && simplified instanceof OCBlockStatement) {
            return new OCChangeElementIntentionAction(element, ((OCBlockStatement)simplified).getStatements(), "Simplify " + subject);
        }
        if (simplified instanceof OCEmptyStatement) {
            return new OCRemoveElementsIntentionAction(element, "Remove " + subject);
        }
        if (simplified instanceof OCExpression && element instanceof OCIfStatement) {
            return new OCConvertIfToTernaryIntentionAction(){

                @Override
                @NotNull
                public String getText() {
                    return "Simplify " + subject;
                }

                @Override
                protected OCConvertIfToTernaryIntentionAction.Converter createConverter(PsiElement fakeElement) {
                    return new OCConvertIfToTernaryIntentionAction.Converter(this, element);
                }

                @Override
                protected OCExpression getNewExpression(OCConvertIfToTernaryIntentionAction.Converter converter) {
                    return (OCExpression)simplified;
                }
            };
        }
        return new OCChangeElementIntentionAction(element, simplified, "Simplify " + (element instanceof OCExpression ? "expression" : subject));
    }

    private static String getStatementName(PsiElement element) {
        if (element instanceof OCIfStatement) {
            return "'if' statement";
        }
        if (element instanceof OCWhileStatement) {
            return "'while' statement";
        }
        if (element instanceof OCDoWhileStatement) {
            return "'do-while' statement";
        }
        if (element instanceof OCForStatement) {
            return "'for' statement";
        }
        return "statement";
    }

    @Nullable
    public static OCStatement simplifyStatementWithConstCondition(boolean conditionValue, @NotNull OCStatement statement2) {
        if (statement2 instanceof OCIfStatement) {
            OCStatement thenBranch = ((OCIfStatement)statement2).getThenBranch();
            OCStatement elseBranch = ((OCIfStatement)statement2).getElseBranch();
            return conditionValue ? thenBranch : (elseBranch != null ? elseBranch : OCSimplifyInspection.createEmptyStatement(statement2));
        }
        if (statement2 instanceof OCWhileStatement) {
            return conditionValue ? null : OCSimplifyInspection.createEmptyStatement(statement2);
        }
        if (statement2 instanceof OCDoWhileStatement) {
            return conditionValue ? null : ((OCDoWhileStatement)statement2).getBody();
        }
        if (statement2 instanceof OCForStatement) {
            OCStatement initializer = ((OCForStatement)statement2).getInitializer();
            return conditionValue ? null : (initializer != null ? initializer : OCSimplifyInspection.createEmptyStatement(statement2));
        }
        throw new UnsupportedOperationException(statement2.getClass().getCanonicalName());
    }

    @Nullable
    public static OCExpression simplifyLogicExpression(boolean conditionValue, @NotNull OCBinaryExpression expression2, PsiElement element) {
        OCExpression otherOperand;
        OCElementType sign = expression2.getOperationSign();
        if (PsiTreeUtil.isAncestor((PsiElement)expression2.getLeft(), (PsiElement)element, (boolean)false)) {
            otherOperand = expression2.getRight();
        } else if (PsiTreeUtil.isAncestor((PsiElement)expression2.getRight(), (PsiElement)element, (boolean)false)) {
            otherOperand = expression2.getLeft();
        } else {
            return null;
        }
        return Simplifier.trySimplifyLogicExpression(conditionValue, expression2.getLeft(), otherOperand, sign);
    }

    private static OCStatement createEmptyStatement(PsiElement context) {
        return OCElementFactory.statementFromText(";", context);
    }

    @Nullable
    private static OCExpression simplify(@Nullable OCExpression expression2) {
        OCExpression simplified = null;
        if (expression2 == null || OCSimplifyInspection.isOverloadedOperatorUsage(expression2)) {
            return expression2;
        }
        if (expression2 instanceof OCConditionalExpression) {
            OCConditionalExpression condExpr = (OCConditionalExpression)expression2;
            simplified = new Simplifier().trySimplifyCondExpr(condExpr.getCondition(), condExpr.getPositiveExpression(true), condExpr.getNegativeExpression());
        } else if (expression2 instanceof OCBinaryExpression) {
            OCBinaryExpression binaryExpr = (OCBinaryExpression)expression2;
            simplified = new Simplifier().trySimplifyBinaryExpr(binaryExpr);
        } else if (expression2 instanceof OCUnaryExpression) {
            OCUnaryExpression unaryExpression = (OCUnaryExpression)expression2;
            simplified = Simplifier.trySimplifyUnaryExpr(unaryExpression);
        } else if (expression2 instanceof OCParenthesizedExpression && !OCElementUtil.isPartOfMacroSubstitution(expression2)) {
            simplified = OCSimplifyInspection.simplify(((OCParenthesizedExpression)expression2).getOperand());
        }
        return simplified != null ? simplified : expression2;
    }

    private static boolean hasMacros(PsiElement element) {
        for (PsiElement child : element.getChildren()) {
            if ((!(child instanceof OCMacroCall) || GOOD_MACROS.contains(((OCMacroCall)child).getTextWithMacros())) && !OCSimplifyInspection.hasMacros(child)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private static <T> T nullIfHasMacros(T value2, PsiElement element) {
        OCMacroRange range;
        if (OCElementUtil.isPartOfMacroSubstitution(element) && (range = OCElementUtil.getRangeInMacroCall(element)) != null && range.getMacroCall() != null && !GOOD_MACROS.contains(range.getMacroCall().getTextWithMacros())) {
            return null;
        }
        return OCSimplifyInspection.hasMacros(element) ? null : (T)value2;
    }

    private static boolean isOverloadedOperatorUsage(@NotNull OCExpression expr) {
        PsiReference reference = expr.getReference();
        return reference instanceof OCOperatorReference && !((OCOperatorReference)reference).resolveToSymbols().isEmpty();
    }

    private static class Simplifier {
        private boolean equalToYesNoUsed;
        private boolean ifWithConstBranchUsed;

        private Simplifier() {
        }

        public boolean isWarningDisabled(OCSimplifyInspection inspection) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                return false;
            }
            return this.equalToYesNoUsed && !inspection.enableSimplifyEqualToYesNo || this.ifWithConstBranchUsed && !inspection.enableSimplifyIfWithConstantBranch;
        }

        @Nullable
        private PsiElement trySimplifyIfStatement(@NotNull OCIfStatement statement2) {
            OCExpression expression2;
            OCDeclarationOrExpression condition2 = statement2.getCondition();
            OCExpression oCExpression = expression2 = condition2 != null ? condition2.getExpression() : null;
            if (expression2 == null || OCElementUtil.isPartOfMacroSubstitution(expression2)) {
                return null;
            }
            OCStatement thenBranch = statement2.getThenBranch();
            OCStatement elseBranch = statement2.getElseBranch();
            Number conditionValue = (Number)OCSimplifyInspection.nullIfHasMacros(OCExpressionEvaluator.evaluate(expression2), condition2);
            if (conditionValue != null) {
                return OCSimplifyInspection.simplifyStatementWithConstCondition(OCExpressionEvaluator.singAsInC(conditionValue) != 0, statement2);
            }
            if (thenBranch != null && elseBranch != null && OCElementUtil.areElementsEquivalent(thenBranch, elseBranch, false, new OCResolveContext(statement2)) && !OCCodeInsightUtil.hasSideEffects(condition2)) {
                return thenBranch;
            }
            OCConvertIfToTernaryIntentionAction oCConvertIfToTernaryIntentionAction = new OCConvertIfToTernaryIntentionAction();
            ((Object)((Object)oCConvertIfToTernaryIntentionAction)).getClass();
            OCConvertIfToTernaryIntentionAction.Converter converter = new OCConvertIfToTernaryIntentionAction.Converter(oCConvertIfToTernaryIntentionAction, condition2);
            if (!converter.isAvailable()) {
                return null;
            }
            return this.trySimplifyCondExpr(converter.getCondition(), converter.getThenExpression(), converter.getElseExpression());
        }

        private static PsiElement trySimplifyLoopStatement(@NotNull OCLoopStatement statement2) {
            PsiElement condition2 = statement2.getCondition();
            if (condition2 instanceof OCDeclarationOrExpression) {
                condition2 = ((OCDeclarationOrExpression)condition2).getExpression();
            }
            if (!(condition2 instanceof OCExpression) || OCElementUtil.isPartOfMacroSubstitution(condition2)) {
                return null;
            }
            Number conditionValue = (Number)OCSimplifyInspection.nullIfHasMacros(OCExpressionEvaluator.evaluate((OCExpression)condition2), condition2);
            if (conditionValue != null) {
                return OCSimplifyInspection.simplifyStatementWithConstCondition(OCExpressionEvaluator.singAsInC(conditionValue) > 0, statement2);
            }
            return null;
        }

        @Nullable
        private OCExpression trySimplifyCondExpr(@Nullable OCExpression condition2, @Nullable OCExpression thenBranch, @Nullable OCExpression elseBranch) {
            if (condition2 == null || thenBranch == null || elseBranch == null) {
                return null;
            }
            Number conditionValue = (Number)OCSimplifyInspection.nullIfHasMacros(OCExpressionEvaluator.evaluate(condition2), condition2);
            if (conditionValue != null) {
                return OCSimplifyInspection.simplify(OCExpressionEvaluator.singAsInC(conditionValue) != 0 ? thenBranch : elseBranch);
            }
            OCResolveContext resolveContext = new OCResolveContext(condition2);
            if (OCParenthesesUtils.areExpressionsEquivalent(thenBranch, elseBranch, false, resolveContext) && !OCCodeInsightUtil.hasSideEffects(condition2)) {
                return OCSimplifyInspection.simplify(thenBranch);
            }
            if (OCParenthesesUtils.areExpressionsOpposite(thenBranch, elseBranch, false, resolveContext)) {
                return Simplifier.binaryExpr(Simplifier.ensureIsBoolean(condition2), thenBranch, OCTokenTypes.EQEQ);
            }
            if (OCTypeUtils.isInstanceOfType(thenBranch, resolveContext, OCMagicType.class, OCStructType.class) || OCTypeUtils.isInstanceOfType(elseBranch, resolveContext, OCMagicType.class, OCStructType.class)) {
                return null;
            }
            Object thenValue = OCSimplifyInspection.nullIfHasMacros(OCExpressionEvaluator.evaluateToIntOrBoolean(thenBranch), thenBranch);
            Object elseValue = OCSimplifyInspection.nullIfHasMacros(OCExpressionEvaluator.evaluateToIntOrBoolean(elseBranch), elseBranch);
            if (thenValue instanceof Boolean) {
                boolean bl = this.ifWithConstBranchUsed = !(elseValue instanceof Boolean);
                if (((Boolean)thenValue).booleanValue()) {
                    return Simplifier.binaryExpr(Simplifier.ensureIsBoolean(condition2), elseBranch, OCTokenTypes.OROR);
                }
                return Simplifier.binaryExpr(Simplifier.negateExpr(Simplifier.ensureIsBoolean(condition2)), elseBranch, OCTokenTypes.ANDAND);
            }
            if (elseValue instanceof Boolean) {
                this.ifWithConstBranchUsed = true;
                if (((Boolean)elseValue).booleanValue()) {
                    return Simplifier.binaryExpr(Simplifier.negateExpr(Simplifier.ensureIsBoolean(condition2)), thenBranch, OCTokenTypes.OROR);
                }
                return Simplifier.binaryExpr(Simplifier.ensureIsBoolean(condition2), thenBranch, OCTokenTypes.ANDAND);
            }
            return null;
        }

        @Nullable
        private OCExpression trySimplifyBinaryExpr(@NotNull OCBinaryExpression expression2) {
            OCExpression otherOperand;
            boolean condition2;
            OCExpression left = expression2.getLeft();
            OCExpression right = expression2.getRight();
            OCElementType operatorSign = expression2.getOperationSign();
            if (left == null || right == null) {
                return null;
            }
            OCResolveContext resolveContext = new OCResolveContext(left.getContext());
            OCType leftType = OCTypeUtils.getResolvedCppReferencedType(left, resolveContext);
            OCType rightType = OCTypeUtils.getResolvedCppReferencedType(right, resolveContext);
            if (OCTypeUtils.isInstanceOfType(leftType, OCMagicType.class, OCStructType.class) || OCTypeUtils.isInstanceOfType(rightType, OCMagicType.class, OCStructType.class)) {
                return null;
            }
            if (OCParenthesesUtils.areExpressionsEquivalent(left, right, false, resolveContext) && !OCCodeInsightUtil.hasSideEffects(left) && !(leftType instanceof OCRealType)) {
                if (operatorSign == OCTokenTypes.ANDAND || operatorSign == OCTokenTypes.OROR) {
                    return Simplifier.ensureIsBoolean(OCSimplifyInspection.simplify(left));
                }
                if (operatorSign == OCTokenTypes.AND || operatorSign == OCTokenTypes.OR) {
                    return OCSimplifyInspection.simplify(left);
                }
                if (operatorSign == OCTokenTypes.XOR || operatorSign == OCTokenTypes.EXCLEQ) {
                    return Simplifier.constFalse(left);
                }
                if (operatorSign == OCTokenTypes.EQEQ) {
                    return Simplifier.constTrue(left);
                }
            }
            if (OCParenthesesUtils.areExpressionsOpposite(left, right, false, resolveContext) && !OCCodeInsightUtil.hasSideEffects(left)) {
                if (operatorSign == OCTokenTypes.OROR || operatorSign == OCTokenTypes.XOR || operatorSign == OCTokenTypes.EXCLEQ) {
                    return Simplifier.constTrue(left);
                }
                if (operatorSign == OCTokenTypes.ANDAND || operatorSign == OCTokenTypes.EQEQ) {
                    return Simplifier.constFalse(left);
                }
            }
            Object leftValue = OCSimplifyInspection.nullIfHasMacros(OCExpressionEvaluator.evaluateToIntOrBoolean(left), left);
            Object rightValue = OCSimplifyInspection.nullIfHasMacros(OCExpressionEvaluator.evaluateToIntOrBoolean(right), right);
            if (leftValue instanceof Boolean) {
                condition2 = (Boolean)leftValue;
                otherOperand = right;
            } else if (rightValue instanceof Boolean) {
                condition2 = (Boolean)rightValue;
                otherOperand = left;
            } else if (leftValue instanceof Number && OCTokenTypes.LOGIC_OPERATIONS.contains((IElementType)operatorSign)) {
                condition2 = OCExpressionEvaluator.singAsInC(leftValue) != 0;
                otherOperand = right;
            } else if (rightValue instanceof Number && OCTokenTypes.LOGIC_OPERATIONS.contains((IElementType)operatorSign)) {
                condition2 = OCExpressionEvaluator.singAsInC(rightValue) != 0;
                otherOperand = left;
            } else {
                return null;
            }
            if (operatorSign == OCTokenTypes.EQEQ || operatorSign == OCTokenTypes.EXCLEQ) {
                this.equalToYesNoUsed = true;
            }
            return Simplifier.trySimplifyLogicExpression(condition2, left, otherOperand, operatorSign);
        }

        private static OCExpression trySimplifyLogicExpression(boolean condition2, OCExpression left, OCExpression otherOperand, OCElementType operator2) {
            OCResolveContext resolveContext = new OCResolveContext(otherOperand);
            if (OCTypeUtils.isInstanceOfType(otherOperand, resolveContext, OCMagicType.class, OCStructType.class)) {
                return null;
            }
            if (condition2) {
                if (operator2 == OCTokenTypes.ANDAND || operator2 == OCTokenTypes.AND || operator2 == OCTokenTypes.EQEQ) {
                    return Simplifier.ensureIsBoolean(OCSimplifyInspection.simplify(otherOperand));
                }
                if (!(operator2 != OCTokenTypes.OROR && operator2 != OCTokenTypes.OR || otherOperand == left && OCCodeInsightUtil.hasSideEffects(left))) {
                    return Simplifier.constTrue(left);
                }
                if (operator2 == OCTokenTypes.XOR || operator2 == OCTokenTypes.EXCLEQ) {
                    return Simplifier.negateExpr(Simplifier.ensureIsBoolean(otherOperand));
                }
            } else {
                if (!(operator2 != OCTokenTypes.ANDAND && operator2 != OCTokenTypes.AND || otherOperand == left && OCCodeInsightUtil.hasSideEffects(left))) {
                    return Simplifier.constFalse(left);
                }
                if (operator2 == OCTokenTypes.OROR || operator2 == OCTokenTypes.XOR || operator2 == OCTokenTypes.EXCLEQ) {
                    return Simplifier.ensureIsBoolean(OCSimplifyInspection.simplify(otherOperand));
                }
                if (operator2 == OCTokenTypes.EQEQ) {
                    return Simplifier.negateExpr(Simplifier.ensureIsBoolean(otherOperand));
                }
            }
            return null;
        }

        @Nullable
        private static OCExpression trySimplifyUnaryExpr(@NotNull OCUnaryExpression expression2) {
            OCExpression operand2 = expression2.getOperand();
            if (operand2 == null || expression2.getOperationSign() != OCTokenTypes.EXCL) {
                return null;
            }
            Number value2 = (Number)OCSimplifyInspection.nullIfHasMacros(OCExpressionEvaluator.evaluate(operand2), operand2);
            if (value2 != null) {
                return OCExpressionEvaluator.singAsInC(value2) != 0 ? Simplifier.constFalse(operand2) : Simplifier.constTrue(operand2);
            }
            if ((operand2 = OCParenthesesUtils.diveIntoParentheses(operand2)) == null || OCElementUtil.isPartOfMacroSubstitution(operand2)) {
                return null;
            }
            OCResolveContext resolveContext = new OCResolveContext(operand2);
            if (operand2 instanceof OCUnaryExpression) {
                OCUnaryExpression unaryExpression = (OCUnaryExpression)operand2;
                boolean hasMagicOrStructTypeArgument = OCTypeUtils.isInstanceOfType(unaryExpression.getOperand(), resolveContext, OCMagicType.class, OCStructType.class);
                if (unaryExpression.getOperationSign() == OCTokenTypes.EXCL && !hasMagicOrStructTypeArgument) {
                    return OCSimplifyInspection.simplify(Simplifier.ensureIsBoolean(unaryExpression.getOperand()));
                }
            } else if (operand2 instanceof OCBinaryExpression && !OCSimplifyInspection.isOverloadedOperatorUsage(operand2)) {
                OCBinaryExpression binaryExpr = (OCBinaryExpression)operand2;
                boolean hasMagicOrStructTypeArguments = OCTypeUtils.isInstanceOfType(binaryExpr.getLeft(), resolveContext, OCMagicType.class, OCStructType.class) || OCTypeUtils.isInstanceOfType(binaryExpr.getRight(), resolveContext, OCMagicType.class, OCStructType.class);
                OCElementType oppositeOperator = OCCodeInsightUtil.getOppositeOperator(binaryExpr.getOperationSign());
                if (oppositeOperator != null && !hasMagicOrStructTypeArguments) {
                    return Simplifier.binaryExpr(binaryExpr.getLeft(), binaryExpr.getRight(), oppositeOperator);
                }
            }
            return null;
        }

        @Nullable
        private static OCExpression simplifyAndParenthesize(OCExpression expression2, int parentPrecedence) {
            if (expression2 == null || OCElementUtil.isPartOfMacroSubstitution(expression2)) {
                return expression2;
            }
            if ((expression2 = OCSimplifyInspection.simplify(expression2)) != null && OCParenthesesUtils.getPrecedence(expression2, false) > parentPrecedence) {
                return OCParenthesesUtils.appendParentheses(expression2);
            }
            return expression2;
        }

        @Nullable
        private static OCExpression binaryExpr(@Nullable OCExpression left, @Nullable OCExpression right, @Nullable OCElementType operator2) {
            if (left == null || right == null) {
                return null;
            }
            int precedence = OCParenthesesUtils.getPrecedence(operator2);
            left = Simplifier.simplifyAndParenthesize(left, precedence);
            right = Simplifier.simplifyAndParenthesize(right, precedence);
            return OCSimplifyInspection.simplify(OCElementFactory.binaryExpression(left, right, operator2));
        }

        @Nullable
        private static OCExpression negateExpr(@Nullable OCExpression operand2) {
            if (operand2 == null) {
                return null;
            }
            operand2 = Simplifier.simplifyAndParenthesize(operand2, OCParenthesesUtils.getPrecedence(OCTokenTypes.EXCL));
            return OCSimplifyInspection.simplify(OCElementFactory.unaryExpression(operand2, OCTokenTypes.EXCL));
        }

        private static OCExpression constTrue(OCElement context) {
            return OCElementFactory.booleanConstant(true, context);
        }

        private static OCExpression constFalse(OCElement context) {
            return OCElementFactory.booleanConstant(false, context);
        }

        @Nullable
        private static OCExpression ensureIsBoolean(OCExpression expression2) {
            if (expression2 == null) {
                return null;
            }
            OCType type2 = expression2.getResolvedType();
            if (OCIntType.isBool(type2, expression2)) {
                return expression2;
            }
            if (type2 instanceof OCStructType || type2 instanceof OCCppReferenceType || type2 instanceof OCBlockPointerType) {
                return null;
            }
            return Simplifier.binaryExpr(expression2, OCElementFactory.expressionFromText(type2.getDefaultValue(expression2), expression2, false), OCTokenTypes.EXCLEQ);
        }
    }

    private static abstract class SimplifyVisitor
    extends OCVisitor {
        private SimplifyVisitor() {
        }

        @Override
        public void visitConditionalExpression(OCConditionalExpression expression2) {
            if (OCElementUtil.insideDirective(expression2)) {
                return;
            }
            Simplifier simplifier = new Simplifier();
            OCExpression simplified = simplifier.trySimplifyCondExpr(expression2.getCondition(), expression2.getPositiveExpression(true), expression2.getNegativeExpression());
            this.simplifyAndParenthesize(expression2, simplified, simplifier);
        }

        @Override
        public void visitIfStatement(OCIfStatement stmt) {
            Simplifier simplifier = new Simplifier();
            PsiElement simplified = simplifier.trySimplifyIfStatement(stmt);
            this.simplifyAndParenthesize(stmt, simplified, simplifier);
        }

        @Override
        public void visitWhileStatement(OCWhileStatement stmt) {
            this.simplify(stmt, Simplifier.trySimplifyLoopStatement(stmt), new Simplifier());
        }

        @Override
        public void visitDoWhileStatement(OCDoWhileStatement stmt) {
            this.simplify(stmt, Simplifier.trySimplifyLoopStatement(stmt), new Simplifier());
        }

        @Override
        public void visitForStatement(OCForStatement stmt) {
            this.simplify(stmt, Simplifier.trySimplifyLoopStatement(stmt), new Simplifier());
        }

        @Override
        public void visitBinaryExpression(OCBinaryExpression expression2) {
            if (OCElementUtil.insideDirective(expression2) || OCSimplifyInspection.isOverloadedOperatorUsage(expression2)) {
                return;
            }
            Simplifier simplifier = new Simplifier();
            OCExpression simplified = simplifier.trySimplifyBinaryExpr(expression2);
            this.simplifyAndParenthesize(expression2, simplified, simplifier);
        }

        @Override
        public void visitUnaryExpression(OCUnaryExpression expression2) {
            if (OCElementUtil.insideDirective(expression2) || OCSimplifyInspection.isOverloadedOperatorUsage(expression2)) {
                return;
            }
            Simplifier simplifier = new Simplifier();
            OCExpression simplified = Simplifier.trySimplifyUnaryExpr(expression2);
            this.simplifyAndParenthesize(expression2, simplified, simplifier);
        }

        private void simplifyAndParenthesize(@NotNull PsiElement element, @Nullable PsiElement simplified, Simplifier simplifier) {
            PsiElement parent = element.getParent();
            while (parent instanceof OCParenthesizedExpression && simplified instanceof OCExpression && !OCParenthesesUtils.isParenthesesNeededInReplacing((OCExpression)parent, (OCExpression)simplified)) {
                element = parent;
                parent = parent.getParent();
            }
            if (element instanceof OCExpression && simplified instanceof OCExpression && OCParenthesesUtils.isParenthesesNeededInReplacing((OCExpression)element, (OCExpression)simplified)) {
                this.simplify(element, OCParenthesesUtils.appendParentheses((OCExpression)simplified), simplifier);
            } else {
                this.simplify(element, simplified, simplifier);
            }
        }

        protected abstract void simplify(@NotNull PsiElement var1, @Nullable PsiElement var2, Simplifier var3);
    }
}

