/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.inspections;

import com.intellij.codeInsight.daemon.ImplicitUsageProvider;
import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.util.CommonProcessors;
import com.intellij.util.ExecutorsQuery;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.jetbrains.cidr.lang.OCTestFrameworks;
import com.jetbrains.cidr.lang.inspections.OCGlobalSearchScopeForUnusedCode;
import com.jetbrains.cidr.lang.inspections.OCGlobalUnusedInspection;
import com.jetbrains.cidr.lang.inspections.OCInspection;
import com.jetbrains.cidr.lang.psi.OCClassDeclarationBase;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDefineDirective;
import com.jetbrains.cidr.lang.psi.OCExternalReference;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.psi.OCSynthesizeProperty;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.quickfixes.OCChangeGCCAttributeIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCRemoveElementsIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCSafeDeleteIntentionAction;
import com.jetbrains.cidr.lang.refactoring.OCNameSuggester;
import com.jetbrains.cidr.lang.refactoring.OCSafeDeleteProcessorDelegate;
import com.jetbrains.cidr.lang.search.OCElementInMacroAndNonCompiledCodeReferencesSearch;
import com.jetbrains.cidr.lang.search.OCPropertyReferencesSearch;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.search.usages.OCReadWriteAccessDetector;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolHolderVirtualPsiElement;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCMacroSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCImplementationSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.util.OCCommonProcessors;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCUnusedCodeInspection
extends OCInspection.Cpp {
    @Nullable
    public UnusedVisitor buildVisitor() {
        return null;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        UnusedVisitor visitor;
        if (isOnTheFly && (visitor = this.buildVisitor()) != null) {
            visitor.setHolder(holder);
            visitor.setOnTheFly(isOnTheFly);
            return visitor;
        }
        return new OCVisitor();
    }

    public static boolean isWritableSymbol(OCSymbol symbol) {
        return symbol instanceof OCDeclaratorSymbol || symbol instanceof OCPropertySymbol || symbol instanceof OCInstanceVariableSymbol;
    }

    @Override
    public String getMainToolId() {
        String toolId = super.getMainToolId();
        return toolId != null ? toolId : new OCGlobalUnusedInspection().getShortName();
    }

    public class UnusedVisitor
    extends OCVisitor {
        private OCSymbol mySymbol;
        protected boolean myOnTheFly;
        protected boolean myHasWrites;
        @Nullable
        private ProblemsHolder myHolder;
        @Nullable
        private ProblemDescriptionsProcessor myProcessor;
        @Nullable
        private GlobalInspectionContext myGlobalContext;
        @Nullable
        protected SearchScope myScope;

        public void setUpForBatchMode(ProblemDescriptionsProcessor processor2, GlobalInspectionContext globalContext, SearchScope scope) {
            this.myProcessor = processor2;
            this.myGlobalContext = globalContext;
            this.myScope = scope;
            this.myOnTheFly = false;
        }

        public void checkFromBatchMode(@NotNull OCSymbol symbol, @NotNull PsiElement declarator, boolean hasWrites) {
            this.mySymbol = symbol;
            this.myHasWrites = hasWrites;
            declarator.accept((PsiElementVisitor)this);
        }

        public void setHolder(@Nullable ProblemsHolder holder) {
            this.myHolder = holder;
        }

        public void setOnTheFly(boolean onTheFly) {
            this.myOnTheFly = onTheFly;
        }

        @Nullable
        protected OCSymbol getSymbol(OCSymbolDeclarator declarator) {
            return this.mySymbol != null ? this.mySymbol : declarator.getSymbol();
        }

        protected void registerProblem(@Nullable PsiElement element, String message2, ProblemHighlightType highlightType, IntentionAction ... quickFixes) {
            OCUnusedCodeInspection.this.registerProblem(this.myHolder, this.myProcessor, this.myGlobalContext, this.myOnTheFly, element, message2, "CIDR", highlightType, quickFixes);
        }

        protected void registerProblems(@Nullable List<PsiElement> elements, String message2, ProblemHighlightType highlightType, IntentionAction ... quickFixes) {
            OCUnusedCodeInspection.this.registerProblems(this.myHolder, this.myProcessor, this.myGlobalContext, this.myOnTheFly, elements, message2, "CIDR", highlightType, quickFixes);
        }

        protected void checkSymbolUsed(PsiElement element, OCSymbol symbol) {
            this.checkSymbolUsed(element, element, symbol, false);
        }

        protected void checkSymbolUsed(PsiElement element, OCSymbol symbol, boolean hasWrites) {
            this.checkSymbolUsed(element, element, symbol, hasWrites);
        }

        protected void checkSymbolUsed(PsiElement element, PsiElement navigationElement, OCSymbol symbol, boolean hasWrites) {
            if (element == null || navigationElement == null) {
                return;
            }
            OCFile.UnusedChecksMode checksMode = (OCFile.UnusedChecksMode)((Object)element.getProject().getUserData(OCFile.UNUSED_CHECKS));
            if (symbol == null || checksMode == OCFile.UnusedChecksMode.DISABLED || symbol.hasAttribute("unused") || symbol.hasAttribute("used")) {
                return;
            }
            for (ImplicitUsageProvider usageProvider : (ImplicitUsageProvider[])Extensions.getExtensions((ExtensionPointName)ImplicitUsageProvider.EP_NAME)) {
                if (usageProvider.isImplicitUsage(element) || usageProvider.isImplicitRead(element)) {
                    return;
                }
                hasWrites |= usageProvider.isImplicitWrite(element);
            }
            PsiFile containingFile = element.getContainingFile();
            SearchScope scope = this.myScope;
            if (scope == null) {
                scope = checksMode == OCFile.UnusedChecksMode.IN_LOCAL_FILE ? new LocalSearchScope((PsiElement)containingFile) : new OCGlobalSearchScopeForUnusedCode(OCSearchScope.getProjectSourcesScope(element.getProject()));
            }
            CommonProcessors.FindFirstProcessor finder = new CommonProcessors.FindFirstProcessor();
            String subject = symbol.getNameWithKindUppercase();
            OCRemoveElementsIntentionAction quickFix = new OCSafeDeleteIntentionAction((PsiElement)element, StringUtil.decapitalize((String)subject));
            boolean isAccessorMethod = false;
            if (symbol.getKind() == OCSymbolKind.INSTANCE_VARIABLE) {
                scope = this.getIvarScope((OCInstanceVariableSymbol)symbol, scope);
            } else if (symbol.getKind() == OCSymbolKind.PROPERTY) {
                final PsiElement accessor = element;
                finder = new CommonProcessors.FindFirstProcessor<PsiReference>(){

                    protected boolean accept(PsiReference reference) {
                        PsiElement element = reference.getElement();
                        if (element != null && element.getParent() instanceof OCSynthesizeProperty) {
                            return false;
                        }
                        if (reference instanceof OCExternalReference) {
                            return true;
                        }
                        return !(accessor instanceof OCMethod) || reference.isReferenceTo(accessor);
                    }
                };
                if (element instanceof OCMethod) {
                    subject = (OCNameSuggester.isObjCSetter(((OCMethod)element).getSelector()) ? "Setter" : "Getter") + " method for " + symbol.getNameWithKindLowercase();
                    quickFix = new OCRemoveElementsIntentionAction((PsiElement)element, "Delete " + StringUtil.decapitalize((String)subject), "Delete method");
                    element = symbol.locateDefinition();
                    isAccessorMethod = true;
                    if (element == null) {
                        return;
                    }
                }
            } else {
                if (symbol instanceof OCClassSymbol && OCTestFrameworks.isTestClass(symbol)) {
                    return;
                }
                if (symbol.getKind() == OCSymbolKind.STRUCT) {
                    final PsiElement struct = element;
                    finder = new CommonProcessors.FindFirstProcessor<PsiReference>(){

                        protected boolean accept(PsiReference reference) {
                            return !OCSafeDeleteProcessorDelegate.isSafeToDelete(reference.getElement(), struct);
                        }
                    };
                    if (element.getParent().getParent() instanceof OCDeclaration && ((OCDeclaration)element.getParent().getParent()).isTypedef()) {
                        return;
                    }
                } else {
                    if (symbol.getKind() == OCSymbolKind.ENUM) {
                        return;
                    }
                    if (symbol.getKind() == OCSymbolKind.TYPEDEF && symbol.getType() instanceof OCStructType && ((OCStructType)symbol.getType()).getKind() == OCSymbolKind.ENUM) {
                        return;
                    }
                }
            }
            if (!OCSearchScope.isInProjectSources(symbol)) {
                return;
            }
            if (scope instanceof GlobalSearchScope && PsiSearchHelper.SERVICE.getInstance((Project)element.getProject()).isCheapEnoughToSearch(symbol.getName(), (GlobalSearchScope)scope, containingFile, null) == PsiSearchHelper.SearchCostResult.TOO_MANY_OCCURRENCES) {
                return;
            }
            Ref hasWritesRef = new Ref((Object)hasWrites);
            if (scope != null) {
                ReferencesSearch.SearchParameters searchParameters = new ReferencesSearch.SearchParameters(element, scope, false);
                if (this.findReferences(symbol, (Query<PsiReference>)ReferencesSearch.search((ReferencesSearch.SearchParameters)searchParameters), (CommonProcessors.FindFirstProcessor<PsiReference>)finder, (Ref<Boolean>)hasWritesRef)) {
                    return;
                }
                if (symbol.getKind() == OCSymbolKind.PROPERTY && this.performAuxPropertySearches((OCPropertySymbol)symbol, scope, (CommonProcessors.FindFirstProcessor<PsiReference>)finder, searchParameters, (Ref<Boolean>)hasWritesRef)) {
                    return;
                }
                CommonProcessors.FindFirstProcessor macroFinder = new CommonProcessors.FindFirstProcessor();
                ReferencesSearch.SearchParameters macroParameters = new ReferencesSearch.SearchParameters(element, (SearchScope)OCSearchScope.getProjectSourcesScope(element.getProject()), false);
                new OCElementInMacroAndNonCompiledCodeReferencesSearch().execute(macroParameters, (Processor<OCElementInMacroAndNonCompiledCodeReferencesSearch.Usage>)macroFinder);
                if (macroFinder.isFound()) {
                    return;
                }
            }
            if (isAccessorMethod && ((Boolean)hasWritesRef.get()).booleanValue()) {
                return;
            }
            if (navigationElement instanceof PsiNameIdentifierOwner && !(navigationElement instanceof OCDefineDirective)) {
                navigationElement = ((PsiNameIdentifierOwner)navigationElement).getNameIdentifier();
            }
            if (navigationElement != null) {
                String message2 = subject + ((Boolean)hasWritesRef.get() != false ? " is assigned but never accessed" : " is never used");
                this.registerProblem(navigationElement, message2, ProblemHighlightType.LIKE_UNUSED_SYMBOL, new IntentionAction[]{quickFix, new OCChangeGCCAttributeIntentionAction.SuppressFix(symbol, "unused", "__unused", true){

                    @Override
                    protected boolean isAvailable(OCSymbol symbol) {
                        return !(symbol instanceof OCClassSymbol) && !(symbol instanceof OCPropertySymbol) && !(symbol instanceof OCMacroSymbol) && symbol.getKind() != OCSymbolKind.ENUM_CONST;
                    }
                }});
            }
        }

        private boolean findReferences(OCSymbol symbol, Query<PsiReference> search, CommonProcessors.FindFirstProcessor<PsiReference> finder, Ref<Boolean> hasWrites) {
            if (OCUnusedCodeInspection.isWritableSymbol(symbol)) {
                Condition isAccess = reference -> new OCReadWriteAccessDetector().getExpressionAccess(reference.getElement()) != ReadWriteAccessDetector.Access.Write;
                OCCommonProcessors.OrderedProcessor<PsiReference> processor2 = new OCCommonProcessors.OrderedProcessor<PsiReference>((Processor<PsiReference>)finder, (Condition<T>[])new Condition[]{isAccess, Conditions.alwaysTrue()});
                search.forEach(processor2);
                processor2.finish();
                if (finder.isFound()) {
                    if (isAccess.value(finder.getFoundValue())) {
                        return true;
                    }
                    hasWrites.set((Object)true);
                }
            } else {
                search.forEach(finder);
                if (finder.isFound()) {
                    return true;
                }
            }
            return false;
        }

        private boolean performAuxPropertySearches(OCPropertySymbol symbol, SearchScope scope, CommonProcessors.FindFirstProcessor<PsiReference> finder, ReferencesSearch.SearchParameters searchParameters, Ref<Boolean> hasWrites) {
            ExecutorsQuery query = new ExecutorsQuery((Object)searchParameters, Collections.singletonList(new OCPropertyReferencesSearch()));
            if (this.findReferences(symbol, (Query<PsiReference>)query, finder, hasWrites)) {
                return true;
            }
            OCInstanceVariableSymbol ivar = symbol.getAssociatedIvar();
            if (ivar != null) {
                if (ivar.getGeneratedFromProperty() == null) {
                    return false;
                }
                if ((scope = this.getIvarScope(ivar, scope)) == null) {
                    return false;
                }
                Object element = ivar.locateDefinition();
                if (element == null) {
                    element = new OCSymbolHolderVirtualPsiElement(ivar);
                }
                searchParameters = new ReferencesSearch.SearchParameters(element, scope, false);
                finder = new CommonProcessors.FindFirstProcessor<PsiReference>(){

                    protected boolean accept(PsiReference reference) {
                        return !(reference.getElement().getParent() instanceof OCSynthesizeProperty);
                    }
                };
                if (this.findReferences(ivar, (Query<PsiReference>)ReferencesSearch.search((ReferencesSearch.SearchParameters)searchParameters), finder, hasWrites)) {
                    return true;
                }
            }
            return false;
        }

        @Nullable
        private SearchScope getIvarScope(OCInstanceVariableSymbol symbol, SearchScope scope) {
            if (symbol.getVisibility() == OCVisibility.PRIVATE) {
                OCClassDeclarationBase implementation;
                OCImplementationSymbol implementationSymbol = ((OCClassSymbol)symbol.getParent()).getImplementation();
                OCClassDeclarationBase oCClassDeclarationBase = implementation = implementationSymbol != null ? (OCClassDeclarationBase)implementationSymbol.locateDefinition() : null;
                if (implementation != null) {
                    if (this.myScope instanceof GlobalSearchScope && !((GlobalSearchScope)this.myScope).accept(implementationSymbol.getContainingFile())) {
                        return null;
                    }
                    return new LocalSearchScope((PsiElement)implementation);
                }
                return null;
            }
            return scope;
        }
    }
}

