/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.inspections;

import com.intellij.psi.PsiElement;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.inspections.OCUnusedCodeInspection;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCTemplateParameterList;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.psi.OCTypeParameterDeclaration;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import org.jetbrains.annotations.NotNull;

public class OCUnusedTemplateParameterInspection
extends OCUnusedCodeInspection {
    @Override
    @NotNull
    public OCUnusedCodeInspection.UnusedVisitor buildVisitor() {
        return new OCUnusedCodeInspection.UnusedVisitor(){

            @Override
            public void visitTypeParameterDeclaration(OCTypeParameterDeclaration declaration2) {
                if (!OCUnusedTemplateParameterInspection.isTraitTemplateParameter((OCTemplateParameterList)declaration2.getParent())) {
                    OCSymbol symbol = this.getSymbol(declaration2);
                    this.checkSymbolUsed(declaration2, symbol);
                }
            }
        };
    }

    public static boolean isTraitTemplateParameter(OCTemplateParameterList templateParameterList) {
        PsiElement parent = templateParameterList.getParent();
        OCSymbolWithQualifiedName parentSymbol = null;
        if (parent instanceof OCFunctionDeclaration) {
            parentSymbol = (OCSymbolWithQualifiedName)((OCFunctionDeclaration)parent).getSymbol();
        } else if (parent instanceof OCDeclaration) {
            OCTypeElement typeElement = ((OCDeclaration)parent).getTypeElement();
            OCType type2 = typeElement != null ? typeElement.getType().resolve(templateParameterList.getContainingFile()) : null;
            parentSymbol = type2 instanceof OCStructType ? ((OCStructType)type2).getSymbol() : null;
        }
        final OCSymbolWithQualifiedName finalParentSymbol = parentSymbol;
        return parentSymbol != null && !parentSymbol.processSameSymbols((Processor<OCSymbol>)new CommonProcessors.FindProcessor<OCSymbol>(){

            protected boolean accept(OCSymbol symbol) {
                return symbol != finalParentSymbol;
            }
        });
    }
}

