/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.intentions;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.CommonProcessors;
import com.jetbrains.cidr.lang.generate.actions.OCGenerateMethodActionContext;
import com.jetbrains.cidr.lang.generate.actions.OCObjCActionContext;
import com.jetbrains.cidr.lang.generate.handlers.OCClassActionHandlerBase;
import com.jetbrains.cidr.lang.generate.handlers.OCGenerateInitWithHandler;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCIfStatement;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCMethodSelectorPart;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.psi.visitors.OCRecursiveVisitor;
import com.jetbrains.cidr.lang.quickfixes.OCReleaseVariablesIntentionAction;
import com.jetbrains.cidr.lang.refactoring.OCNameSuggester;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeSignatureActionHandler;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeSignatureHandler;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCParameterInfo;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCAddParametersToInitWithIntentionAction
extends OCClassActionHandlerBase<OCClassSymbol, OCMethodSymbol, OCObjCActionContext<OCMethodSymbol>>
implements IntentionAction {
    @NotNull
    public String getText() {
        return "Add as a parameter to 'initWith...'";
    }

    @Override
    protected String getActionTitle() {
        return "Add Parameter to 'initWith...'";
    }

    @Override
    protected String getMembersChooserTitle() {
        return "Select 'initWith...' Method to Update";
    }

    @Override
    protected Class<? extends OCSymbolDeclarator> getParentClass() {
        return OCClassDeclaration.class;
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        return OCAddParametersToInitWithIntentionAction.getInstanceVariable(editor, file2) != null;
    }

    @Nullable
    private static OCInstanceVariableSymbol getInstanceVariable(Editor editor, PsiFile file2) {
        OCDeclaration declaration2;
        PsiElement element = file2.findElementAt(editor.getCaretModel().getOffset());
        OCDeclarator declarator = OCElementUtil.getAdjacentParentOfType(element, OCDeclarator.class);
        if (declarator == null && (declaration2 = (OCDeclaration)PsiTreeUtil.getContextOfType((PsiElement)element, (Class[])new Class[]{OCDeclaration.class})) != null && declaration2.getDeclarators().size() > 0) {
            declarator = declaration2.getDeclarators().get(0);
        }
        if (declarator == null) {
            return null;
        }
        OCSymbol symbol = declarator.getSymbol();
        if (symbol instanceof OCInstanceVariableSymbol) {
            return (OCInstanceVariableSymbol)symbol;
        }
        if (symbol instanceof OCPropertySymbol) {
            return ((OCPropertySymbol)symbol).getAssociatedIvar();
        }
        return null;
    }

    @Nullable
    private static PsiElement getTargetInitializationBlock(OCMethod method2) {
        if (method2 == null) {
            return null;
        }
        OCBlockStatement body2 = method2.getBody();
        if (body2 == null) {
            return null;
        }
        List<OCStatement> statements = body2.getStatements();
        if (statements.size() < 2 || !(statements.get(1) instanceof OCIfStatement)) {
            return null;
        }
        OCIfStatement ifStmt = (OCIfStatement)statements.get(1);
        if (ifStmt.getThenBranch() instanceof OCBlockStatement) {
            return ifStmt.getThenBranch();
        }
        return null;
    }

    @Override
    protected boolean enableChooseDialog(Collection<OCMethodSymbol> candidates) {
        return candidates.size() > 1;
    }

    @Override
    protected boolean allowMultiSelection(OCObjCActionContext<OCMethodSymbol> context) {
        return false;
    }

    @Override
    protected boolean allowEmptySelection(OCObjCActionContext<OCMethodSymbol> context) {
        return true;
    }

    @Override
    @NotNull
    protected OCObjCActionContext<OCMethodSymbol> evaluateActionContext(OCClassSymbol parent, PsiElement element) {
        return new OCObjCActionContext<OCMethodSymbol>(parent, element, parent.getResolvedType(true)){

            @Override
            protected Class<OCMethodSymbol> getMemberSymbolClass() {
                return OCMethodSymbol.class;
            }

            @Override
            @NotNull
            public Collection<OCMethodSymbol> getMemberCandidates() {
                CommonProcessors.CollectProcessor collector = new CommonProcessors.CollectProcessor();
                this.getImplementationSymbol().processMembers(this.getMemberSymbolClass(), collector);
                return collector.getResults();
            }
        };
    }

    @Override
    @NotNull
    protected Condition<OCMethodSymbol> getCandidatesFilter(@NotNull OCObjCActionContext<OCMethodSymbol> actionContext) {
        return methodSymbol -> {
            if (!methodSymbol.getName().startsWith("initWith")) {
                return false;
            }
            Object method2 = methodSymbol.locateDefinition();
            return method2 instanceof OCMethod && OCAddParametersToInitWithIntentionAction.getTargetInitializationBlock((OCMethod)method2) != null;
        };
    }

    @Override
    protected void performAction(@NotNull Project project2, @Nullable Editor editor, @NotNull PsiFile file2, @NotNull OCObjCActionContext<OCMethodSymbol> context, @NotNull List<OCMethodSymbol> chosenCandidates) {
        if (!FileModificationService.getInstance().prepareFileForWrite(file2)) {
            return;
        }
        final OCInstanceVariableSymbol ivar = OCAddParametersToInitWithIntentionAction.getInstanceVariable(editor, file2);
        if (ivar == null) {
            return;
        }
        if (chosenCandidates.size() == 0) {
            new OCGenerateInitWithHandler(){

                @Override
                @NotNull
                protected OCGenerateMethodActionContext evaluateActionContext(OCClassSymbol parent, PsiElement element) {
                    OCGenerateMethodActionContext superContext = super.evaluateActionContext(parent, element);
                    return new OCGenerateMethodActionContext((OCClassSymbol)superContext.getParent(), Collections.singletonList(superContext.getBaseMethod()), superContext.getType(), element){

                        @Override
                        @NotNull
                        public Collection<OCInstanceVariableSymbol> getMemberCandidates() {
                            return Collections.singletonList(ivar);
                        }
                    };
                }

                @Override
                protected boolean enableChooseDialog(Collection<OCInstanceVariableSymbol> candidates) {
                    return false;
                }
            }.invoke(project2, editor, file2);
            return;
        }
        assert (chosenCandidates.size() == 1);
        Object method2 = chosenCandidates.get(0).locateDefinition();
        if (!(method2 instanceof OCMethod)) {
            return;
        }
        OCClassDeclaration methodParent = (OCClassDeclaration)PsiTreeUtil.getParentOfType(method2, OCClassDeclaration.class);
        OCChangeSignatureHandler handler2 = OCChangeSignatureActionHandler.getHandler((OCCallable)method2, method2);
        final OCParameterInfo newParameter = handler2.addParameter(OCNameSuggester.getNonCollidingName(ivar, true), OCNameSuggester.getNonCollidingName(ivar), ivar.getType(), -1, false);
        handler2.getGeneratedInfo().runOnSuccess(() -> {
            for (final OCCallable callable : handler2.getNewCallables()) {
                if (methodParent != PsiTreeUtil.getParentOfType((PsiElement)callable, OCClassDeclaration.class)) continue;
                PsiElement block = OCAddParametersToInitWithIntentionAction.getTargetInitializationBlock((OCMethod)callable);
                if (block != null) {
                    OCCodeStyleSettings settings = (OCCodeStyleSettings)CodeStyleSettingsManager.getSettings((Project)project2).getCustomSettings(OCCodeStyleSettings.class);
                    ArrayList<OCInstanceVariableSymbol> nonReleasedIvars = new ArrayList<OCInstanceVariableSymbol>();
                    boolean useSetters = settings != null && settings.USE_SETTERS_IN_CONSTRUCTOR;
                    boolean retainObjects = settings == null || settings.RETAIN_OBJECT_PARAMETERS_IN_CONSTRUCTOR;
                    PsiFile file1 = block.getContainingFile();
                    String text = OCGenerateInitWithHandler.getInitializerText(Collections.singletonList(ivar), Collections.singletonList(newParameter), newParameter.getOldIndex(), file1, useSetters, retainObjects, nonReleasedIvars);
                    OCChangeUtil.add(block, OCElementFactory.statementFromText(text, block));
                    if (!nonReleasedIvars.isEmpty()) {
                        Document document = PsiDocumentManager.getInstance((Project)project2).getDocument(file1);
                        if (document != null) {
                            PsiDocumentManager.getInstance((Project)project2).doPostponedOperationsAndUnblockDocument(document);
                        }
                        new OCReleaseVariablesIntentionAction((List<? extends OCSymbol>)nonReleasedIvars).invoke(project2, editor, file1);
                    }
                }
                List<OCMethodSelectorPart> parameters2 = ((OCMethod)callable).getParameters();
                int index = -1;
                for (int i2 = 0; i2 < parameters2.size(); ++i2) {
                    if (!newParameter.getName().equals(parameters2.get(i2).getParameterName())) continue;
                    index = i2;
                }
                if (index == -1) {
                    return;
                }
                String objectMethodName = OCGenerateInitWithHandler.getObjectMethodSignature(((OCMethod)method2).getSelector(), false, context.getType(), file2);
                for (PsiElement child : methodParent.getChildren()) {
                    if (!(child instanceof OCMethod) || !((OCMethod)child).getSelector().equals(objectMethodName)) continue;
                    final int finalIndex = index;
                    child.accept((PsiElementVisitor)new OCRecursiveVisitor(){

                        @Override
                        public void visitSendMessageExpression(OCSendMessageExpression expression2) {
                            List<OCExpression> params;
                            if (expression2.getMessageSelector().equals(((OCMethod)callable).getSelector()) && (params = expression2.getArgumentExpressions()).size() > finalIndex) {
                                OCChangeUtil.replaceHandlingMacros(params.get(finalIndex), OCElementFactory.expressionFromText(newParameter.getName(), expression2));
                            }
                        }
                    });
                    OCChangeSignatureHandler objectHandler = OCChangeSignatureActionHandler.getHandler((OCCallable)child, child, true);
                    objectHandler.insertParameter(newParameter.getSelector(), newParameter.getName(), newParameter.getType(), finalIndex, -1, false);
                    objectHandler.invokeSynchronously();
                }
                return;
            }
        });
        handler2.setTitle(this.getActionTitle());
        handler2.invoke();
    }
}

