/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.intentions;

import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCConditionalExpression;
import com.jetbrains.cidr.lang.psi.OCDeclarationOrExpression;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCIfStatement;
import com.jetbrains.cidr.lang.psi.OCReturnStatement;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import org.jetbrains.annotations.NotNull;

public class OCConvertIfToTernaryIntentionAction
extends PsiElementBaseIntentionAction {
    public boolean isAvailable(@NotNull Project project2, Editor editor, @NotNull PsiElement element) {
        return this.createConverter(element).isAvailable();
    }

    public void invoke(@NotNull Project project2, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        this.createConverter(element).invoke();
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    @NotNull
    public String getText() {
        return "Replace 'if else' with '?:'";
    }

    protected Converter createConverter(PsiElement element) {
        return new Converter(element);
    }

    protected OCExpression getNewExpression(Converter converter) {
        OCConditionalExpression result2 = (OCConditionalExpression)OCElementFactory.expressionFromText("1 ? 2 : 3", converter.getThenExpression());
        OCParenthesesUtils.replaceExpressionAndRemoveAppendParentheses(result2.getCondition(), converter.getCondition());
        if (OCParenthesesUtils.areExpressionsEquivalent(converter.getCondition(), converter.getThenExpression(), false, new OCResolveContext(converter.getThenExpression()))) {
            OCChangeUtil.delete(result2.getPositiveExpression(false));
        } else {
            OCParenthesesUtils.replaceExpressionAndRemoveAppendParentheses(result2.getPositiveExpression(false), converter.getThenExpression());
        }
        OCParenthesesUtils.replaceExpressionAndRemoveAppendParentheses(result2.getNegativeExpression(), converter.getElseExpression());
        return result2;
    }

    public class Converter {
        private OCStatement myThenStatement;
        private OCStatement myElseStatement;
        private OCStatement myOriginalElseStatement;
        private OCExpression myThenExpression;
        private OCExpression myElseExpression;
        private OCExpression myCondition;
        private OCIfStatement myStatement;

        public Converter(PsiElement element) {
            PsiElement second;
            PsiElement first;
            PsiElement sibling;
            OCIfStatement statement2 = (OCIfStatement)PsiTreeUtil.getParentOfType((PsiElement)element, OCIfStatement.class, (boolean)false);
            if (statement2 == null) {
                return;
            }
            this.myStatement = statement2;
            OCDeclarationOrExpression condition2 = statement2.getCondition();
            if (condition2 == null || condition2.getExpression() == null) {
                return;
            }
            this.myCondition = condition2.getExpression();
            this.myThenStatement = statement2.getThenBranch();
            this.myElseStatement = statement2.getElseBranch();
            if (this.myElseStatement == null && (sibling = PsiTreeUtil.skipSiblingsForward((PsiElement)statement2, (Class[])new Class[]{PsiWhiteSpace.class, PsiComment.class})) instanceof OCReturnStatement) {
                this.myElseStatement = (OCStatement)sibling;
            }
            this.myOriginalElseStatement = this.myElseStatement;
            while (this.myThenStatement instanceof OCBlockStatement && ((OCBlockStatement)this.myThenStatement).getStatements().size() == 1) {
                this.myThenStatement = ((OCBlockStatement)this.myThenStatement).getStatements().get(0);
            }
            while (this.myElseStatement instanceof OCBlockStatement && ((OCBlockStatement)this.myElseStatement).getStatements().size() == 1) {
                this.myElseStatement = ((OCBlockStatement)this.myElseStatement).getStatements().get(0);
            }
            if (this.myThenStatement == null || this.myElseStatement == null) {
                return;
            }
            Pair<PsiElement, PsiElement> diff = OCElementUtil.getElementsDiff(this.myThenStatement, this.myElseStatement);
            if (diff == null) {
                return;
            }
            for (first = (PsiElement)diff.first; first != null && !(first instanceof OCExpression) && first != this.myThenStatement; first = first.getParent()) {
            }
            for (second = (PsiElement)diff.second; second != null && !(second instanceof OCExpression) && second != this.myElseStatement; second = second.getParent()) {
            }
            if (first instanceof OCExpression && second instanceof OCExpression) {
                this.myThenExpression = (OCExpression)first;
                this.myElseExpression = (OCExpression)second;
            }
        }

        public OCExpression getCondition() {
            return this.myCondition;
        }

        public OCExpression getThenExpression() {
            return this.myThenExpression;
        }

        public OCExpression getElseExpression() {
            return this.myElseExpression;
        }

        public boolean isAvailable() {
            OCType guessedType2;
            if (this.myThenExpression == null || this.myElseExpression == null) {
                return false;
            }
            if (!OCCodeInsightUtil.isValid(this.myThenExpression)) {
                return false;
            }
            if (!OCCodeInsightUtil.isValid(this.myThenStatement)) {
                return false;
            }
            if (!OCCodeInsightUtil.isValid(this.myElseExpression)) {
                return false;
            }
            if (!OCCodeInsightUtil.isValid(this.myElseStatement)) {
                return false;
            }
            if (!OCCodeInsightUtil.isValid(this.myCondition)) {
                return false;
            }
            OCType guessedType1 = this.myThenExpression.getResolvedType().getGuessedType();
            OCType type2 = guessedType1.getLeastCommonType(guessedType2 = this.myElseExpression.getResolvedType().getGuessedType(), this.myThenExpression);
            return !type2.isUnknown() && !type2.isVoid();
        }

        public void invoke() {
            OCExpression result2 = OCConvertIfToTernaryIntentionAction.this.getNewExpression(this);
            OCParenthesesUtils.replaceExpressionAndRemoveAppendParentheses(this.myThenExpression, result2);
            OCChangeUtil.replaceHandlingMacros(this.myStatement, this.myThenStatement);
            OCChangeUtil.delete(this.myOriginalElseStatement);
        }
    }
}

