/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.intentions;

import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.cidr.lang.inspections.OCSimplifyInspection;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCIfStatement;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import java.util.List;

public abstract class OCConvertToIfIntentionActionBase
extends PsiElementBaseIntentionAction {
    protected void invoke(OCExpression expression2, OCExpression condition2, OCExpression positiveExpression, OCExpression negativeExpression) {
        condition2 = OCParenthesesUtils.diveIntoParentheses(condition2);
        positiveExpression = OCParenthesesUtils.diveIntoParentheses(positiveExpression);
        negativeExpression = OCParenthesesUtils.diveIntoParentheses(negativeExpression);
        PsiElement parent = PsiTreeUtil.getParentOfType((PsiElement)expression2, (Class[])new Class[]{OCStatement.class, OCDeclarator.class});
        OCStatement statement2 = (OCStatement)PsiTreeUtil.getParentOfType((PsiElement)parent, OCStatement.class, (boolean)false);
        if (expression2 == null || statement2 == null) {
            return;
        }
        StringBuilder builder = new StringBuilder("if (");
        OCExpression conditionalExprWithParens = OCParenthesesUtils.topmostParenthesized(expression2);
        if (condition2 != null) {
            builder.append(condition2.getTextWithMacros());
        }
        builder.append(") {\n");
        if (parent instanceof OCDeclarator) {
            OCDeclarator declarator = (OCDeclarator)parent;
            OCExpression initializer = declarator.getInitializer();
            builder.append(declarator.getName()).append("=");
            OCConvertToIfIntentionActionBase.appendElementText(builder, initializer, conditionalExprWithParens, positiveExpression);
            builder.append(";\n}\nelse {\n").append(declarator.getName()).append("=");
            OCConvertToIfIntentionActionBase.appendElementText(builder, initializer, conditionalExprWithParens, negativeExpression);
            builder.append(";\n}");
            OCChangeUtil.delete(initializer);
        } else {
            OCConvertToIfIntentionActionBase.appendElementText(builder, statement2, conditionalExprWithParens, positiveExpression);
            builder.append("}\nelse {\n");
            OCConvertToIfIntentionActionBase.appendElementText(builder, statement2, conditionalExprWithParens, negativeExpression);
            builder.append("\n}");
        }
        OCIfStatement ifStatement = (OCIfStatement)OCElementFactory.statementFromText(builder.toString(), expression2, true);
        OCSimplifyInspection.simplify(ifStatement.getThenBranch());
        OCSimplifyInspection.simplify(ifStatement.getElseBranch());
        if (parent instanceof OCDeclarator) {
            OCChangeUtil.addAfter(statement2.getParent(), ifStatement, statement2);
        } else {
            OCChangeUtil.replaceHandlingMacros(statement2, ifStatement);
        }
    }

    private static void appendElementText(StringBuilder builder, PsiElement element, OCExpression elementToReplace, OCExpression replacement) {
        if (element == elementToReplace) {
            if (OCParenthesesUtils.isParenthesesNeededInReplacing(elementToReplace, replacement)) {
                builder.append('(').append(OCElementUtil.getTextWithMacros(replacement)).append(')');
            } else {
                builder.append(OCElementUtil.getTextWithMacros(replacement));
            }
        } else {
            List<PsiElement> children2 = OCElementUtil.getAllChildren(element);
            if (children2.size() > 0) {
                for (PsiElement child : children2) {
                    OCConvertToIfIntentionActionBase.appendElementText(builder, child, elementToReplace, replacement);
                }
            } else if (!OCElementUtil.isPartOfMacroSubstitution(element)) {
                builder.append(OCElementUtil.getTextWithMacros(element));
            }
        }
    }
}

