/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.intentions;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.jetbrains.cidr.lang.generate.actions.OCGenerateIvarsActionContext;
import com.jetbrains.cidr.lang.generate.handlers.OCGenerateIvarsHandler;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.refactoring.OCNameSuggester;
import com.jetbrains.cidr.lang.refactoring.introduce.OCBaseLocalConvertibleHandler;
import com.jetbrains.cidr.lang.refactoring.introduce.OCIvarInplaceIntroducer;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCConvertToIvarIntentionAction
extends OCGenerateIvarsHandler
implements IntentionAction {
    @NotNull
    public String getText() {
        return "Convert to instance variable";
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    @Override
    @Nullable
    public OCPropertySymbol locateCandidate(@NotNull Project project2, Editor editor, PsiFile file2) {
        PsiElement at = file2.findElementAt(editor.getCaretModel().getOffset());
        Object parent = OCElementUtil.getAdjacentParentOfType(at, OCReferenceElement.class, OCDeclarator.class, OCQualifiedExpression.class, OCSendMessageExpression.class);
        OCSymbol symbol = null;
        if (parent instanceof OCReferenceElement) {
            symbol = ((OCReferenceElement)parent).resolveToSymbol();
        } else if (parent instanceof OCDeclarator) {
            symbol = ((OCDeclarator)parent).getSymbol();
        } else if (parent instanceof OCQualifiedExpression) {
            symbol = ((OCQualifiedExpression)parent).resolveToSymbol();
        } else if (parent instanceof OCSendMessageExpression) {
            symbol = ((OCSendMessageExpression)parent).getProbableResponders().getKnownResponder();
        }
        if (symbol instanceof OCMethodSymbol) {
            symbol = ((OCMethodSymbol)symbol).getGeneratedFromProperty();
        }
        return symbol instanceof OCPropertySymbol ? (OCPropertySymbol)symbol : null;
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        return OCSearchScope.isInProjectSources(this.locateCandidate(project2, editor, file2));
    }

    @Override
    protected OCClassSymbol getParent(@NotNull Project project2, @NotNull Editor editor, @NotNull PsiFile file2) {
        OCPropertySymbol property = this.locateCandidate(project2, editor, file2);
        return property != null ? ((OCClassSymbol)property.getParent()).getMainInterface() : null;
    }

    @Override
    protected boolean replaceAllProperties() {
        return true;
    }

    @Override
    protected boolean enableChooseDialog(Collection<OCPropertySymbol> candidates) {
        return false;
    }

    @Override
    protected void performAction(@NotNull Project project2, Editor editor, final @NotNull PsiFile file2, final @NotNull OCGenerateIvarsActionContext context, final @NotNull List<OCPropertySymbol> properties) {
        final OCPropertySymbol property = this.locateCandidate(project2, editor, file2);
        if (property == null) {
            return;
        }
        OCInstanceVariableSymbol associatedIvar = property.getAssociatedIvar();
        PsiElement at = file2.findElementAt(editor.getCaretModel().getOffset());
        final OCElement element = (OCElement)OCElementUtil.getAdjacentParentOfType(at, OCReferenceElement.class, OCDeclarator.class, OCQualifiedExpression.class, OCSendMessageExpression.class);
        final String ivarName = associatedIvar != null ? associatedIvar.getName() : OCNameSuggester.getNonCollidingName(property, true);
        final SmartPsiElementPointer pointer = SmartPointerManager.getInstance((Project)project2).createSmartPsiElementPointer((PsiElement)element);
        OCBaseLocalConvertibleHandler handler2 = new OCBaseLocalConvertibleHandler("Introduce Ivar"){

            protected OCIvarInplaceIntroducer createIntroducer(Project project2, Editor editor, PsiElement expression2, List<PsiElement> occurrences, String refactoringName) {
                return new OCIvarInplaceIntroducer(project2, editor, expression2, occurrences, refactoringName){

                    @Override
                    public PsiElement evaluateAnchor() {
                        return element;
                    }

                    public PsiElement[] getOccurrences() {
                        PsiElement[] psiElementArray;
                        PsiElement occurrence = pointer.getElement();
                        if (occurrence != null) {
                            PsiElement[] psiElementArray2 = new PsiElement[1];
                            psiElementArray = psiElementArray2;
                            psiElementArray2[0] = occurrence;
                        } else {
                            psiElementArray = PsiElement.EMPTY_ARRAY;
                        }
                        return psiElementArray;
                    }

                    @Override
                    protected void performIntroduce() {
                        OCConvertToIvarIntentionAction.this.performAction(file2, context, properties, this.getInputName(), this.myDeclareInInterfaceCb != null && !this.myDeclareInInterfaceCb.isSelected());
                    }

                    @Override
                    protected boolean askToGenerateProperty() {
                        return false;
                    }

                    @Override
                    protected String[] suggestNames(boolean replaceAll, @Nullable OCDeclarator variable) {
                        if (!ivarName.equals(property.getName())) {
                            return new String[]{ivarName, property.getName()};
                        }
                        return new String[]{ivarName};
                    }
                };
            }

            @Override
            @NotNull
            protected String getFeatureID() {
                return "refactoring.convertToIvar";
            }
        };
        handler2.invoke(project2, editor, element, property.getResolvedType(), true, false, ivarName, (OCSymbol)property.getParent());
    }
}

