/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.intentions;

import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCBinaryExpression;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCParenthesizedExpression;
import com.jetbrains.cidr.lang.psi.OCUnaryExpression;
import com.jetbrains.cidr.lang.util.OCComparisonUtils;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCDeMorganIntentionAction
extends PsiElementBaseIntentionAction {
    public boolean isAvailable(@NotNull Project project2, Editor editor, @NotNull PsiElement element) {
        OCBinaryExpression expression2 = (OCBinaryExpression)PsiTreeUtil.getParentOfType((PsiElement)element, OCBinaryExpression.class);
        if (expression2 != null && expression2.getRight() != null) {
            if (expression2.getOperationSign() == OCTokenTypes.ANDAND) {
                this.setText("Replace '&&' with '||'");
                return true;
            }
            if (expression2.getOperationSign() == OCTokenTypes.OROR) {
                this.setText("Replace '||' with '&&'");
                return true;
            }
        }
        return false;
    }

    @NotNull
    public String getFamilyName() {
        return "DeMorgan Law";
    }

    public void invoke(@NotNull Project project2, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        OCBinaryExpression expression2 = (OCBinaryExpression)PsiTreeUtil.getParentOfType((PsiElement)element, OCBinaryExpression.class);
        if (expression2 != null) {
            OCElementType sign = expression2.getOperationSign();
            PsiElement parent = expression2.getParent();
            while (OCDeMorganIntentionAction.isConjunctionExpression(parent, sign)) {
                expression2 = (OCBinaryExpression)parent;
                parent = expression2.getParent();
            }
            String newExpression = OCDeMorganIntentionAction.convertConjunctionExpression(expression2, sign);
            if (newExpression != null) {
                OCDeMorganIntentionAction.replaceExpression(newExpression, expression2);
            }
        }
    }

    @Nullable
    private static String convertConjunctionExpression(@NotNull OCBinaryExpression expression2, @NotNull OCElementType sign) {
        String leftText = OCDeMorganIntentionAction.convertExpressionPart(expression2.getLeft(), sign);
        String rightText = OCDeMorganIntentionAction.convertExpressionPart(expression2.getRight(), sign);
        if (leftText == null || rightText == null) {
            return null;
        }
        String inversedOperator = OCComparisonUtils.getInversedOperator(sign);
        return leftText + inversedOperator + rightText;
    }

    private static String convertExpressionPart(@Nullable OCExpression expression2, @NotNull OCElementType sign) {
        if (expression2 == null) {
            return null;
        }
        if (OCDeMorganIntentionAction.isConjunctionExpression(expression2, sign)) {
            return OCDeMorganIntentionAction.convertConjunctionExpression((OCBinaryExpression)expression2, sign);
        }
        return OCDeMorganIntentionAction.convertLeafExpression(expression2);
    }

    @Nullable
    private static String convertLeafExpression(@NotNull OCExpression condition2) {
        if (OCDeMorganIntentionAction.isNegated(condition2)) {
            OCExpression negated = OCDeMorganIntentionAction.stripNegation((OCUnaryExpression)condition2);
            if (negated == null) {
                return "";
            }
            if (OCParenthesesUtils.getPrecedence(negated, false) > 14) {
                return '(' + negated.getText() + ')';
            }
            return negated.getText();
        }
        if (OCComparisonUtils.isComparison(condition2)) {
            OCBinaryExpression binaryExpression = (OCBinaryExpression)condition2;
            OCElementType sign = binaryExpression.getOperationSign();
            String negatedComparison = OCComparisonUtils.getNegatedComparison(sign);
            OCExpression left = binaryExpression.getLeft();
            OCExpression right = binaryExpression.getRight();
            if (left != null && right != null) {
                return left.getText() + negatedComparison + right.getText();
            }
            return null;
        }
        if (OCParenthesesUtils.getPrecedence(condition2, false) > 3) {
            return "!(" + condition2.getText() + ')';
        }
        return '!' + condition2.getText();
    }

    private static boolean isConjunctionExpression(@Nullable PsiElement element, @NotNull OCElementType sign) {
        if (element instanceof OCBinaryExpression) {
            OCBinaryExpression binExp = (OCBinaryExpression)element;
            OCElementType tokenType = binExp.getOperationSign();
            return ((Object)((Object)tokenType)).equals((Object)sign);
        }
        return false;
    }

    private static void replaceExpression(@NotNull String newExpressionStr, @NotNull OCExpression oldExpression) throws IncorrectOperationException {
        OCExpression newExpression;
        OCExpression expressionToReplace;
        OCExpression negatedParent = OCDeMorganIntentionAction.findFirstNegatedParent(oldExpression);
        OCExpression oCExpression = expressionToReplace = negatedParent != null ? negatedParent : oldExpression;
        if (negatedParent == null) {
            newExpressionStr = "!(" + newExpressionStr + ")";
        }
        if ((newExpression = OCElementFactory.expressionFromText(newExpressionStr, oldExpression)) == null) {
            return;
        }
        boolean parenthesesAreRequired = OCDeMorganIntentionAction.parenthesesAreRequired(newExpression, expressionToReplace);
        expressionToReplace.replace(parenthesesAreRequired ? OCParenthesesUtils.appendParentheses(newExpression) : newExpression);
    }

    @Nullable
    private static OCExpression findFirstNegatedParent(@NotNull OCExpression expression2) {
        OCUnaryExpression prefixAncestor;
        OCExpression ancestor = expression2;
        while (ancestor.getParent() instanceof OCParenthesizedExpression) {
            ancestor = (OCExpression)ancestor.getParent();
        }
        if (ancestor.getParent() instanceof OCUnaryExpression && OCTokenTypes.EXCL == (prefixAncestor = (OCUnaryExpression)ancestor.getParent()).getOperationSign()) {
            return prefixAncestor;
        }
        return null;
    }

    private static boolean isNegated(@Nullable OCExpression expression2) {
        if (expression2 instanceof OCUnaryExpression) {
            OCUnaryExpression unary = (OCUnaryExpression)expression2;
            return unary.getOperationSign() == OCTokenTypes.EXCL;
        }
        return false;
    }

    @Nullable
    private static OCExpression stripNegation(@NotNull OCUnaryExpression expression2) {
        OCExpression operand2 = expression2.getOperand();
        if (operand2 != null) {
            return OCParenthesesUtils.diveIntoParentheses(operand2);
        }
        return null;
    }

    private static boolean parenthesesAreRequired(@NotNull OCExpression newExpression, @NotNull OCExpression sourceExpression) {
        if (newExpression instanceof OCParenthesizedExpression) {
            return false;
        }
        PsiElement parent = sourceExpression.getParent();
        if (!(parent instanceof OCExpression)) {
            return false;
        }
        OCExpression parentExpression = (OCExpression)parent;
        int newExpressionPrecedence = OCParenthesesUtils.getPrecedence(newExpression, false);
        int parentExpressionPrecedence = OCParenthesesUtils.getPrecedence(parentExpression, false);
        if (newExpressionPrecedence <= 0 || parentExpressionPrecedence <= 0) {
            return false;
        }
        return newExpressionPrecedence > parentExpressionPrecedence;
    }
}

