/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.intentions;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.actions.newFile.OCNewFileActionBase;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCImplementation;
import com.jetbrains.cidr.lang.psi.OCInterface;
import com.jetbrains.cidr.lang.psi.OCProtocol;
import com.jetbrains.cidr.lang.refactoring.move.handlers.OCExtractSuperProtocolHandler;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import org.jetbrains.annotations.NotNull;

public class OCExtractProtocolIntentionAction
implements IntentionAction {
    @NotNull
    public String getText() {
        return "Extract protocol of this class";
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        PsiElement element = file2.findElementAt(editor.getCaretModel().getOffset());
        if (OCNewFileActionBase.isNewFileActionSupported() && element != null && OCCodeInsightUtil.isValid((PsiElement)file2) && (OCElementUtil.getElementType(element) == OCTokenTypes.IDENTIFIER || OCElementUtil.getElementType(element.getPrevSibling()) == OCTokenTypes.IDENTIFIER)) {
            PsiElement parent = element.getParent();
            return parent instanceof OCInterface || parent instanceof OCImplementation || parent instanceof OCProtocol;
        }
        return false;
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) throws IncorrectOperationException {
        new OCExtractSuperProtocolHandler().invoke(project2, editor, file2, SimpleDataContext.getProjectContext(project2));
    }

    public boolean startInWriteAction() {
        return false;
    }
}

