/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.intentions;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.generate.OCCaretLocation;
import com.jetbrains.cidr.lang.generate.OCCppDefinitionsUtil;
import com.jetbrains.cidr.lang.generate.OCGenerateUtil;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCGenerateDefinitionsIntentionActionBase
implements IntentionAction {
    @Nls
    @NotNull
    public String getFamilyName() {
        return OCBundle.message("generate.definitions.intention.familyName", new Object[0]);
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        assert (editor != null);
        return OCGenerateDefinitionsIntentionActionBase.isAvailable(OCGenerateDefinitionsIntentionActionBase.findFunction(editor, file2));
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) throws IncorrectOperationException {
        PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
        OCFunctionSymbol symbol = OCGenerateDefinitionsIntentionActionBase.findFunction(editor, file2);
        if (OCGenerateDefinitionsIntentionActionBase.isAvailable(symbol)) {
            List<OCGenerateUtil.Replacement> replacements = OCCppDefinitionsUtil.getGenerateDefinitionReplacements(OCCaretLocation.byFile(file2), OCCppDefinitionsUtil.getFunctionParent(symbol), Collections.singletonList(symbol), Collections.singletonList(symbol.locateFunctionDefinition()), OCCppDefinitionsUtil.InlinePolicy.get(this.isInline()));
            WriteCommandAction.runWriteCommandAction((Project)project2, (String)OCBundle.message("generate.definitions.commandName", new Object[0]), null, () -> OCGenerateUtil.applyReplacements(project2, replacements, true), (PsiFile[])OCGenerateUtil.getAffectedFiles(replacements).toArray(PsiFile.EMPTY_ARRAY));
        }
    }

    public boolean startInWriteAction() {
        return false;
    }

    protected abstract boolean isInline();

    @Nullable
    private static OCFunctionSymbol findFunction(@NotNull Editor editor, @NotNull PsiFile file2) {
        PsiElement at = file2.findElementAt(editor.getCaretModel().getOffset());
        OCFunctionDeclaration function = (OCFunctionDeclaration)PsiTreeUtil.getParentOfType((PsiElement)at, OCFunctionDeclaration.class);
        OCSymbolWithQualifiedName symbol = function != null ? (OCSymbolWithQualifiedName)function.getSymbol() : null;
        return (OCFunctionSymbol)ObjectUtils.tryCast((Object)symbol, OCFunctionSymbol.class);
    }

    @Contract(value="null -> false")
    private static boolean isAvailable(OCFunctionSymbol function) {
        return function != null && OCCppDefinitionsUtil.shouldGenerateDefinitionsFor(function, true) == OCCppDefinitionsUtil.SHOULD_GENERATE_DEFINITION.POSSIBLE;
    }
}

